/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.HullModFleetEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.hullmods.BaseLogisticsHullMod;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class HighResSensors
extends BaseLogisticsHullMod
implements HullModFleetEffect {
    public static float MIN_CR = 0.1f;
    public static String MOD_KEY = "core_HighResSensors";
    private static Map combatMag = new HashMap();
    private static Map mag = new HashMap();

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(50.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(75.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(100.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(150.0f));
        combatMag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(1000.0f));
        combatMag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(1500.0f));
        combatMag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(2000.0f));
        combatMag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(2500.0f));
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("hrs_sensor_range_mod").modifyFlat(id, ((Float)mag.get((Object)hullSize)).floatValue());
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            float mag = ((Float)combatMag.get((Object)hullSize)).intValue();
            stats.getSightRadiusMod().modifyFlat(id, mag);
        }
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + ((Float)combatMag.get((Object)ShipAPI.HullSize.FRIGATE)).intValue();
        }
        if (index == 1) {
            return "" + ((Float)combatMag.get((Object)ShipAPI.HullSize.DESTROYER)).intValue();
        }
        if (index == 2) {
            return "" + ((Float)combatMag.get((Object)ShipAPI.HullSize.CRUISER)).intValue();
        }
        if (index == 3) {
            return "" + ((Float)combatMag.get((Object)ShipAPI.HullSize.CAPITAL_SHIP)).intValue();
        }
        return null;
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public void advanceInCampaign(CampaignFleetAPI fleet) {
    }

    public boolean withAdvanceInCampaign() {
        return false;
    }

    public boolean withOnFleetSync() {
        return true;
    }

    public void onFleetSync(CampaignFleetAPI fleet) {
        float modifier = HighResSensors.getAdjustedHRSModifier(fleet, null, 0.0f);
        if (modifier <= 0.0f) {
            fleet.getSensorRangeMod().unmodifyFlat(MOD_KEY);
        } else {
            fleet.getSensorRangeMod().modifyFlat(MOD_KEY, modifier, "Ships with high resolution sensors");
        }
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("A ship with high resolution sensors increases the fleet's sensor range by %s/%s/%s/%s, depending on hull size. Each additional ship with high resolution sensors provides diminishing returns. The higher the highest sensor range increase from a single ship in the fleet, the later diminishing returns kick in.", opad, h, "" + ((Float)mag.get((Object)ShipAPI.HullSize.FRIGATE)).intValue(), "" + ((Float)mag.get((Object)ShipAPI.HullSize.DESTROYER)).intValue(), "" + ((Float)mag.get((Object)ShipAPI.HullSize.CRUISER)).intValue(), "" + ((Float)mag.get((Object)ShipAPI.HullSize.CAPITAL_SHIP)).intValue());
        if (isForModSpec || ship == null) {
            return;
        }
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float fleetMod = HighResSensors.getAdjustedHRSModifier(fleet, null, 0.0f);
        float currShipMod = ((Float)mag.get((Object)hullSize)).floatValue();
        float fleetModWithOneMore = HighResSensors.getAdjustedHRSModifier(fleet, null, currShipMod);
        float fleetModWithoutThisShip = HighResSensors.getAdjustedHRSModifier(fleet, ship.getFleetMemberId(), 0.0f);
        tooltip.addPara("The total sensor strength increase for your fleet is %s.", opad, h, "" + Math.round(fleetMod));
        float cr = ship.getCurrentCR();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getId().equals(ship.getFleetMemberId())) continue;
            cr = member.getRepairTracker().getCR();
        }
        if (cr < MIN_CR) {
            LabelAPI label = tooltip.addPara("This ship's combat readiness is below %s and its high resolution sensors can not be utilized. Bringing this ship into readiness would increase the fleetwide bonus to %s.", opad, h, Math.round(MIN_CR * 100.0f) + "%", "" + Math.round(fleetModWithOneMore));
            label.setHighlightColors(bad, h);
            label.setHighlight(Math.round(MIN_CR * 100.0f) + "%", "" + Math.round(fleetModWithOneMore));
        } else if (fleetMod > currShipMod) {
            tooltip.addPara("Removing this ship would decrease it to %s. Adding another ship of the same type would increase it to %s.", opad, h, "" + Math.round(fleetModWithoutThisShip), "" + Math.round(fleetModWithOneMore));
        } else {
            tooltip.addPara("Adding another ship of the same type would increase it to %s.", opad, h, "" + Math.round(fleetModWithOneMore));
        }
    }

    public static float getAdjustedHRSModifier(CampaignFleetAPI fleet, String skipId, float add) {
        float max = 0.0f;
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float v;
            if (member.isMothballed() || member.getRepairTracker().getCR() < MIN_CR || member.getId().equals(skipId) || (v = member.getStats().getDynamic().getMod("hrs_sensor_range_mod").computeEffective(0.0f)) <= 0.0f) continue;
            if (v > max) {
                max = v;
            }
            total += v;
        }
        if (add > max) {
            max = add;
        }
        total += add;
        if (max <= 0.0f) {
            return 0.0f;
        }
        float units = total / max;
        if (units <= 1.0f) {
            return max;
        }
        float mult = Misc.logOfBase(2.5f, units) + 1.0f;
        float result = total * mult / units;
        if (result <= 0.0f) {
            result = 0.0f;
        } else {
            result = (float)Math.round(result * 100.0f) / 100.0f;
            result = Math.max(result, 1.0f);
        }
        return result;
    }
}

