/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.campaign.skills.NeuralLinkScript;
import com.fs.starfarer.api.impl.campaign.skills.SupportDoctrine;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class NeuralInterface
extends BaseHullMod {
    public static float SYSTEM_RESET_TIMEOUT_MULT = 2.0f;
    public static final String SYSTEM_RESET_TIMEOUT_KEY = "neural_interface_reset_timeout";

    public void advanceInCombat(ShipAPI ship, float amount) {
        String key = SYSTEM_RESET_TIMEOUT_KEY;
        Float timeout = (Float)ship.getCustomData().get(key);
        if (timeout == null) {
            timeout = Float.valueOf(0.0f);
        }
        if ((timeout = Float.valueOf(timeout.floatValue() - amount)).floatValue() < 0.0f) {
            timeout = Float.valueOf(0.0f);
        }
        ship.setCustomData(key, timeout);
        if (ship == Global.getCombatEngine().getPlayerShip()) {
            if (ship.getCustomData().containsKey("neural_transfer_complete_key")) {
                ShipSystemAPI system = ship.getSystem();
                if (system != null && timeout.floatValue() <= 0.0f) {
                    boolean didSomething = false;
                    float maxTimeout = 0.0f;
                    if (system.getCooldownRemaining() > 0.0f && system.isCoolingDown()) {
                        maxTimeout = Math.max(system.getCooldownRemaining(), maxTimeout);
                        system.setCooldownRemaining(0.0f);
                        didSomething = true;
                    }
                    if (system.getAmmo() < system.getMaxAmmo() && system.getAmmoPerSecond() > 0.0f) {
                        system.setAmmo(system.getAmmo() + 1);
                        didSomething = true;
                        maxTimeout = Math.max(1.0f / system.getAmmoPerSecond() * (1.0f - system.getAmmoReloadProgress()), maxTimeout);
                    }
                    if (maxTimeout > 0.0f) {
                        ship.setCustomData(key, Float.valueOf(maxTimeout *= SYSTEM_RESET_TIMEOUT_MULT));
                    }
                }
                ship.removeCustomData("neural_transfer_complete_key");
            }
        } else {
            ship.removeCustomData("neural_transfer_complete_key");
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("custom_production_mod").modifyFlat(id, 1.0f);
        stats.getDynamic().getMod("deployment_points_mod").unmodify(SupportDoctrine.SUPPORT_DOCTRINE_DP_REDUCTION_ID);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + (int)NeuralLinkScript.INSTANT_TRANSFER_DP;
        }
        return null;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color g = Misc.getGrayColor();
        tooltip.addSectionHeading("Neural system reset", Alignment.MID, opad);
        tooltip.addPara("After the transfer is complete, the target ship's system cooldown (if any) will be reset, and if the ship system uses charges, it will gain an additonal charge. This effect operates on a cooldown equal to %s the cooldown/charge regeneration time saved by it.", opad, h, (int)SYSTEM_RESET_TIMEOUT_MULT + "\u00d7");
        if (Global.getCurrentState() == GameState.CAMPAIGN && Global.getSector().getPlayerStats().getDynamic().getMod("custom_production_mod").computeEffective(0.0f) <= 0.0f) {
            tooltip.addPara("Requires the Neural Link skill to function", Misc.getNegativeHighlightColor(), opad);
        }
        if (isForModSpec || ship == null) {
            return;
        }
        String control = Global.getSettings().getControlStringForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
        String desc = Global.getSettings().getControlDescriptionForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
        tooltip.addPara("Use the \"" + desc + "\" control [" + control + "] to switch between ships.", opad, g, h, control);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (Misc.isAutomated(ship)) {
            return false;
        }
        return !ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK);
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (Misc.isAutomated(ship)) {
            return "Can not be installed on automated ships, install Neural Integrator instead";
        }
        if (ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK)) {
            return "Can not be installed on this ship";
        }
        return null;
    }
}

