/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.HullDamageAboutToBeTakenListener;
import com.fs.starfarer.api.impl.campaign.skills.NeuralLinkScript;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class PhaseAnchor
extends BaseHullMod {
    public static float PHASE_DISSIPATION_MULT = 2.0f;
    public static float ACTIVATION_COST_MULT = 0.0f;
    public static float CR_LOSS_MULT_FOR_EMERGENCY_DIVE = 1.0f;

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new PhaseAnchorScript(ship));
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getPhaseCloakActivationCostBonus().modifyMult(id, 0.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "zero";
        }
        if (index == 1) {
            return (int)PHASE_DISSIPATION_MULT + "\u00d7";
        }
        if (index == 2) {
            return (int)CR_LOSS_MULT_FOR_EMERGENCY_DIVE + "\u00d7";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("adaptive_coils")) {
            return false;
        }
        return ship.getHullSpec().isPhase();
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("adaptive_coils")) {
            return "Incompatible with Adaptive Phase Coils";
        }
        if (!ship.getHullSpec().isPhase()) {
            return "Can only be installed on phase ships";
        }
        return super.getUnapplicableReason(ship);
    }

    public static class PhaseAnchorScript
    implements AdvanceableListener,
    HullDamageAboutToBeTakenListener {
        public ShipAPI ship;
        public boolean emergencyDive = false;
        public float diveProgress = 0.0f;
        public FaderUtil diveFader = new FaderUtil(1.0f, 1.0f);

        public PhaseAnchorScript(ShipAPI ship) {
            this.ship = ship;
        }

        public boolean notifyAboutToTakeHullDamage(Object param, ShipAPI ship, Vector2f point, float damageAmount) {
            if (!this.emergencyDive) {
                String key = "phaseAnchor_canDive";
                boolean canDive = !Global.getCombatEngine().getCustomData().containsKey(key);
                float depCost = 0.0f;
                if (ship.getFleetMember() != null) {
                    depCost = ship.getFleetMember().getDeployCost();
                }
                float crLoss = CR_LOSS_MULT_FOR_EMERGENCY_DIVE * depCost;
                float hull = ship.getHitpoints();
                if (damageAmount >= hull && (canDive &= ship.getCurrentCR() >= crLoss)) {
                    ship.setHitpoints(1.0f);
                    if (ship.getFleetMember() != null) {
                        ship.getFleetMember().getRepairTracker().applyCREvent(-crLoss, "Emergency phase dive");
                    }
                    this.emergencyDive = true;
                    Global.getCombatEngine().getCustomData().put(key, true);
                    if (!ship.isPhased()) {
                        Global.getSoundPlayer().playSound("system_phase_cloak_activate", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
                    }
                }
            }
            return this.emergencyDive;
        }

        public void advance(float amount) {
            String id = "phase_anchor_modifier";
            if (this.emergencyDive) {
                Color c = this.ship.getPhaseCloak().getSpecAPI().getEffectColor2();
                c = Misc.setAlpha(c, 255);
                c = Misc.interpolateColor(c, Color.white, 0.5f);
                if (this.diveProgress == 0.0f && this.ship.getFluxTracker().showFloaty()) {
                    float timeMult = this.ship.getMutableStats().getTimeMult().getModifiedValue();
                    Global.getCombatEngine().addFloatingTextAlways(this.ship.getLocation(), "Emergency dive!", NeuralLinkScript.getFloatySize(this.ship), c, this.ship, 16.0f * timeMult, 3.2f / timeMult, 1.0f / timeMult, 0.0f, 0.0f, 1.0f);
                }
                this.diveFader.advance(amount);
                this.ship.setRetreating(true, false);
                this.ship.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                this.diveProgress += amount * this.ship.getPhaseCloak().getChargeUpDur();
                float curr = this.ship.getExtraAlphaMult();
                this.ship.getPhaseCloak().forceState(ShipSystemAPI.SystemState.IN, Math.min(1.0f, Math.max(curr, this.diveProgress)));
                this.ship.getMutableStats().getHullDamageTakenMult().modifyMult(id, 0.0f);
                if (this.diveProgress >= 1.0f) {
                    if (this.diveFader.isIdle()) {
                        Global.getSoundPlayer().playSound("phase_anchor_vanish", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                    }
                    this.diveFader.fadeOut();
                    this.diveFader.advance(amount);
                    float b = this.diveFader.getBrightness();
                    this.ship.setExtraAlphaMult2(b);
                    float r = this.ship.getCollisionRadius() * 5.0f;
                    this.ship.setJitter(this, c, b, 20, r * (1.0f - b));
                    if (this.diveFader.isFadedOut()) {
                        this.ship.getLocation().set(0.0f, -1000000.0f);
                    }
                }
            }
            boolean phased = this.ship.isPhased();
            if (this.ship.getPhaseCloak() != null && this.ship.getPhaseCloak().isChargedown()) {
                phased = false;
            }
            MutableShipStatsAPI stats = this.ship.getMutableStats();
            if (phased) {
                stats.getFluxDissipation().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getBallisticRoFMult().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getEnergyRoFMult().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getMissileRoFMult().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getBallisticAmmoRegenMult().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getEnergyAmmoRegenMult().modifyMult(id, PHASE_DISSIPATION_MULT);
                stats.getMissileAmmoRegenMult().modifyMult(id, PHASE_DISSIPATION_MULT);
            } else {
                stats.getFluxDissipation().unmodifyMult(id);
                stats.getBallisticRoFMult().unmodifyMult(id);
                stats.getEnergyRoFMult().unmodifyMult(id);
                stats.getMissileRoFMult().unmodifyMult(id);
                stats.getBallisticAmmoRegenMult().unmodifyMult(id);
                stats.getEnergyAmmoRegenMult().unmodifyMult(id);
                stats.getMissileAmmoRegenMult().unmodifyMult(id);
            }
        }
    }
}

