/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.HullModFleetEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class PhaseField
extends BaseHullMod
implements HullModFleetEffect {
    public static float MIN_CR = 0.1f;
    public static String MOD_KEY = "core_PhaseField";
    public static float PROFILE_MULT = 0.5f;
    public static float MIN_FIELD_MULT = 0.25f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getSensorProfile().modifyMult(id, PROFILE_MULT);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - PROFILE_MULT) * 100.0f) + "%";
        }
        return null;
    }

    public void advanceInCampaign(CampaignFleetAPI fleet) {
        String key = "$updatedPhaseFieldModifier";
        if (fleet.isPlayerFleet() && fleet.getMemoryWithoutUpdate() != null && !fleet.getMemoryWithoutUpdate().getBoolean(key) && fleet.getMemoryWithoutUpdate().getBoolean("$justToggledTransponder")) {
            this.onFleetSync(fleet);
            fleet.getMemoryWithoutUpdate().set(key, true, 0.1f);
        }
    }

    public boolean withAdvanceInCampaign() {
        return true;
    }

    public boolean withOnFleetSync() {
        return true;
    }

    public void onFleetSync(CampaignFleetAPI fleet) {
        float mult = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, 0.0f, 0.0f)[0];
        if (fleet.isTransponderOn()) {
            mult = 1.0f;
        }
        if (mult <= 0.0f) {
            fleet.getDetectedRangeMod().unmodifyMult(MOD_KEY);
        } else {
            fleet.getDetectedRangeMod().modifyMult(MOD_KEY, mult, "Phase ships in fleet");
        }
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        int numProfileShips = Global.getSettings().getInt("maxSensorShips");
        tooltip.addPara("In addition, the fleet's detected-at range is reduced by a multiplier based on the total sensor profile of the %s highest-profile ships in the fleet, and the total sensor strength of the %s phase ships with the highest sensor strength values. This effect only applies when the fleet's transponder is turned off.", opad, h, "" + numProfileShips, "" + numProfileShips);
        tooltip.addPara("Fleetwide sensor strength increases - such as from High Resolution Sensors - do not factor into this calculation.", opad);
        if (isForModSpec || ship == null) {
            return;
        }
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float[] data = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, 0.0f, 0.0f);
        float[] dataWithOneMore = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, null, ship.getMutableStats().getSensorProfile().getModifiedValue(), ship.getMutableStats().getSensorStrength().getModifiedValue());
        float[] dataWithOneLess = PhaseField.getPhaseFieldMultBaseProfileAndTotal(fleet, ship.getFleetMemberId(), 0.0f, 0.0f);
        float mult = data[0];
        float profile = data[1];
        float sensors = data[2];
        tooltip.addPara("The sensor profile of the %s top ships in your fleet is %s. The sensor strength of the top %s phase ships is %s.", opad, h, "" + numProfileShips, "" + Math.round(profile), "" + numProfileShips, "" + Math.round(sensors));
        tooltip.addPara("The detected-at range multiplier for your fleet is %s. The fleet's transponder must be off for the multiplier to be applied.", opad, h, "\u00d7" + Misc.getRoundedValueFloat(mult), "transponder must be off");
        float cr = ship.getCurrentCR();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getId().equals(ship.getFleetMemberId())) continue;
            cr = member.getRepairTracker().getCR();
        }
        if (cr < MIN_CR) {
            LabelAPI label = tooltip.addPara("This ship's combat readiness is below %s and the phase field's fleetwide effect can not be utilized. Bringing this ship into readiness would improve the multiplier to %s.", opad, h, Math.round(MIN_CR * 100.0f) + "%", "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
            label.setHighlightColors(bad, h);
            label.setHighlight(Math.round(MIN_CR * 100.0f) + "%", "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
        } else {
            tooltip.addPara("Removing this ship would change the multiplier to %s. Adding another ship with the same sensor strength would improve it to %s.", opad, h, "\u00d7" + Misc.getRoundedValueFloat(dataWithOneLess[0]), "\u00d7" + Misc.getRoundedValueFloat(dataWithOneMore[0]));
        }
    }

    public static float[] getPhaseFieldMultBaseProfileAndTotal(CampaignFleetAPI fleet, String skipId, float addProfile, float addSensor) {
        float totalPhaseSensors;
        float total;
        int numProfileShips;
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        ArrayList<FleetMemberAPI> phase = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.getId().equals(skipId)) continue;
            members.add(member);
            if (member.isMothballed() || member.getRepairTracker().getCR() < MIN_CR || !member.getVariant().hasHullMod("phasefield")) continue;
            phase.add(member);
        }
        float[] profiles = new float[members.size()];
        profiles = addProfile <= 0.0f ? new float[members.size()] : new float[members.size() + 1];
        float[] phaseSensors = addSensor <= 0.0f ? new float[phase.size()] : new float[phase.size() + 1];
        int i = 0;
        for (FleetMemberAPI member : members) {
            profiles[i] = member.getStats().getSensorProfile().getModifiedValue();
            ++i;
        }
        if (addProfile > 0.0f) {
            profiles[i] = addProfile;
        }
        i = 0;
        for (FleetMemberAPI member : phase) {
            phaseSensors[i] = member.getStats().getSensorStrength().getModifiedValue();
            ++i;
        }
        if (addSensor > 0.0f) {
            phaseSensors[i] = addSensor;
        }
        int numPhaseShips = numProfileShips = Global.getSettings().getInt("maxSensorShips");
        float totalProfile = PhaseField.getTopKValuesSum(profiles, numProfileShips);
        float mult = totalProfile / (total = Math.max(totalProfile + (totalPhaseSensors = PhaseField.getTopKValuesSum(phaseSensors, numPhaseShips)), 1.0f));
        if (mult < MIN_FIELD_MULT) {
            mult = MIN_FIELD_MULT;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        return new float[]{mult, totalProfile, totalPhaseSensors};
    }

    public static float getTopKValuesSum(float[] arr, int k) {
        k = Math.min(k, arr.length);
        float kVal = Misc.findKth(arr, arr.length - k);
        float total = 0.0f;
        int found = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] > kVal) {
                ++found;
                total += arr[i];
            }
            ++i;
        }
        if (k > found) {
            total += (float)(k - found) * kVal;
        }
        return total;
    }
}

