/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class RecoveryShuttles
extends BaseHullMod {
    public static float CREW_LOSS_MULT = 0.25f;
    public static float SMOD_CREW_LOSS_MULT = 0.05f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        float mult = CREW_LOSS_MULT;
        if (sMod) {
            mult = SMOD_CREW_LOSS_MULT;
        }
        stats.getDynamic().getStat("fighter_crew_loss_mult").modifyMult(id, mult);
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - SMOD_CREW_LOSS_MULT) * 100.0f) + "%";
        }
        return null;
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)((1.0f - CREW_LOSS_MULT) * 100.0f) + "%";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("automated")) {
            return false;
        }
        int bays = (int)ship.getMutableStats().getNumFighterBays().getModifiedValue();
        return ship != null && bays > 0;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getVariant().hasHullMod("automated")) {
            return "Can not be installed on automated ships";
        }
        return "Ship does not have fighter bays";
    }
}

