/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class SharedFluxSink
extends BaseHullMod {
    public static float FLUX_FRACTION = 0.5f;
    public static float HARD_FLUX_FRACTION = 0.2f;
    public static String SINK_DATA_KEY = "core_sink_data_key";

    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        String key = String.valueOf(SINK_DATA_KEY) + "_" + ship.getId();
        FluxSinkData data = (FluxSinkData)engine.getCustomData().get(key);
        if (data == null) {
            data = new FluxSinkData();
            engine.getCustomData().put(key, data);
            for (ShipAPI module : ship.getChildModulesCopy()) {
                if (module.getStationSlot() == null || !module.isAlive() || !Misc.isActiveModule(module)) continue;
                float d = module.getMutableStats().getFluxDissipation().getModifiedValue();
                data.dissipation.put(module, Float.valueOf(d *= FLUX_FRACTION));
            }
        }
        ArrayList<ShipAPI> losses = new ArrayList<ShipAPI>(data.dissipation.keySet());
        ArrayList<ShipAPI> remaining = new ArrayList<ShipAPI>();
        float totalLiveDissipation = 0.0f;
        for (ShipAPI module : ship.getChildModulesCopy()) {
            if (module.getStationSlot() == null || !module.isAlive() || !Misc.isActiveModule(module)) continue;
            losses.remove(module);
            remaining.add(module);
            if (!data.dissipation.containsKey(module)) continue;
            totalLiveDissipation += data.dissipation.get(module).floatValue();
        }
        float extraDissipation = 0.0f;
        for (ShipAPI lost : losses) {
            if (!data.dissipation.containsKey(lost)) continue;
            extraDissipation += data.dissipation.get(lost).floatValue();
        }
        for (ShipAPI module : remaining) {
            if (!data.dissipation.containsKey(module)) continue;
            float currBonus = 0.0f;
            if (totalLiveDissipation > 0.0f) {
                currBonus = data.dissipation.get(module).floatValue() / totalLiveDissipation * extraDissipation;
            }
            module.getMutableStats().getFluxDissipation().modifyFlat("shared_flux_sink", currBonus);
            float hardFluxFraction = 0.0f;
            float totalDissipation = module.getMutableStats().getFluxDissipation().getModifiedValue();
            if (totalDissipation > 0.0f) {
                hardFluxFraction = currBonus / totalDissipation * HARD_FLUX_FRACTION;
            }
            module.getMutableStats().getHardFluxDissipationFraction().modifyFlat("shared_flux_sink", hardFluxFraction);
        }
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return Math.round(FLUX_FRACTION * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round(HARD_FLUX_FRACTION * 100.0f) + "%";
        }
        return null;
    }

    public static class FluxSinkData {
        Map<ShipAPI, Float> dissipation = new LinkedHashMap<ShipAPI, Float>();
    }
}

