/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class AutoReducingValue {
    private float elapsed = 0.0f;
    private int value = 0;
    private float elapsedPerPoint;
    private final ValueChangedListener listener;

    public AutoReducingValue(int value, float elapsedPerPoint, ValueChangedListener listener) {
        this.value = value;
        this.elapsedPerPoint = elapsedPerPoint;
        this.listener = listener;
    }

    public void advance(float amount) {
        this.elapsed += amount;
        if (this.elapsed >= this.elapsedPerPoint) {
            this.elapsed -= this.elapsedPerPoint;
            int prev = this.value--;
            if (this.value < 0) {
                this.value = 0;
            }
            if (prev != this.value && this.listener != null) {
                this.listener.valueChanged(prev, this.value, this);
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int prev = value;
        this.value = value;
        if (prev != value && this.listener != null) {
            this.listener.valueChanged(prev, value, this);
        }
    }

    public void increaseValue(int amt) {
        int prev = this.value;
        this.value += amt;
        if (this.value < 0) {
            this.value = 0;
        }
        if (prev != this.value && this.listener != null) {
            this.listener.valueChanged(prev, this.value, this);
        }
    }

    public void reduceValue(int amt) {
        int prev = this.value;
        this.value -= amt;
        if (this.value < 0) {
            this.value = 0;
        }
        if (prev != this.value && this.listener != null) {
            this.listener.valueChanged(prev, this.value, this);
        }
    }

    public static interface ValueChangedListener {
        public void valueChanged(int var1, int var2, AutoReducingValue var3);
    }
}

