/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class FaderUtil {
    private float currBrightness;
    private float durationIn;
    private float durationOut;
    private State state;
    private boolean bounceDown = false;
    private boolean bounceUp = false;

    public FaderUtil(float currBrightness, float duration) {
        this.currBrightness = currBrightness;
        this.durationIn = duration;
        this.durationOut = duration;
        this.state = State.IDLE;
    }

    public FaderUtil(float currBrightness, float durationIn, float durationOut) {
        this.currBrightness = currBrightness;
        this.durationIn = durationIn;
        this.durationOut = durationOut;
        this.state = State.IDLE;
    }

    public FaderUtil(float currBrightness, float durationIn, float durationOut, boolean bounceUp, boolean bounceDown) {
        this(currBrightness, durationIn, durationOut);
        this.setBounce(bounceUp, bounceDown);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setBounceDown(boolean bounceDown) {
        this.bounceDown = bounceDown;
    }

    public void setBounceUp(boolean bounceUp) {
        this.bounceUp = bounceUp;
    }

    public void setBounce(boolean up, boolean down) {
        this.bounceUp = up;
        this.bounceDown = down;
    }

    public void forceIn() {
        this.currBrightness = 1.0f;
        this.state = this.bounceDown ? State.OUT : State.IDLE;
    }

    public void forceOut() {
        this.currBrightness = 0.0f;
        this.state = this.bounceUp ? State.IN : State.IDLE;
    }

    public void fadeIn() {
        if (this.durationIn <= 0.0f) {
            this.forceIn();
        } else {
            this.state = State.IN;
        }
    }

    public void fadeOut() {
        if (this.durationOut <= 0.0f) {
            this.forceOut();
        } else {
            this.state = State.OUT;
        }
    }

    public boolean isFadedOut() {
        return this.getBrightness() == 0.0f && (this.isIdle() || this.isFadingOut());
    }

    public boolean isFadedIn() {
        return this.getBrightness() == 1.0f && this.isIdle();
    }

    public boolean isFadingOut() {
        return this.state == State.OUT;
    }

    public boolean isFadingIn() {
        return this.state == State.IN;
    }

    public boolean isIdle() {
        return this.state == State.IDLE;
    }

    public void advance(float amount) {
        if (this.state == State.IDLE) {
            return;
        }
        if (this.state == State.IN) {
            if (this.currBrightness == 1.0f) {
                this.state = this.bounceDown ? State.OUT : State.IDLE;
                return;
            }
            float delta = amount / this.durationIn;
            this.currBrightness += delta;
            if (this.currBrightness > 1.0f) {
                this.currBrightness = 1.0f;
            }
        } else if (this.state == State.OUT) {
            if (this.currBrightness == 0.0f) {
                this.state = this.bounceUp ? State.IN : State.IDLE;
                return;
            }
            float delta = amount / this.durationOut;
            this.currBrightness -= delta;
            if (this.currBrightness < 0.0f) {
                this.currBrightness = 0.0f;
            }
        }
    }

    public void setDurationIn(float durationIn) {
        this.durationIn = durationIn;
    }

    public void setDurationOut(float durationOut) {
        this.durationOut = durationOut;
    }

    public FaderUtil setDuration(float in, float out) {
        this.durationIn = in;
        this.durationOut = out;
        return this;
    }

    public float getBrightness() {
        return this.currBrightness;
    }

    public float getDurationIn() {
        return this.durationIn;
    }

    public float getDurationOut() {
        return this.durationOut;
    }

    public void setBrightness(float brightness) {
        this.currBrightness = brightness;
    }

    public String toString() {
        return String.format("%s, curr: %f, in: %f, out: %f, up: %b, down: %b", this.state.name(), Float.valueOf(this.currBrightness), Float.valueOf(this.durationIn), Float.valueOf(this.durationOut), this.bounceUp, this.bounceDown);
    }

    public boolean isBounceDown() {
        return this.bounceDown;
    }

    public boolean isBounceUp() {
        return this.bounceUp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IN,
        OUT,
        IDLE;

    }
}

