/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.RenderingAffectedByAbyssalDepth;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.util.vector.Vector2f;

public class NascentGravityWell
extends BaseCampaignEntity
implements DoNotObfuscate,
NascentGravityWellAPI,
RenderingAffectedByAbyssalDepth {
    private transient Sprite sprite;
    private transient float elapsed;
    private Color colorOverride = null;
    private float radius;
    private SectorEntityToken target;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.ASTEROIDS);

    public NascentGravityWell(SectorEntityToken sectorEntityToken, float f2) {
        super(null);
        this.radius = f2;
        this.target = sectorEntityToken;
        this.elapsed = (float)Math.random() * 500.0f;
        this.addTag("non_clickable");
        this.readResolve();
    }

    public SectorEntityToken getTarget() {
        return this.target;
    }

    public Color getColorOverride() {
        return this.colorOverride;
    }

    public void setColorOverride(Color color) {
        this.colorOverride = color;
    }

    @Override
    protected Object writeReplace() {
        super.writeReplace();
        return this;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(CampaignEngineLayers.ASTEROIDS);
        this.sprite = new Sprite("graphics/fx/particlealpha32sq.png");
        this.elapsed = (float)Math.random() * 500.0f;
        return this;
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        this.elapsed += f2;
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), this.radius + 100.0f)) {
            return;
        }
        if (campaignEngineLayers == CampaignEngineLayers.ASTEROIDS) {
            float f2 = combatViewport.getAlphaMult();
            if ((f2 *= this.getAlphaMultFromAbyssalDepth()) <= 0.0f) {
                return;
            }
            if (this.hasSensorProfile()) {
                f2 *= this.getSensorFaderBrightness();
            }
            Color color = new Color(175, 50, 255);
            if (this.colorOverride != null) {
                color = this.colorOverride;
            }
            this.sprite.setColor(color);
            Vector2f vector2f = this.getLocation();
            float f3 = 0.25f;
            float f4 = 0.0f;
            while (f4 < 360.0f) {
                float f5 = ((float)Math.toRadians((double)f4 * Math.PI * (double)2.3f) + this.elapsed * f3) % ((float)Math.PI * 2);
                float f6 = (float)Math.sin(f5);
                float f7 = (float)Math.cos(f5);
                this.sprite.setAngle(f4);
                this.sprite.setAdditiveBlend();
                this.sprite.setAlphaMult(f2 * 0.25f);
                float f8 = this.radius * 4.0f;
                float f9 = this.radius * 4.0f;
                float f10 = this.radius * 0.95f;
                this.sprite.setSize(f8 * (Math.abs(f7 * 0.75f) + 0.35f), f9 * (Math.abs(f6 * 0.75f) + 0.35f));
                this.sprite.renderAtCenter(vector2f.x + (float)Math.cos(Math.toRadians(f4)) * f10, vector2f.y + (float)Math.sin(Math.toRadians(f4)) * f10);
                f4 += 60.0f;
            }
        }
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public boolean isRenderCircleIndicator() {
        return false;
    }

    public boolean isStar() {
        return false;
    }

    public float getAlphaMultFromAbyssalDepth() {
        float f2 = Misc.getAbyssalDepthOfPlayer();
        float f3 = Misc.getAbyssalDepth((SectorEntityToken)this);
        if (f2 <= 0.0f && f3 <= 0.0f) {
            return 1.0f;
        }
        if (f2 > 0.0f && f3 <= 0.0f) {
            return 1.0f - f2;
        }
        if (!StarfarerSettings.\u00f4o0000()) {
            return 1.0f;
        }
        CampaignFleetAPI campaignFleetAPI = Global.getSector().getPlayerFleet();
        if (campaignFleetAPI == null) {
            return 1.0f;
        }
        float f4 = this.getSensorContactFaderBrightness();
        return f4;
    }
}

