/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.CommodityIconCounts;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.PriceCalculator;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.reach.CommodityMarketData;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask;
import com.fs.starfarer.campaign.econ.reach.ReachEconomy;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;

public class MainWorkTask2
extends MultiFrameTask
implements DoNotObfuscate {
    private ReachEconomy economy;
    private List<MarketAPI> markets = null;
    private List<String> commodities;
    private int index = 0;
    private boolean started = false;
    private int marketIndex = 0;
    private MainWorkTask.EconWorkParams params;

    public MainWorkTask2(List<MarketAPI> list, ReachEconomy reachEconomy, MainWorkTask.EconWorkParams econWorkParams) {
        this.economy = reachEconomy;
        this.params = econWorkParams;
        this.markets = new ArrayList<MarketAPI>(list);
    }

    public void initCommodityList() {
        this.commodities = new ArrayList<String>();
        for (CommoditySpecAPI commoditySpecAPI : Global.getSettings().getAllCommoditySpecs()) {
            if (commoditySpecAPI.hasTag("nonecon")) continue;
            this.commodities.add(commoditySpecAPI.getId());
        }
        Profiler.\u00d200000((String)"Sorting commodities");
        Collections.sort(this.commodities, new Comparator<String>(){

            public int o00000(String string, String string2) {
                F f2 = SpecStore.super(F.class, string);
                F f3 = SpecStore.super(F.class, string2);
                return (int)Math.signum(f2.getEconomyTier() - f3.getEconomyTier());
            }
        });
        Profiler.o00000();
    }

    @Override
    public void doNextBatch() {
        if (!this.started) {
            this.initCommodityList();
            this.index = 0;
            this.started = true;
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (this.marketIndex < this.markets.size()) {
            Profiler.\u00d200000((String)"Reapplying conditions and industries");
            MarketAPI marketAPI = this.markets.get(this.marketIndex);
            marketAPI.reapplyConditions();
            marketAPI.reapplyIndustries();
            ++this.marketIndex;
            Profiler.o00000();
        } else {
            String string = this.commodities.get(this.index);
            F f2 = SpecStore.super(F.class, string);
            ++this.index;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (MarketAPI object2 : this.markets) {
                String string2 = object2.getEconGroup();
                if (string2 == null) continue;
                linkedHashSet.add(string2);
            }
            Profiler.\u00d200000((String)"Computing commodity data");
            new CommodityMarketData(string, null);
            for (String string3 : linkedHashSet) {
                new CommodityMarketData(string, string3);
            }
            Profiler.o00000();
            if (this.params.withStockpileUpdate) {
                Profiler.\u00d200000((String)"Updating stockpiles and prices");
                for (MarketAPI marketAPI : this.markets) {
                    MainWorkTask2.updateStockpileAndPrice((Market)marketAPI, f2);
                }
            }
            Profiler.o00000();
            List list = Global.getSector().getEconomy().getUpdateListeners();
            for (Iterator<Object> iterator : new ArrayList(list)) {
                if (iterator.isEconomyListenerExpired()) {
                    Global.getSector().getEconomy().removeUpdateListener(iterator);
                    continue;
                }
                iterator.commodityUpdated(string);
            }
        }
    }

    public static void updateStockpileAndPrice(Market market, F f2) {
        MainWorkTask2.updateStockpileAndPriceV2(market, f2);
    }

    public static void updateStockpileAndPriceV2(Market market, F f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        CommodityIconCounts commodityIconCounts;
        float f11 = 0.0f;
        float f12 = 1.0f;
        Random random = new Random(market.getId().hashCode() + f2.getId().hashCode() + Global.getSector().getClock().getMonth() * 170000);
        List<CommodityOnMarket> list = market.getCommoditiesWithClass(f2.getDemandClass());
        float f13 = 0.0f;
        float f14 = Economy.ECONOMY_GREED_FRACTION;
        boolean bl = false;
        String string = "core";
        for (CommodityOnMarket commodityOnMarket : list) {
            if (!commodityOnMarket.getCommodity().isPrimary()) continue;
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            f10 = commodityIconCounts.production - commodityIconCounts.inFactionOnlyExport - commodityIconCounts.canNotExport;
            f9 = Math.max(f10, (float)commodityOnMarket.getMaxDemand()) + f11;
            if (f9 < 1.0f) {
                f9 = 1.0f;
            }
            bl = commodityOnMarket.getMaxDemand() <= 0 && commodityOnMarket.getMaxSupply() <= 0;
            f13 = MainWorkTask2.getStockpileQuantity(commodityOnMarket, f9) * f12 + (float)Economy.MIN_STOCKPILE_FOR_PRICING * 2.0f;
            f13 *= 0.95f + 0.1f * random.nextFloat();
            if (bl) {
                commodityOnMarket.getPlayerDemandPriceMod().modifyMult(string, Economy.ECONOMY_NO_DEMAND_PRICE_MULT);
            } else {
                commodityOnMarket.getPlayerDemandPriceMod().unmodifyMult(string);
            }
            commodityOnMarket.getDemand().getDemand().modifyFlat(string, f13 * (1.0f - f14));
            commodityOnMarket.getGreed().modifyFlat(string, f13 * f14);
            break;
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            if (commodityOnMarket.getCommodity().isPrimary()) continue;
            if (bl) {
                commodityOnMarket.getPlayerDemandPriceMod().modifyMult(string, Economy.ECONOMY_NO_DEMAND_PRICE_MULT);
            } else {
                commodityOnMarket.getPlayerDemandPriceMod().unmodifyMult(string);
            }
            commodityOnMarket.getGreed().modifyFlat(string, f13 * f14);
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            if (!commodityOnMarket.getCommodity().isPrimary()) continue;
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            f10 = commodityIconCounts.deficit;
            f9 = commodityIconCounts.inFactionOnlyExport + commodityIconCounts.canNotExport;
            f10 *= 1.0f;
            f9 *= 1.0f;
            int n2 = Math.min(commodityOnMarket.getAvailable(), commodityOnMarket.getMaxSupply());
            int n3 = 0;
            if (bl) {
                n3 = 1;
            }
            f8 = MainWorkTask2.getStockpileQuantity(commodityOnMarket, commodityOnMarket.getAvailable() + n3) * f12;
            f7 = 0.5f;
            f6 = (float)n2 * 0.025f;
            f5 = 10.0f;
            f4 = Math.max(3.0f, (float)commodityOnMarket.getCommodityMarketData().getMaxExportGlobal());
            f3 = 0.5f * f5 / f4;
            f6 = (float)n2 * f3;
            if (f6 > (f7 = f3 * f5)) {
                f6 = f7;
            }
            f8 += commodityOnMarket.getCommodity().getEconUnit() * f6;
            commodityOnMarket.setStockpile(f8 *= 0.95f + 0.1f * random.nextFloat());
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            float f15;
            float f16;
            float f17;
            float f18;
            commodityOnMarket.updateCalc();
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            PriceCalculator priceCalculator = commodityOnMarket.getDemandPrice();
            PriceCalculator priceCalculator2 = commodityOnMarket.getSupplyPrice();
            float f19 = commodityIconCounts.deficit;
            float f20 = commodityIconCounts.extra;
            f8 = commodityOnMarket.getStockpile();
            f7 = commodityOnMarket.getCommodity().getEconUnit();
            f6 = Economy.DEFICIT_PRICE_INCR_PER_UNIT;
            f4 = Economy.EXCESS_PRICE_DECR_PER_UNIT;
            f5 = Economy.DEFICIT_PRICE_MULT_MAX;
            f3 = Economy.EXCESS_PRICE_MULT_MIN;
            if (f19 > 0.0f) {
                f18 = f8 + f19 * f7;
                f17 = 1.0f + Math.max(1.0f, f19) * f6;
                if (f17 > f5) {
                    f17 = f5;
                }
                priceCalculator.setHighPriceThreshold(f18);
                priceCalculator.setHighPriceMult(f17);
                priceCalculator2.setHighPriceThreshold(f18);
                priceCalculator2.setHighPriceMult(f17);
            } else {
                priceCalculator.setHighPriceThreshold(-1.0f);
                priceCalculator.setHighPriceMult(1.0f);
                priceCalculator2.setHighPriceThreshold(-1.0f);
                priceCalculator2.setHighPriceMult(1.0f);
            }
            f18 = commodityOnMarket.getCombinedTradeModQuantity();
            f17 = commodityOnMarket.getModValueForQuantity(f18);
            if (f19 <= 0.0f && f17 > 0.0f && (f16 = commodityOnMarket.getTradeMod().getModifiedValue() + commodityOnMarket.getTradeModPlus().getModifiedValue()) > 0.0f) {
                f15 = Math.max(0.0f, f8 - f20 * f7);
                float f21 = 1.0f + Math.max(1.0f, 1.0f) * f6;
                if (f21 > f5) {
                    f21 = f5;
                }
                priceCalculator2.setHighPriceThreshold(f15);
                priceCalculator2.setHighPriceMult(f21);
            }
            if (f20 > 0.0f) {
                f16 = f8 - f20 * f7;
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if ((f15 = 1.0f - Math.max(1.0f, f20) * f4) < f3) {
                    f15 = f3;
                }
                priceCalculator.setLowPriceThreshold(f16);
                priceCalculator.setLowPriceMult(f15);
                priceCalculator2.setLowPriceThreshold(f16);
                priceCalculator2.setLowPriceMult(f15);
                continue;
            }
            priceCalculator.setLowPriceThreshold(-1.0f);
            priceCalculator.setLowPriceMult(1.0f);
            priceCalculator2.setLowPriceThreshold(-1.0f);
            priceCalculator2.setLowPriceMult(1.0f);
        }
    }

    public static float getStockpileQuantity(CommodityOnMarketAPI commodityOnMarketAPI, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        float f3 = BaseIndustry.getSizeMult((float)f2);
        return commodityOnMarketAPI.getCommodity().getEconUnit() * f3;
    }

    @Override
    public boolean isDone() {
        return this.commodities != null && this.index >= this.commodities.size();
    }

    @Override
    public String getLoggingIdentifier() {
        return "MainWorkTask";
    }
}

