/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.particle.BaseParticleEmitter;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.class.new;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.EmitterFactory;
import com.fs.starfarer.combat.entities.F;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.void;
import com.fs.starfarer.prototype.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class DamagingExplosion
extends BaseEntity
implements F,
DamagingProjectileAPI {
    private float duration;
    private float elapsed;
    private com.fs.starfarer.combat.class.F damage;
    private Ship source;
    private List<new> damagedAlready = new ArrayList<new>();
    private DamagingExplosionSpec spec;
    private Vector2f spawnLocation = new Vector2f();
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private new lastTarget = null;
    private float[] extraDamageComponents;

    public DamagingExplosion(DamagingExplosionSpec damagingExplosionSpec, Ship ship) {
        this.spec = damagingExplosionSpec;
        this.source = ship;
        this.duration = damagingExplosionSpec.getDuration();
        this.damage = new com.fs.starfarer.combat.class.F(damagingExplosionSpec.getMaxDamage(), false, damagingExplosionSpec.getDamageType(), ship.getStats());
        this.setCollisionRadius(damagingExplosionSpec.getRadius());
        this.setCollisionClass(damagingExplosionSpec.getCollisionClass());
        if (ship != null && ship.getCollisionClass() == CollisionClass.FIGHTER) {
            this.setCollisionClass(damagingExplosionSpec.getCollisionClassIfByFighter());
        }
        this.setOwner(ship.getOwner());
    }

    public DamagingExplosionSpec getExplosionSpecIfExplosion() {
        return this.spec;
    }

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    public com.fs.starfarer.combat.class.F getDamage() {
        return this.damage;
    }

    @Override
    public void advance(float f2) {
        this.elapsed += f2;
    }

    @Override
    public void applyDamage(Vector2f vector2f, com.fs.starfarer.combat.class.F f2, boolean bl, float f3, Object object) {
        return new void();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init() {
        boolean bl;
        boolean bl2 = bl = this.spec.isShowGraphic() && CombatEngine.getInstance().getViewport().isNearViewport(this.getLocation(), this.getCollisionRadius() * 1.5f);
        if (bl) {
            float f2 = this.spec.getParticleSpawnRadius();
            if (f2 < 0.0f) {
                f2 = this.spec.getRadius() * 0.75f;
            }
            BaseParticleEmitter baseParticleEmitter = EmitterFactory.super(this.getLocation(), CombatEngine.getInstance().getSmoothParticles(), this.spec.getParticleCount(), f2, this.spec.getParticleColor(), this.spec.getParticleDuration(), this.spec.getParticleSizeMin(), this.spec.getParticleSizeRange());
            CombatEngine combatEngine = CombatEngine.getInstance();
            combatEngine.addAnimation((Animation)baseParticleEmitter);
            if (this.spec.isUseDetailedExplosion()) {
                float f3 = this.spec.getRadius() * 1.25f;
                if (this.spec.getDetailedExplosionRadius() >= 0.0f) {
                    f3 = this.spec.getDetailedExplosionRadius();
                }
                CombatEngine.getInstance().getExplosionSystem().spawnExplosion(this.getLocation(), new Vector2f(), this.spec.getExplosionColor(), f3, this.spec.getParticleDuration());
                float f4 = (float)Math.sqrt(this.getCollisionRadius()) * 15.0f * 4.0f * 1.25f;
                Color color = this.spec.getExplosionColor();
                if (this.spec.getDetailedExplosionFlashRadius() >= 0.0f) {
                    f4 = this.spec.getDetailedExplosionFlashRadius();
                }
                float f5 = 1.5f;
                if (this.spec.getDetailedExplosionFlashDuration() >= 0.0f) {
                    f5 = this.spec.getDetailedExplosionFlashDuration();
                }
                if (this.spec.getDetailedExplosionFlashColorFringe() != null) {
                    color = this.spec.getDetailedExplosionFlashColorFringe();
                }
                Color color2 = Color.white;
                if (this.spec.getDetailedExplosionFlashColorCore() != null) {
                    color2 = this.spec.getDetailedExplosionFlashColorCore();
                }
                combatEngine.addHitParticle(this.getLocation(), new Vector2f(), f4 * 1.0f, 1.0f, f5, color);
                combatEngine.addHitParticle(this.getLocation(), new Vector2f(), f4 * 0.25f, 1.0f, f5, color2);
            } else {
                float f6 = (float)this.spec.getExplosionColor().getAlpha() / 255.0f;
                combatEngine.addHitParticle(this.getLocation(), new Vector2f(), this.spec.getRadius() * 3.0f, f6, this.spec.getExplosionColor());
                combatEngine.addHitParticle(this.getLocation(), new Vector2f(), this.spec.getRadius() * 0.75f, f6, Color.white);
            }
        }
    }

    @Override
    public boolean isExpired() {
        return this.elapsed > this.duration;
    }

    @Override
    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
    }

    public float getBrightness() {
        return 1.0f;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
        if (combatEntityAPI instanceof new) {
            this.damagedAlready.add((new)combatEntityAPI);
        }
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
        this.damagedAlready.remove(combatEntityAPI);
    }

    public float[] getExtraDamageComponents() {
        return this.extraDamageComponents;
    }

    public void setExtraDamageComponents(float[] fArray) {
        this.extraDamageComponents = fArray;
    }

    @Override
    public com.fs.starfarer.combat.class.F getDamage(Vector2f vector2f, new new_) {
        if (this.damagedAlready.contains(new_)) {
            return new com.fs.starfarer.combat.class.F(0.0f, false, this.spec.getDamageType(), this.source.getStats());
        }
        float f2 = Utils.\u00d800000(this.getLocation(), vector2f);
        if (f2 > this.spec.getRadius()) {
            return new com.fs.starfarer.combat.class.F(0.0f, false, this.spec.getDamageType(), this.source.getStats());
        }
        float f3 = 1.0f;
        if (f2 > this.spec.getCoreRadius()) {
            f3 = 1.0f - (f2 - this.spec.getCoreRadius()) / (this.spec.getRadius() - this.spec.getCoreRadius());
        }
        float f4 = this.spec.getMinDamage() + (this.spec.getMaxDamage() - this.spec.getMinDamage()) * f3;
        this.damage = new com.fs.starfarer.combat.class.F(f4, false, this.spec.getDamageType(), this.source.getStats());
        float f5 = this.spec.getMinEMPDamage() + (this.spec.getMaxEMPDamage() - this.spec.getMinEMPDamage()) * f3;
        this.damage.setFluxComponent(f5);
        if (this.extraDamageComponents != null) {
            this.damage.getModifier().modifyPercent("core_de_edc_0", this.extraDamageComponents[0]);
            this.damage.getModifier().modifyFlat("core_de_edc_1", this.extraDamageComponents[1]);
            this.damage.getModifier().modifyMult("core_de_edc_2", this.extraDamageComponents[2]);
        }
        return this.damage;
    }

    @Override
    public Ship getSource() {
        return this.source;
    }

    @Override
    public boolean isDestroyedByCollision(new new_) {
        return false;
    }

    @Override
    public F.o notifyDealtDamage(Vector2f vector2f, void void_, new new_) {
        this.damagedAlready.add(new_);
        this.lastTarget = new_;
        if (void_ != null && void_.getDamageToShields() > 0.0f && new_ instanceof Ship) {
            Ship ship = (Ship)new_;
            for (Ship ship2 : ship.getChildModules()) {
                this.damagedAlready.add(ship2);
            }
            if (ship.getParentStation() != null) {
                for (Ship ship2 : ship.getParentStation().getChildModules()) {
                    this.damagedAlready.add(ship2);
                }
            }
        }
        if (this.spec.getEffect() != null) {
            this.spec.getEffect().onHit((DamagingProjectileAPI)this, (CombatEntityAPI)new_, vector2f, void_.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)void_, (CombatEngineAPI)CombatEngine.getInstance());
        }
        return F.o.\u00d200000;
    }

    @Override
    public float getMass() {
        return 0.0f;
    }

    public boolean didDamage() {
        return false;
    }

    public void setDamageAmount(float f2) {
        this.damage.setDamage(f2);
    }

    public float getDamageAmount() {
        return this.damage.getDamage();
    }

    public float getBaseDamageAmount() {
        return this.damage.getBaseDamage();
    }

    public CombatEntityAPI getDamageTarget() {
        return this.lastTarget;
    }

    public DamageType getDamageType() {
        return this.damage.getType();
    }

    public float getEmpAmount() {
        return this.damage.getFluxComponent();
    }

    public String getProjectileSpecId() {
        return null;
    }

    @Override
    public WeaponAPI getWeapon() {
        return null;
    }

    public void setSource(ShipAPI shipAPI) {
        this.source = (Ship)shipAPI;
    }

    public boolean isFading() {
        return false;
    }

    public ProjectileSpawnType getSpawnType() {
        return ProjectileSpawnType.OTHER;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public boolean isFromMissile() {
        return false;
    }

    public void setFromMissile(boolean bl) {
    }

    public float getMoveSpeed() {
        return 0.0f;
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return null;
    }

    public Vector2f getTailEnd() {
        return null;
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return new ArrayList<CombatEntityAPI>(this.damagedAlready);
    }
}

