/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics;

import com.fs.graphics.LayeredRenderable;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class LayeredRenderer<T extends Enum<T>, V>
implements DoNotObfuscate {
    private Map<T, List<LayeredRenderable<T, V>>> layers = new HashMap<T, List<LayeredRenderable<T, V>>>();
    private Class<T> layerEnumClass;

    public LayeredRenderer(Class<T> clazz) {
        this.layerEnumClass = clazz;
    }

    public void render(V v) {
        EnumSet<Enum> enumSet = EnumSet.allOf(this.layerEnumClass);
        for (Enum enum_ : enumSet) {
            for (LayeredRenderable<Enum, V> layeredRenderable : this.getList(enum_)) {
                layeredRenderable.render(enum_, v);
            }
        }
    }

    public void renderExcluding(V v, T ... TArray) {
        EnumSet<Enum> enumSet = EnumSet.allOf(this.layerEnumClass);
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (TArray != null) {
            linkedHashSet.addAll(Arrays.asList(TArray));
        }
        for (Enum enum_ : enumSet) {
            if (linkedHashSet.contains(enum_)) continue;
            for (LayeredRenderable<Enum, V> layeredRenderable : this.getList(enum_)) {
                layeredRenderable.render(enum_, v);
            }
        }
    }

    public void renderOnly(V v, T t) {
        for (LayeredRenderable<T, V> layeredRenderable : this.getList(t)) {
            layeredRenderable.render(t, v);
        }
    }

    public void add(LayeredRenderable<T, V> layeredRenderable) {
        if (layeredRenderable.getActiveLayers() == null) {
            return;
        }
        for (Enum enum_ : layeredRenderable.getActiveLayers()) {
            List<LayeredRenderable<Enum, V>> list = this.getList(enum_);
            if (list.contains(layeredRenderable)) continue;
            list.add(layeredRenderable);
        }
    }

    public void remove(LayeredRenderable<T, V> layeredRenderable) {
        EnumSet<Enum> enumSet = EnumSet.allOf(this.layerEnumClass);
        for (Enum enum_ : enumSet) {
            this.getList(enum_).remove(layeredRenderable);
        }
    }

    public void recompile(LayeredRenderable<T, V> layeredRenderable) {
        this.remove(layeredRenderable);
        this.add(layeredRenderable);
    }

    public void clearLayer(T t) {
        this.getList(t).clear();
    }

    public void clearAll() {
        EnumSet<Enum> enumSet = EnumSet.allOf(this.layerEnumClass);
        for (Enum enum_ : enumSet) {
            this.clearLayer(enum_);
        }
    }

    private List<LayeredRenderable<T, V>> getList(T t) {
        List<LayeredRenderable<T, V>> list = this.layers.get(t);
        if (list == null) {
            list = new ArrayList<LayeredRenderable<T, V>>();
            this.layers.put(t, list);
        }
        return list;
    }

    private static void blagl() {
        LayeredRenderer<o, o> layeredRenderer = new LayeredRenderer<o, o>(o.class);
        LayeredRenderable<o, o> layeredRenderable = new LayeredRenderable<o, o>(){

            @Override
            public EnumSet<o> getActiveLayers() {
                return null;
            }

            @Override
            public void render(o o2, o o3) {
            }
        };
        layeredRenderer.add(layeredRenderable);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static enum o {
        o00000,
        \u00d400000,
        \u00d300000;

    }
}

