/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.comms.v2;

import com.fs.starfarer.D.M;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.comm.IntelManagerAPI;
import com.fs.starfarer.api.impl.campaign.intel.NewMessagesIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.comms.v2.super;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.newui.C;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.repo.ObjectRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class IntelManager
implements IntelManagerAPI,
DoNotObfuscate {
    public static final float MAX_RELAY_RANGE_IN_HYPER_IN_LY = StarfarerSettings.\u00f600000("maxRelayRangeInHyperspace");
    public static final float MAX_RANGE_AROUND_SYSTEM = StarfarerSettings.\u00f600000("commRelayRangeAroundSystem");
    public static final float ADD_INTERVAL_DAYS = 0.1f;
    private ObjectRepository commQueue = new ObjectRepository();
    private ObjectRepository intel = new ObjectRepository();
    private transient long addToTimestamp = 0L;

    protected Object readResolve() {
        if (this.intel == null) {
            this.intel = new ObjectRepository();
        }
        return this;
    }

    public void advance(float f2) {
        int n2;
        CampaignEngine campaignEngine = CampaignEngine.getInstance();
        if (campaignEngine.isPaused()) {
            return;
        }
        CampaignFleet campaignFleet = campaignEngine.getPlayerFleet();
        if (campaignFleet == null) {
            return;
        }
        boolean bl = this.isPlayerInRangeOfCommRelay();
        ArrayList<IntelInfoPlugin> arrayList = new ArrayList<IntelInfoPlugin>();
        for (IntelInfoPlugin intelInfoPlugin : new ArrayList<IntelInfoPlugin>(this.getCommQueueInternal())) {
            int n3 = n2 = !intelInfoPlugin.canMakeVisibleToPlayer(bl) && !intelInfoPlugin.forceAddNextFrame() ? 0 : 1;
            if (n2 == 0 || this.intel.contains((Object)intelInfoPlugin)) continue;
            arrayList.add(intelInfoPlugin);
        }
        if (arrayList.size() > 0) {
            int n4 = 3;
            boolean bl2 = arrayList.size() > n4 + 1;
            this.addToTimestamp = 0L;
            n2 = 0;
            for (IntelInfoPlugin intelInfoPlugin : arrayList) {
                this.addIntel(intelInfoPlugin, n2 >= n4 && bl2);
                intelInfoPlugin.setForceAddNextFrame(false);
                ++n2;
                while (this.commQueue.remove((Object)intelInfoPlugin)) {
                }
            }
            if (bl2) {
                IntelInfoPlugin intelInfoPlugin;
                intelInfoPlugin = new NewMessagesIntel(arrayList.size() - n4);
                CampaignEngine.getInstance().getCampaignUI().addMessage(intelInfoPlugin, CommMessageAPI.MessageClickAction.INTEL_TAB, "New");
            }
        }
        this.removeAllThatShouldBeRemoved();
    }

    public void clear() {
        this.commQueue.clear();
        this.intel.clear();
    }

    public void notifyPlayerAboutToOpenIntelScreen() {
        for (IntelInfoPlugin intelInfoPlugin : new ArrayList(this.intel.getList(IntelInfoPlugin.class))) {
            intelInfoPlugin.notifyPlayerAboutToOpenIntelScreen();
        }
        for (IntelInfoPlugin intelInfoPlugin : new ArrayList<IntelInfoPlugin>(this.getCommQueueInternal())) {
            intelInfoPlugin.notifyPlayerAboutToOpenIntelScreen();
        }
    }

    public void removeAllThatShouldBeRemoved() {
        for (IntelInfoPlugin intelInfoPlugin : new ArrayList(this.intel.getList(IntelInfoPlugin.class))) {
            if (!intelInfoPlugin.shouldRemoveIntel()) continue;
            this.removeIntel(intelInfoPlugin);
        }
        for (IntelInfoPlugin intelInfoPlugin : new ArrayList<IntelInfoPlugin>(this.getCommQueueInternal())) {
            if (!intelInfoPlugin.shouldRemoveIntel()) continue;
            this.removeIntel(intelInfoPlugin);
        }
    }

    public boolean hasIntelOfClass(Class<?> clazz) {
        return !this.intel.getList(clazz).isEmpty();
    }

    public boolean hasIntel(IntelInfoPlugin intelInfoPlugin) {
        return this.intel.contains((Object)intelInfoPlugin);
    }

    public boolean hasIntelQueued(IntelInfoPlugin intelInfoPlugin) {
        for (IntelInfoPlugin intelInfoPlugin2 : this.getCommQueueInternal()) {
            if (intelInfoPlugin2 != intelInfoPlugin) continue;
            return true;
        }
        return false;
    }

    public ObjectRepository getRepo() {
        return this.intel;
    }

    public List<IntelInfoPlugin> getIntel() {
        return this.getIntel(IntelInfoPlugin.class);
    }

    public List<IntelInfoPlugin> getIntel(Class clazz) {
        return this.intel.getList(clazz);
    }

    public IntelInfoPlugin getFirstIntel(Class clazz) {
        List list = this.intel.getList(clazz);
        if (list.isEmpty()) {
            return null;
        }
        return (IntelInfoPlugin)list.get(0);
    }

    public boolean unqueueIntel(IntelInfoPlugin intelInfoPlugin) {
        for (IntelInfoPlugin intelInfoPlugin2 : this.getCommQueueInternal()) {
            if (intelInfoPlugin2 != intelInfoPlugin) continue;
            this.commQueue.remove((Object)intelInfoPlugin2);
            return true;
        }
        return false;
    }

    public void queueIntel(IntelInfoPlugin intelInfoPlugin) {
        this.queueIntel(intelInfoPlugin, Float.MAX_VALUE);
    }

    public void queueIntel(IntelInfoPlugin intelInfoPlugin, float f2) {
        for (IntelInfoPlugin intelInfoPlugin2 : this.getCommQueueInternal()) {
            if (intelInfoPlugin2 != intelInfoPlugin) continue;
            this.commQueue.remove((Object)intelInfoPlugin2);
            break;
        }
        this.commQueue.add((Object)intelInfoPlugin);
    }

    public void addIntel(IntelInfoPlugin intelInfoPlugin) {
        this.addIntel(intelInfoPlugin, false);
    }

    public void addIntel(IntelInfoPlugin intelInfoPlugin, boolean bl) {
        this.addIntel(intelInfoPlugin, bl, null);
    }

    public void addIntel(IntelInfoPlugin intelInfoPlugin, boolean bl, TextPanelAPI textPanelAPI) {
        if (intelInfoPlugin != null && intelInfoPlugin.isEnded()) {
            return;
        }
        if (!this.intel.contains((Object)intelInfoPlugin)) {
            intelInfoPlugin.setPlayerVisibleTimestamp(Long.valueOf(Global.getSector().getClock().getTimestamp() + this.addToTimestamp));
            this.intel.add((Object)intelInfoPlugin);
            intelInfoPlugin.reportMadeVisibleToPlayer();
            if (!bl) {
                if (textPanelAPI == null && intelInfoPlugin.autoAddCampaignMessage()) {
                    CampaignEngine.getInstance().getCampaignUI().addMessage(intelInfoPlugin, CommMessageAPI.MessageClickAction.INTEL_TAB, intelInfoPlugin);
                } else if (textPanelAPI != null) {
                    this.addIntelToTextPanel(intelInfoPlugin, textPanelAPI);
                }
            }
        }
    }

    public void addIntelToTextPanel(IntelInfoPlugin intelInfoPlugin, TextPanelAPI textPanelAPI) {
        float f2;
        String string = intelInfoPlugin.getCommMessageSound();
        if (string != null) {
            f2 = 1.0f;
            float f3 = 1.0f;
            float f4 = Misc.getAbyssalDepthOfPlayer();
            if (f4 >= 1.0f) {
                f2 = 0.9f;
                f3 = 0.5f;
            }
            M.super(string, f2, f3);
        }
        f2 = 350.0f;
        if (textPanelAPI instanceof C) {
            C c2 = (C)textPanelAPI;
            f2 = Math.max(350.0f, c2.getWidth() - 20.0f);
        }
        super super_ = new super(intelInfoPlugin, null, f2);
        TooltipMakerAPI tooltipMakerAPI = textPanelAPI.beginTooltip();
        tooltipMakerAPI.addCustom((UIComponentAPI)super_, 0.0f);
        textPanelAPI.addTooltip();
    }

    public void removeIntel(IntelInfoPlugin intelInfoPlugin) {
        boolean bl = this.intel.remove((Object)intelInfoPlugin);
        if (bl |= this.unqueueIntel(intelInfoPlugin)) {
            intelInfoPlugin.reportRemovedIntel();
        }
    }

    public int getIntelCount(Class clazz, boolean bl) {
        int n2 = this.getIntel(clazz).size();
        if (bl) {
            n2 += this.getCommQueue(clazz).size();
        }
        return n2;
    }

    public ObjectRepository getCommQueueRepo() {
        return this.commQueue;
    }

    public List<IntelInfoPlugin> getCommQueueInternal() {
        return this.commQueue.getList(IntelInfoPlugin.class);
    }

    public List<IntelInfoPlugin> getCommQueue() {
        return this.getCommQueue(IntelInfoPlugin.class);
    }

    public List<IntelInfoPlugin> getCommQueue(Class clazz) {
        return this.commQueue.getList(clazz);
    }

    public boolean isPlayerInRangeOfCommRelay() {
        return this.findNearestCommRelayToReceive((SectorEntityToken)Global.getSector().getPlayerFleet()) != null;
    }

    private SectorEntityToken findNearestCommRelayToReceive(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken == null) {
            return null;
        }
        Vector2f vector2f = sectorEntityToken.getLocationInHyperspace();
        float f2 = StarfarerSettings.Object();
        SectorEntityToken sectorEntityToken2 = null;
        float f3 = Float.MAX_VALUE;
        if (sectorEntityToken.isInHyperspace()) {
            for (SectorEntityToken sectorEntityToken3 : CampaignEngine.getInstance().getHyperspace().getEntitiesWithTag("comm_relay")) {
                Vector2f f6;
                float f4;
                if (sectorEntityToken3.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional") || !((f4 = Utils.\u00d800000(f6 = sectorEntityToken3.getLocationInHyperspace(), vector2f) / f2) < f3) || !(f4 <= MAX_RELAY_RANGE_IN_HYPER_IN_LY)) continue;
                f3 = f4;
                sectorEntityToken2 = sectorEntityToken3;
            }
            for (StarSystemAPI starSystemAPI : CampaignEngine.getInstance().getStarSystems()) {
                SectorEntityToken sectorEntityToken3;
                float f5 = Utils.\u00d800000(starSystemAPI.getLocation(), vector2f) / f2;
                if (f5 > MAX_RANGE_AROUND_SYSTEM) continue;
                ArrayList arrayList = new ArrayList(starSystemAPI.getEntitiesWithTag("comm_relay"));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    sectorEntityToken3 = (SectorEntityToken)iterator.next();
                    if (!sectorEntityToken3.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) continue;
                    iterator.remove();
                }
                if (arrayList.isEmpty()) continue;
                sectorEntityToken3 = starSystemAPI.getLocation();
                if (!(f5 < f3) || !(f5 <= MAX_RANGE_AROUND_SYSTEM)) continue;
                f3 = f5;
                sectorEntityToken2 = (SectorEntityToken)arrayList.get(new Random().nextInt(arrayList.size()));
            }
        } else {
            for (SectorEntityToken sectorEntityToken4 : sectorEntityToken.getContainingLocation().getEntitiesWithTag("comm_relay")) {
                float f6;
                if (sectorEntityToken4.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional") || !((f6 = Utils.\u00d800000(sectorEntityToken.getLocation(), sectorEntityToken4.getLocation())) < f3)) continue;
                f3 = f6;
                sectorEntityToken2 = sectorEntityToken4;
            }
        }
        return sectorEntityToken2;
    }

    public void sortIntel(List<IntelInfoPlugin> list) {
        final ArrayList<IntelInfoPlugin> arrayList = new ArrayList<IntelInfoPlugin>(list);
        Collections.sort(list, new Comparator<IntelInfoPlugin>(){

            public int o00000(IntelInfoPlugin intelInfoPlugin, IntelInfoPlugin intelInfoPlugin2) {
                int n2;
                int n3;
                int n4;
                int n5 = intelInfoPlugin.getSortTier().ordinal();
                if (n5 != (n4 = intelInfoPlugin2.getSortTier().ordinal())) {
                    return n5 - n4;
                }
                String string = intelInfoPlugin.getSortString();
                String string2 = intelInfoPlugin2.getSortString();
                if (string != null && string2 == null) {
                    return -1;
                }
                if (string2 != null && string == null) {
                    return 1;
                }
                if (string != null && string2 != null && (n3 = string.compareTo(string2)) != 0) {
                    return n3;
                }
                Long l2 = intelInfoPlugin.getPlayerVisibleTimestamp();
                Long l3 = intelInfoPlugin2.getPlayerVisibleTimestamp();
                if (l2 == null) {
                    l2 = 0L;
                }
                if (l3 == null) {
                    l3 = 0L;
                }
                if ((n2 = (int)Math.signum(l3 - l2)) == 0) {
                    n2 = (int)Math.signum(arrayList.indexOf(intelInfoPlugin2) - arrayList.indexOf(intelInfoPlugin));
                }
                return n2;
            }
        });
    }
}

