/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.ConditionGenDataSpec;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.T;
import com.fs.util.DoNotObfuscate;

public class MarketCondition
implements DoNotObfuscate,
MarketConditionAPI {
    private String id;
    private transient T spec;
    private MarketConditionPlugin plugin;
    private String unique = Misc.genUID();
    private MarketAPI market;
    private boolean isSurveyed = true;
    private transient String idForMod = null;

    private MarketCondition() {
    }

    public MarketCondition(String string, MarketAPI marketAPI) {
        this.id = string;
        this.market = marketAPI;
        this.readResolve();
    }

    Object readResolve() {
        this.idForMod = String.valueOf(this.id) + "_" + this.unique;
        this.spec = SpecStore.super(T.class, this.id);
        if (this.spec == null) {
            throw new RuntimeException("Market condition [" + this.id + "] not found");
        }
        if (this.plugin == null) {
            this.plugin = this.spec.getNewPluginInstance();
            this.plugin.init(this.market, (MarketConditionAPI)this);
        }
        return this;
    }

    Object writeReplace() {
        if (this.plugin != null && this.plugin.isTransient()) {
            MarketCondition marketCondition = new MarketCondition();
            marketCondition.id = this.id;
            marketCondition.market = this.market;
            marketCondition.spec = this.spec;
            marketCondition.unique = this.unique;
            marketCondition.isSurveyed = this.isSurveyed;
            marketCondition.plugin = null;
            return marketCondition;
        }
        return this;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public String getIdForPluginModifications() {
        return this.idForMod;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        String string;
        if (this.plugin != null && (string = this.plugin.getName()) != null) {
            return string;
        }
        return this.spec.getName();
    }

    public MarketConditionPlugin getPlugin() {
        return this.plugin;
    }

    public T getSpec() {
        return this.spec;
    }

    public boolean isSurveyed() {
        return this.isSurveyed;
    }

    public void setSurveyed(boolean bl) {
        this.isSurveyed = bl;
    }

    public boolean requiresSurveying() {
        Object object = Global.getSettings().getSpec(ConditionGenDataSpec.class, this.id, true);
        if (object instanceof ConditionGenDataSpec) {
            ConditionGenDataSpec conditionGenDataSpec = (ConditionGenDataSpec)object;
            return conditionGenDataSpec.isRequiresSurvey();
        }
        return false;
    }

    public ConditionGenDataSpec getGenSpec() {
        Object object = Global.getSettings().getSpec(ConditionGenDataSpec.class, this.id, true);
        if (object instanceof ConditionGenDataSpec) {
            ConditionGenDataSpec conditionGenDataSpec = (ConditionGenDataSpec)object;
            return conditionGenDataSpec;
        }
        return null;
    }

    public boolean isPlanetary() {
        if (this.getPlugin() == null) {
            return true;
        }
        return this.getPlugin().isPlanetary();
    }

    public String toString() {
        return String.valueOf(this.getName()) + " id: " + this.getId() + ", " + this.getIdForPluginModifications();
    }
}

