/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract.iter;

import com.fs.profiler.Profiler;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.contract.ContractEconomy;
import com.fs.starfarer.campaign.econ.contract.iter.ContractsAndBidsTask;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.contract.iter.PrepStockpilesTask;
import com.fs.starfarer.campaign.econ.contract.iter.ReapplyConditionsTask;
import com.fs.starfarer.campaign.econ.contract.iter.UpdateConnectionWeightsTask;
import com.fs.starfarer.campaign.econ.contract.iter.UpdateDemandMetConditionsStabilityPriceMult;
import com.fs.starfarer.campaign.econ.contract.iter.UpdateGreedTask;
import com.fs.starfarer.campaign.econ.contract.iter.UpdateOutpostRelatedDemandTask;
import com.fs.starfarer.campaign.econ.contract.iter.UpdatePricesTask;
import com.fs.starfarer.loading.F;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ContractEconomyStepper
implements DoNotObfuscate {
    protected List<MultiFrameTask> tasks = null;
    private ContractEconomy contractEconomy;
    private State state = State.WAITING;
    private float elapsed = 1.0f;
    private float timeForLastCalc = 1.0f;
    private int steps = 0;

    public ContractEconomyStepper(ContractEconomy contractEconomy) {
        this.contractEconomy = contractEconomy;
    }

    public ContractEconomy getContractEconomy() {
        return this.contractEconomy;
    }

    public void setContractEconomy(ContractEconomy contractEconomy) {
        this.contractEconomy = contractEconomy;
    }

    public void nextFrame(float f2) {
        this.elapsed += f2;
        ContractEconomy.DEBUG = false;
        if (this.state == State.WAITING) {
            Profiler.\u00d200000((String)"Waiting");
            if (this.elapsed >= 1.0f) {
                this.state = State.DOING_TASKS;
                this.tasks = null;
                this.timeForLastCalc = this.elapsed;
                this.elapsed = 0.0f;
            }
            Profiler.o00000();
        }
        if (this.state == State.DOING_TASKS) {
            if (this.tasks == null) {
                this.createTasks();
            }
            if (this.isDone()) {
                return;
            }
            Profiler.\u00d200000((String)"Stepping economy");
            MultiFrameTask multiFrameTask = this.tasks.get(0);
            Profiler.\u00d200000((String)("Task: " + multiFrameTask.getClass().getSimpleName()));
            multiFrameTask.advance(f2);
            Profiler.o00000();
            if (multiFrameTask.isDone()) {
                this.tasks.remove(0);
            }
            if (this.tasks.isEmpty()) {
                this.state = State.WAITING;
            }
            Profiler.o00000();
        }
    }

    private void createTasks() {
        this.tasks = new ArrayList<MultiFrameTask>();
        this.tasks.add(new UpdateConnectionWeightsTask(this.contractEconomy.getEconomy()));
        this.tasks.add(new UpdateDemandMetConditionsStabilityPriceMult(this.contractEconomy));
        ArrayList<F> arrayList = new ArrayList<F>();
        for (String string : this.contractEconomy.getEconomy().getAllCommodityIds()) {
            F f2 = (F)this.contractEconomy.getEconomy().getCommoditySpec(string);
            if (!f2.isPrimary() || f2.hasTag("nonecon")) continue;
            arrayList.add(f2);
        }
        Collections.sort(arrayList, new Comparator<F>(){

            public int o00000(F f2, F f3) {
                return (int)Math.signum(f2.getEconomyTier() - f3.getEconomyTier());
            }
        });
        float f3 = Math.max(this.timeForLastCalc, 1.0f) / Economy.ECONOMY_INTERVAL_IN_GAME_DAYS;
        ++this.steps;
        for (F f4 : arrayList) {
            String string = f4.getDemandClass();
            this.tasks.add(new ReapplyConditionsTask(this.contractEconomy.getEconomy()));
            this.tasks.add(new UpdateOutpostRelatedDemandTask(this.contractEconomy, string));
            this.tasks.add(new UpdateGreedTask(this.contractEconomy, string));
            this.tasks.add(new UpdatePricesTask(this.contractEconomy.getEconomy(), string));
            this.tasks.add(new PrepStockpilesTask(this.contractEconomy, string));
            this.tasks.add(new ContractsAndBidsTask(this.contractEconomy, string, f3));
        }
        this.tasks.add(new UpdateDemandMetConditionsStabilityPriceMult(this.contractEconomy));
        this.contractEconomy.getTempData().clear();
    }

    public boolean isDone() {
        return this.tasks != null && this.tasks.isEmpty();
    }

    public static enum State implements DoNotObfuscate
    {
        WAITING,
        DOING_TASKS;

    }
}

