/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.fleet.FleetLogisticsAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.RepairTracker;
import com.fs.starfarer.coreui.ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;

public class LogisticsModule
implements FleetLogisticsAPI,
DoNotObfuscate {
    private CampaignFleet fleet;
    private transient CombatReadinessPlugin plugin = null;

    public LogisticsModule(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
        this.readResolve();
    }

    Object readResolve() {
        this.plugin = (CombatReadinessPlugin)StarfarerSettings.return("combatReadinessPlugin");
        return this;
    }

    public float getLightYearsPerDay() {
        return ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.getLYPerDayAtBurn(this.fleet, this.fleet.getFleetData().getBurnLevel());
    }

    public void advance(float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        boolean bl;
        if (this.fleet.isAIMode()) {
            bl = true;
        } else {
            f8 = this.getMarineSuppliesPerDay();
            f4 = (f8 + (f7 = this.getCrewSuppliesPerDay()) + (f6 = this.getShipMaintenanceSupplyCost()) + (f5 = this.getExcessCargoCapacitySupplyCost() + this.getExcessFuelCapacitySupplyCost() + this.getExcessPersonnelCapacitySupplyCost() + this.getExcessShipsSupplyCost())) * f2;
            if (f4 <= (f3 = this.fleet.getCargo().getSupplies()) && f3 > 0.0f) {
                this.fleet.getCargo().removeSupplies(f4);
                bl = true;
            } else {
                this.fleet.getCargo().removeSupplies(f3);
                bl = f3 > 0.0f;
            }
        }
        if (f2 > 0.0f) {
            for (FleetMember fleetMember : this.fleet.getMembers()) {
                fleetMember.setFleetData(this.fleet.getFleetData());
                fleetMember.getRepairTracker().advanceCRAndRepairs(f2, bl);
            }
        }
        if (!this.fleet.isAIMode()) {
            f8 = this.getBaseFuelCostPerLightYear();
            f7 = f8 * this.fleet.getStats().getFuelUseHyperMult().getModifiedValue();
            if (!this.fleet.isInHyperspace()) {
                f7 = 0.0f;
            }
            f6 = f8 * this.fleet.getStats().getFuelUseNormalMult().getModifiedValue();
            if (this.fleet.isInHyperspace()) {
                f6 = 0.0f;
            }
            f5 = f7 + f6;
            f3 = this.fleet.getStats().getDynamic().getStat("fuel_use_not_shown_on_map_mult").getModifiedValue();
            if ((f5 *= f3) > 0.0f) {
                f4 = this.fleet.getVelocity().length();
                float f9 = Misc.getSpeedForBurnLevel((float)20.0f);
                float f10 = 1.0f;
                if (f4 > f9) {
                    f10 = f9 / f4;
                }
                float f11 = f5 * (f4 *= CampaignEngine.getInstance().getClock().getSecondsPerDay()) / StarfarerSettings.Object() * f2;
                if ((f11 *= f10) > 0.0f) {
                    this.fleet.getCargo().removeFuel(f11);
                }
            }
        }
    }

    public float getBaseFuelCostPerLightYear() {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            float f3 = fleetMember.getStats().getFuelUseMod().computeEffective(fleetMember.getHullSpec().getCapacity().\u00d400000());
            f2 += f3;
        }
        return f2;
    }

    public float getFuelCostPerLightYear() {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            float f3 = fleetMember.getStats().getFuelUseMod().computeEffective(fleetMember.getHullSpec().getCapacity().\u00d400000());
            f2 += f3;
        }
        return f2 *= this.fleet.getStats().getFuelUseHyperMult().getModifiedValue();
    }

    public float getTotalSuppliesPerDay() {
        float f2 = this.getMarineSuppliesPerDay();
        float f3 = this.getCrewSuppliesPerDay();
        float f4 = this.getShipMaintenanceSupplyCost();
        float f5 = this.getExcessCargoCapacitySupplyCost() + this.getExcessFuelCapacitySupplyCost() + this.getExcessPersonnelCapacitySupplyCost() + this.getExcessShipsSupplyCost();
        float f6 = f2 + f3 + f4 + f5;
        return f6;
    }

    public boolean repairsNeeded() {
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            RepairTracker repairTracker;
            if (fleetMember.isMothballed() || !fleetMember.getStatus().needsRepairs() || !fleetMember.canBeRepaired() || fleetMember.isFighterWing() || (repairTracker = fleetMember.getRepairTracker()).isSuspendRepairs()) continue;
            return true;
        }
        return false;
    }

    public void updateRepairUtilizationForUI() {
        this.fleet.getFleetData().setSyncNeeded();
    }

    public float computeRepairRate(FleetMember fleetMember) {
        if (fleetMember.isSuspendRepairs()) {
            return 0.0f;
        }
        if (fleetMember.isMothballed()) {
            return 0.0f;
        }
        if (!fleetMember.getStatus().needsRepairs()) {
            return 0.0f;
        }
        return fleetMember.getRepairTracker().getRepairRatePerDay();
    }

    public float getExcessCargoCapacitySupplyCost() {
        float f2 = this.fleet.getCargo().getSpaceUsed() - this.fleet.getCargo().getMaxCapacity() * 1.0f;
        if (f2 > 0.0f) {
            float f3 = Global.getSettings().getFloat("maxSuppliesPerDayForOverCapacity");
            return Math.min(f3, f2 * StarfarerSettings.\u00d8\u00d20000());
        }
        return 0.0f;
    }

    public float getExcessFuelCapacitySupplyCost() {
        float f2 = this.fleet.getCargo().getFuel() - this.fleet.getCargo().getMaxFuel() * 1.0f;
        if (f2 > 0.0f) {
            float f3 = Global.getSettings().getFloat("maxSuppliesPerDayForOverCapacity");
            return Math.min(f3, f2 * StarfarerSettings.\u00d5\u00d80000());
        }
        return 0.0f;
    }

    public float getExcessPersonnelCapacitySupplyCost() {
        float f2 = (float)(this.fleet.getCargo().getTotalCrew() + this.fleet.getCargo().getMarines()) - this.fleet.getCargo().getMaxPersonnel() * 1.0f;
        if (f2 > 0.0f) {
            float f3 = Global.getSettings().getFloat("maxSuppliesPerDayForOverCapacity");
            return Math.min(f3, f2 * StarfarerSettings.\u00d4\u00d30000());
        }
        return 0.0f;
    }

    public float getExcessShipsSupplyCost() {
        float f2 = StarfarerSettings.this.new();
        float f3 = StarfarerSettings.int.String();
        float f4 = this.fleet.getFleetData().getMembers().size();
        if (f4 <= f2) {
            return 0.0f;
        }
        float f5 = this.getShipMaintenanceSupplyCost(o.\u00d200000);
        float f6 = f5 * (f3 * (f4 - f2));
        return f6;
    }

    public float getMarineSuppliesPerDay() {
        return (float)this.fleet.getCargo().getMarines() * StarfarerSettings.o\u00d80000();
    }

    public float getCrewSuppliesPerDay() {
        return (float)this.fleet.getCargo().getTotalCrew() * StarfarerSettings.\u00f6o0000();
    }

    public float getPersonnelSuppliesPerDay() {
        return this.getCrewSuppliesPerDay() + this.getMarineSuppliesPerDay();
    }

    public float getShipMaintenanceSupplyCost() {
        return this.getShipMaintenanceSupplyCost(o.\u00d300000);
    }

    public float getShipMaintenanceSupplyCost(o o2) {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            boolean bl;
            boolean bl2 = bl = fleetMember.isSuspendRepairs() || fleetMember.getRepairTracker().getRecoveryRate() <= 0.0f;
            if (o2 == o.String ? fleetMember.isMothballed() || fleetMember.getRepairTracker().getBaseCR() < fleetMember.getRepairTracker().getMaxCR() : (o2 == o.\u00d200000 ? fleetMember.isMothballed() : (o2 == o.\u00d500000 ? fleetMember.isMothballed() || bl || fleetMember.getRepairTracker().getBaseCR() >= fleetMember.getRepairTracker().getMaxCR() && !fleetMember.needsRepairs() : o2 == o.\u00d600000 && !fleetMember.isMothballed()))) continue;
            float f3 = LogisticsModule.getBaseSupplyUsePerMonth(fleetMember) / 30.0f;
            if (!(fleetMember.isMothballed() || bl || o2 == o.\u00d200000 || fleetMember.getRepairTracker().getBaseCR() >= fleetMember.getRepairTracker().getMaxCR() && !fleetMember.needsRepairs())) {
                f3 += LogisticsModule.getRecoverySupplyUsePerDay(fleetMember);
            }
            f2 += f3;
        }
        return f2;
    }

    public static float getRecoverySupplyUsePerDay(FleetMember fleetMember) {
        boolean bl = fleetMember.needsRepairs();
        boolean bl2 = fleetMember.getRepairTracker().getBaseCR() < fleetMember.getRepairTracker().getMaxCR();
        float f2 = fleetMember.getDeploymentCostSupplies();
        float f3 = fleetMember.getDeployCost();
        float f4 = fleetMember.getRepairTracker().getRecoveryRate();
        if (bl && !bl2) {
            f3 = fleetMember.getBaseDeployCost();
            f4 = fleetMember.getStats().getBaseCRRecoveryRatePercentPerDay().getBaseValue() * 0.01f;
        }
        if (f3 < 0.01f) {
            f3 = 0.01f;
        }
        if (f4 > 0.0f) {
            return f2 * f4 / f3;
        }
        return 0.0f;
    }

    public static float getBaseSupplyUsePerMonth(FleetMember fleetMember) {
        float f2 = fleetMember.getStats().getSuppliesPerMonth().getModifiedValue();
        if (fleetMember.isFighterWing()) {
            f2 *= (float)fleetMember.getStatus().getNumExistingFighters();
        }
        return f2;
    }

    public CampaignFleet getFleet() {
        return this.fleet;
    }

    public float getTotalRepairAndRecoverySupplyCost() {
        return this.getTotalRepairAndRecoverySupplyCost(true);
    }

    public float getTotalRepairAndRecoverySupplyCost(boolean bl) {
        if (this.fleet == null) {
            return 0.0f;
        }
        if (bl) {
            this.fleet.forceSync();
        }
        return this.fleet.getFleetData().getTotalRepairAndRecoverySupplyCostIgnoringLR();
    }

    public float getOverallRepairRatePercent() {
        return 100000.0f;
    }

    public float getDaysToFinishAllRepairs() {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            float f3;
            if (fleetMember.isFighterWing() || !fleetMember.canBeRepaired() || !fleetMember.needsRepairs() || !((f3 = fleetMember.getRepairTracker().getRemainingRepairTime()) > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum o {
        \u00d200000,
        String,
        \u00d500000,
        \u00d600000,
        \u00d300000;

    }

    public static interface Oo {
        public void o00000(FleetMember var1, float var2);
    }
}

