/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading.specs;

import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.campaign.PlanetSpecAPI;
import com.fs.starfarer.loading.D;
import com.fs.starfarer.loading.LoadingUtils;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class PlanetSpec
implements Cloneable,
PlanetSpecAPI,
DoNotObfuscate {
    public float tilt = 0.0f;
    public float pitch = 0.0f;
    public float rotation = 0.0f;
    public Color planetColor = Color.white;
    public float cloudRotation = 0.0f;
    public float atmosphereThickness = 0.1f;
    public float atmosphereThicknessMin = 10.0f;
    public Color atmosphereColor = Color.white;
    public Color cloudColor = Color.white;
    public Color iconColor = Color.white;
    public String texture;
    public String descriptionId;
    public String cloudTexture;
    public String iconTexture;
    public String starscapeIcon = null;
    public String glowTexture;
    public String coronaTexture;
    public float shieldThickness;
    public String shieldTexture;
    public Color shieldColor;
    public float shieldThickness2;
    public String shieldTexture2;
    public Color shieldColor2;
    public Color coronaColor;
    public Color glowColor = Color.white;
    public boolean useReverseLightForGlow = true;
    public float coronaSize;
    public boolean isStar = false;
    public boolean isBlackHole = false;
    public boolean isNebulaCenter = false;
    public float scaleMultMapIcon = 1.0f;
    public float scaleMultStarscapeIcon = 1.0f;
    public Vector3f lightPosition;
    public float cloudAlpha = 255.0f;
    public String planetType;
    public String name;
    public String aOrAn;
    public boolean isGasGiant = false;
    public boolean isPulsar = false;
    public boolean doNotShowInCombat = false;
    public Set<String> tags = new LinkedHashSet<String>();
    private ModSpecAPI sourceMod = null;

    public static PlanetSpecDiff createDiff(String string, PlanetSpec planetSpec) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        PlanetSpecDiff planetSpecDiff = new PlanetSpecDiff();
        PlanetSpec planetSpec2 = SpecStore.super(PlanetSpec.class, string);
        Field[] fieldArray = PlanetSpec.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            PlanetSpec.checkField(planetSpec, planetSpec2, planetSpecDiff, field.getName());
            ++n3;
        }
        return planetSpecDiff;
    }

    public static void updateFromDiff(PlanetSpec planetSpec, PlanetSpecDiff planetSpecDiff) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        for (String string : planetSpecDiff.data.keySet()) {
            PlanetSpec.setField(planetSpec, planetSpecDiff, string);
        }
    }

    public static void checkField(PlanetSpec planetSpec, PlanetSpec planetSpec2, PlanetSpecDiff planetSpecDiff, String string) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Object object = PlanetSpec.class.getField(string).get(planetSpec2);
        Object object2 = PlanetSpec.class.getField(string).get(planetSpec);
        boolean bl = false;
        bl |= object == null && object2 != null;
        bl |= object != null && object2 == null;
        if (object != null && object2 != null) {
            boolean bl2 = bl = !object.equals(object2);
        }
        if (bl) {
            planetSpecDiff.data.put(string, object2);
        }
    }

    public static void setField(PlanetSpec planetSpec, PlanetSpecDiff planetSpecDiff, String string) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (planetSpecDiff.data.containsKey(string)) {
            Object object = planetSpecDiff.data.get(string);
            PlanetSpec.class.getField(string).set(planetSpec, object);
        }
    }

    public PlanetSpec clone() {
        try {
            PlanetSpec planetSpec = (PlanetSpec)super.clone();
            planetSpec.lightPosition = new Vector3f((ReadableVector3f)this.lightPosition);
            planetSpec.tags = new LinkedHashSet<String>(this.tags);
            return planetSpec;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public PlanetSpec(String string, JSONObject jSONObject) throws JSONException {
        this.planetType = string;
        this.setSourceMod(jSONObject);
        this.name = jSONObject.optString("name", "Unknown");
        this.aOrAn = jSONObject.optString("aOrAn", "a");
        this.tilt = (float)jSONObject.optDouble("tilt", 0.0);
        this.pitch = (float)jSONObject.optDouble("pitch", 0.0);
        this.rotation = (float)jSONObject.optDouble("rotation", 0.0);
        this.cloudRotation = (float)jSONObject.optDouble("cloudRotation", 0.0);
        this.cloudAlpha = (float)jSONObject.optDouble("cloudAlpha", 255.0);
        this.atmosphereThickness = (float)jSONObject.optDouble("atmosphereThickness", (double)0.1f);
        this.atmosphereThicknessMin = (float)jSONObject.optDouble("atmosphereThicknessMin", 10.0);
        this.planetColor = D.\u00d600000(jSONObject, "planetColor");
        this.iconColor = D.\u00d600000(jSONObject, "iconColor");
        this.atmosphereColor = D.\u00d600000(jSONObject, "atmosphereColor");
        this.cloudColor = D.\u00d600000(jSONObject, "cloudColor");
        this.lightPosition = D.\u00d300000(jSONObject, "lightPosition");
        this.texture = jSONObject.getString("texture");
        this.cloudTexture = jSONObject.optString("cloudTexture", null);
        this.descriptionId = jSONObject.optString("descriptionId", string);
        this.iconTexture = jSONObject.getString("icon");
        this.isStar = jSONObject.optBoolean("isStar", false);
        this.coronaTexture = jSONObject.optString("starCoronaSprite", StarfarerSettings.\u00d200000("planets", "default_sun_halo"));
        this.coronaColor = D.\u00d600000(jSONObject, "starCoronaColor");
        this.coronaSize = (float)jSONObject.optDouble("starCoronaSizeMult", 0.0);
        this.isGasGiant = jSONObject.optBoolean("isGasGiant", false);
        this.doNotShowInCombat = jSONObject.optBoolean("doNotShowInCombat", false);
        this.isPulsar = jSONObject.optBoolean("isPulsar", false);
        this.isBlackHole = jSONObject.optBoolean("isBlackHole", false);
        this.isNebulaCenter = jSONObject.optBoolean("isNebulaCenter", false);
        this.scaleMultMapIcon = (float)jSONObject.optDouble("scaleMultMapIcon", 1.0);
        this.scaleMultStarscapeIcon = (float)jSONObject.optDouble("scaleMultStarscapeIcon", 1.0);
        this.starscapeIcon = jSONObject.optString("starscapeIcon", null);
        this.glowTexture = jSONObject.optString("glowTexture", null);
        this.glowColor = D.\u00d600000(jSONObject, "glowColor");
        this.useReverseLightForGlow = jSONObject.optBoolean("useReverseLightForGlow", false);
        JSONArray jSONArray = jSONObject.optJSONArray("tags");
        if (jSONArray != null) {
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                String string2 = jSONArray.optString(n2);
                if (string2 != null && !string2.isBlank()) {
                    this.addTag(string2);
                }
                ++n2;
            }
        }
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String string) {
        this.tags.add(string);
    }

    public boolean hasTag(String string) {
        return this.tags.contains(string);
    }

    public boolean isDoNotShowInCombat() {
        return this.doNotShowInCombat;
    }

    public void setDoNotShowInCombat(boolean bl) {
        this.doNotShowInCombat = bl;
    }

    public boolean isPulsar() {
        return this.isPulsar;
    }

    public void setPulsar(boolean bl) {
        this.isPulsar = bl;
    }

    public String getStarscapeIcon() {
        return this.starscapeIcon;
    }

    public void setStarscapeIcon(String string) {
        this.starscapeIcon = string;
    }

    public boolean isBlackHole() {
        return this.isBlackHole;
    }

    public void setBlackHole(boolean bl) {
        this.isBlackHole = bl;
    }

    public boolean isNebulaCenter() {
        return this.isNebulaCenter;
    }

    public void setNebulaCenter(boolean bl) {
        this.isNebulaCenter = bl;
    }

    public float getScaleMultMapIcon() {
        return this.scaleMultMapIcon;
    }

    public void setScaleMultMapIcon(float f2) {
        this.scaleMultMapIcon = f2;
    }

    public float getScaleMultStarscapeIcon() {
        return this.scaleMultStarscapeIcon;
    }

    public void setScaleMultStarscapeIcon(float f2) {
        this.scaleMultStarscapeIcon = f2;
    }

    public String getAOrAn() {
        return this.aOrAn;
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public void setDescriptionId(String string) {
        this.descriptionId = string;
    }

    public String getGlowTexture() {
        return this.glowTexture;
    }

    public void setGlowTexture(String string) {
        this.glowTexture = string;
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color color) {
        this.glowColor = color;
    }

    public boolean isUseReverseLightForGlow() {
        return this.useReverseLightForGlow;
    }

    public void setUseReverseLightForGlow(boolean bl) {
        this.useReverseLightForGlow = bl;
    }

    public void setTexture(String string) {
        this.texture = string;
    }

    public void setCloudTexture(String string) {
        this.cloudTexture = string;
    }

    public float getCoronaSize() {
        return this.coronaSize;
    }

    public void setCoronaSize(float f2) {
        this.coronaSize = f2;
    }

    public String getCoronaTexture() {
        return this.coronaTexture;
    }

    public void setCoronaTexture(String string) {
        this.coronaTexture = string;
    }

    public Color getCoronaColor() {
        return this.coronaColor;
    }

    public void setCoronaColor(Color color) {
        this.coronaColor = color;
    }

    public boolean isGasGiant() {
        return this.isGasGiant;
    }

    public void setGasGiant(boolean bl) {
        this.isGasGiant = bl;
    }

    public String getName() {
        return this.name;
    }

    public float getTilt() {
        return this.tilt;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRotation() {
        return this.rotation;
    }

    public Color getPlanetColor() {
        return this.planetColor;
    }

    public float getAtmosphereThickness() {
        return this.atmosphereThickness;
    }

    public Color getAtmosphereColor() {
        return this.atmosphereColor;
    }

    public String getTexture() {
        return this.texture;
    }

    public String getIconTexture() {
        return this.iconTexture;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public String getPlanetType() {
        return this.planetType;
    }

    public float getAtmosphereThicknessMin() {
        return this.atmosphereThicknessMin;
    }

    public Vector3f getLightPosition() {
        return this.lightPosition;
    }

    public String getCloudTexture() {
        return this.cloudTexture;
    }

    public float getCloudRotation() {
        return this.cloudRotation;
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    public Color getCloudColor() {
        return this.cloudColor;
    }

    public void setTilt(float f2) {
        this.tilt = f2;
    }

    public void setPitch(float f2) {
        this.pitch = f2;
    }

    public void setRotation(float f2) {
        this.rotation = f2;
    }

    public void setPlanetColor(Color color) {
        this.planetColor = color;
    }

    public void setCloudRotation(float f2) {
        this.cloudRotation = f2;
    }

    public void setAtmosphereThickness(float f2) {
        this.atmosphereThickness = f2;
    }

    public void setAtmosphereThicknessMin(float f2) {
        this.atmosphereThicknessMin = f2;
    }

    public void setAtmosphereColor(Color color) {
        this.atmosphereColor = color;
    }

    public void setCloudColor(Color color) {
        this.cloudColor = color;
    }

    public void setIconColor(Color color) {
        this.iconColor = color;
    }

    public float getShieldThickness() {
        return this.shieldThickness;
    }

    public void setShieldThickness(float f2) {
        this.shieldThickness = f2;
    }

    public String getShieldTexture() {
        return this.shieldTexture;
    }

    public void setShieldTexture(String string) {
        this.shieldTexture = string;
    }

    public String getShieldTexture2() {
        return this.shieldTexture2;
    }

    public void setShieldTexture2(String string) {
        this.shieldTexture2 = string;
    }

    public float getShieldThickness2() {
        return this.shieldThickness2;
    }

    public void setShieldThickness2(float f2) {
        this.shieldThickness2 = f2;
    }

    public Color getShieldColor2() {
        return this.shieldColor2;
    }

    public void setShieldColor2(Color color) {
        this.shieldColor2 = color;
    }

    public Color getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(Color color) {
        this.shieldColor = color;
    }

    public ModSpecAPI getSourceMod() {
        return this.sourceMod;
    }

    public void setSourceMod(JSONObject jSONObject) {
        this.sourceMod = SpecStore.super(jSONObject.optString(LoadingUtils.super));
    }

    public static class PlanetSpecDiff
    implements DoNotObfuscate {
        public transient Map<String, Object> data = new HashMap<String, Object>();
        private String j = null;

        protected Object readResolve() throws JSONException {
            this.data = new HashMap<String, Object>();
            if (this.j != null) {
                JSONObject jSONObject = new JSONObject(this.j);
                String[] stringArray = JSONObject.getNames((JSONObject)jSONObject);
                if (stringArray != null) {
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = stringArray2[n3];
                        Object object = jSONObject.get(string);
                        if (object == null || object.equals("null")) {
                            this.data.put(string, null);
                        } else if (object instanceof JSONArray && string.toLowerCase().contains("color")) {
                            this.data.put(string, D.\u00d600000(jSONObject, string));
                        } else if (object instanceof Float) {
                            this.data.put(string, Float.valueOf(((Float)object).floatValue()));
                        } else if (object instanceof Integer) {
                            this.data.put(string, Float.valueOf(((Integer)object).floatValue()));
                        } else if (object instanceof Double) {
                            this.data.put(string, Float.valueOf(((Double)object).floatValue()));
                        } else if (object instanceof Boolean) {
                            this.data.put(string, (boolean)((Boolean)object));
                        } else if (object instanceof String) {
                            this.data.put(string, object);
                        } else if (object instanceof JSONArray) {
                            JSONArray jSONArray = (JSONArray)object;
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                            int n4 = 0;
                            while (n4 < jSONArray.length()) {
                                String string2 = jSONArray.optString(n4);
                                if (string2 != null && !string2.isBlank()) {
                                    linkedHashSet.add(string2);
                                }
                                ++n4;
                            }
                            this.data.put(string, linkedHashSet);
                        }
                        ++n3;
                    }
                }
                this.j = null;
            }
            return this;
        }

        protected Object writeReplace() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            for (String string : this.data.keySet()) {
                Object object = this.data.get(string);
                if (object == null) {
                    jSONObject.put(string, (Object)"null");
                    continue;
                }
                if (object instanceof Color) {
                    D.new(jSONObject, string, (Color)object);
                    continue;
                }
                if (object instanceof Float) {
                    jSONObject.put(string, (double)((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string, (double)((Integer)object).floatValue());
                    continue;
                }
                if (object instanceof Double) {
                    jSONObject.put(string, (double)((Double)object).floatValue());
                    continue;
                }
                if (object instanceof Boolean) {
                    jSONObject.put(string, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof String) {
                    jSONObject.put(string, object);
                    continue;
                }
                if (!(object instanceof Set)) continue;
                Set set = (Set)object;
                JSONArray jSONArray = new JSONArray();
                for (Object e2 : set) {
                    if (!(e2 instanceof String)) continue;
                    jSONArray.put((Object)((String)e2));
                }
                jSONObject.put(string, (Object)jSONArray);
            }
            this.j = jSONObject.toString();
            if (JSONObject.getNames((JSONObject)jSONObject) == null) {
                this.j = null;
            }
            return this;
        }
    }
}

