/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import java.util.ArrayList;
import java.util.List;

public class PlayerMarketTransaction {
    private float creditValue;
    private CargoAPI bought = Global.getFactory().createCargo(true);
    private CargoAPI sold = Global.getFactory().createCargo(true);
    private List<TransactionLineItem> lineItems = new ArrayList<TransactionLineItem>();
    private MarketAPI market;
    private SubmarketAPI submarket;
    private List<ShipSaleInfo> shipsBought = new ArrayList<ShipSaleInfo>();
    private List<ShipSaleInfo> shipsSold = new ArrayList<ShipSaleInfo>();
    private final CampaignUIAPI.CoreUITradeMode tradeMode;

    public PlayerMarketTransaction(MarketAPI market, SubmarketAPI submarket, CampaignUIAPI.CoreUITradeMode tradeMode) {
        this.market = market;
        this.submarket = submarket;
        this.tradeMode = tradeMode;
    }

    public CampaignUIAPI.CoreUITradeMode getTradeMode() {
        return this.tradeMode;
    }

    public List<TransactionLineItem> getLineItems() {
        return this.lineItems;
    }

    public float getBaseTradeValueImpact() {
        float val;
        float qty;
        float total = 0.0f;
        for (CargoStackAPI stack : this.bought.getStacksCopy()) {
            qty = stack.getSize();
            val = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadyBought(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            total += val;
        }
        for (CargoStackAPI stack : this.sold.getStacksCopy()) {
            qty = stack.getSize();
            val = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadySold(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            total += val;
        }
        return total;
    }

    public float getCreditValue() {
        return this.creditValue;
    }

    public void setCreditValue(float creditValue) {
        this.creditValue = creditValue;
    }

    public CargoAPI getBought() {
        return this.bought;
    }

    public void setBought(CargoAPI bought) {
        this.bought = bought;
    }

    public CargoAPI getSold() {
        return this.sold;
    }

    public void setSold(CargoAPI sold) {
        this.sold = sold;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public SubmarketAPI getSubmarket() {
        return this.submarket;
    }

    public float getQuantityBought(String commodityId) {
        return this.getBought().getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId);
    }

    public float getQuantitySold(String commodityId) {
        return this.getSold().getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId);
    }

    public List<ShipSaleInfo> getShipsBought() {
        return this.shipsBought;
    }

    public List<ShipSaleInfo> getShipsSold() {
        return this.shipsSold;
    }

    public static enum LineItemType {
        BOUGHT,
        SOLD,
        UPDATE;

    }

    public static class ShipSaleInfo {
        private FleetMemberAPI member;
        private float price;

        public ShipSaleInfo(FleetMemberAPI member, float price) {
            this.member = member;
            this.price = price;
        }

        public FleetMemberAPI getMember() {
            return this.member;
        }

        public void setMember(FleetMemberAPI member) {
            this.member = member;
        }

        public float getPrice() {
            return this.price;
        }

        public void setPrice(float price) {
            this.price = price;
        }
    }

    public static class TransactionLineItem {
        private String id;
        private LineItemType itemType;
        private CargoAPI.CargoItemType cargoType;
        private SubmarketAPI submarket;
        private float quantity;
        private float price;
        private float tariff;
        private float demandPrice;
        private float demandTariff;
        private long timestamp;

        public TransactionLineItem(String id, LineItemType itemType, CargoAPI.CargoItemType cargoType, SubmarketAPI submarket, float quantity, float price, float tariff, long timestamp) {
            this.id = id;
            this.itemType = itemType;
            this.cargoType = cargoType;
            this.submarket = submarket;
            this.quantity = quantity;
            this.price = price;
            this.tariff = tariff;
            this.timestamp = timestamp;
        }

        public float getDemandPrice() {
            return this.demandPrice;
        }

        public void setDemandPrice(float price2) {
            this.demandPrice = price2;
        }

        public float getDemandTariff() {
            return this.demandTariff;
        }

        public void setDemandTariff(float demandTariff) {
            this.demandTariff = demandTariff;
        }

        public float getTariff() {
            return this.tariff;
        }

        public void setTariff(float tariff) {
            this.tariff = tariff;
        }

        public SubmarketAPI getSubmarket() {
            return this.submarket;
        }

        public void setSubmarket(SubmarketAPI submarket) {
            this.submarket = submarket;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public LineItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(LineItemType itemType) {
            this.itemType = itemType;
        }

        public CargoAPI.CargoItemType getCargoType() {
            return this.cargoType;
        }

        public void setCargoType(CargoAPI.CargoItemType cargoType) {
            this.cargoType = cargoType;
        }

        public float getQuantity() {
            return this.quantity;
        }

        public void setQuantity(float quantity) {
            this.quantity = quantity;
        }

        public float getPrice() {
            return this.price;
        }

        public void setPrice(float price) {
            this.price = price;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

