/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONException;

public class BaseSpecialItemPlugin
implements SpecialItemPlugin {
    protected SpecialItemSpecAPI spec;
    protected CargoStackAPI stack;
    protected String itemId;

    public String getId() {
        return this.itemId;
    }

    @Override
    public void setId(String id) {
        this.itemId = id;
        this.spec = Global.getSettings().getSpecialItemSpec(id);
    }

    @Override
    public void init(CargoStackAPI stack) {
        this.stack = stack;
    }

    @Override
    public void performRightClickAction(SpecialItemPlugin.RightClickActionHelper helper) {
        this.performRightClickAction();
    }

    @Override
    public void performRightClickAction() {
    }

    @Override
    public boolean hasRightClickAction() {
        return false;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        boolean useGray = true;
        if (this.getClass() == BaseSpecialItemPlugin.class || Global.CODEX_TOOLTIP_MODE) {
            useGray = false;
        }
        this.createTooltip(tooltip, expanded, transferHandler, stackSource, useGray);
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource, boolean useGray) {
        float opad = 10.0f;
        if (!Global.CODEX_TOOLTIP_MODE) {
            tooltip.addTitle(this.getName());
        } else {
            tooltip.addSpacer(-opad);
        }
        String design = this.getDesignType();
        Misc.addDesignTypePara(tooltip, design, opad);
        if (Global.CODEX_TOOLTIP_MODE) {
            tooltip.setParaSmallInsignia();
        }
        if (!this.spec.getDesc().isEmpty()) {
            Color c = Misc.getTextColor();
            if (useGray) {
                c = Misc.getGrayColor();
            }
            tooltip.addPara(this.spec.getDesc(), c, opad);
        }
        if (this.getClass() == BaseSpecialItemPlugin.class) {
            this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        }
    }

    @Override
    public float getTooltipWidth() {
        return 450.0f;
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.spec != null) {
            return (int)this.spec.getBasePrice();
        }
        return 0;
    }

    protected float getItemPriceMult() {
        return Global.getSettings().getFloat("blueprintPriceOriginalItemMult");
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
    }

    protected void addCostLabel(TooltipMakerAPI tooltip, float pad, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        if (this.stack == null) {
            return;
        }
        if (Global.CODEX_TOOLTIP_MODE) {
            int cost = this.stack.getBaseValuePerUnit();
            tooltip.setParaFontDefault();
            tooltip.addPara("Base value: %s", pad, Misc.getGrayColor(), Misc.getHighlightColor(), Misc.getDGSCredits(cost));
            return;
        }
        ItemCostLabelData data = this.getCostLabelData(this.stack, transferHandler, stackSource);
        LabelAPI label = tooltip.addPara(data.text, pad);
        if (data.highlights != null) {
            label.setHighlight(data.highlights.getText());
            label.setHighlightColors(data.highlights.getColors());
        }
    }

    protected ItemCostLabelData getCostLabelData(CargoStackAPI stack, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        SpecialItemSpecAPI spec;
        String text = "";
        String highlight = null;
        Highlights highlights = null;
        Color highlightColor = Misc.getHighlightColor();
        SubmarketPlugin.TransferAction action = SubmarketPlugin.TransferAction.PLAYER_BUY;
        if (transferHandler != null && stackSource == transferHandler.getManifestOne()) {
            action = SubmarketPlugin.TransferAction.PLAYER_SELL;
        }
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL && stack.getSpecialItemSpecIfSpecial() != null && (spec = stack.getSpecialItemSpecIfSpecial()).hasTag("mission_item")) {
            highlight = text = "Can not remove item";
            highlights = new Highlights();
            highlights.append(text, Misc.getNegativeHighlightColor());
            ItemCostLabelData data = new ItemCostLabelData();
            data.text = text;
            data.highlights = highlights;
            return data;
        }
        if (transferHandler != null && transferHandler.getSubmarketTradedWith() != null && transferHandler.getSubmarketTradedWith().isIllegalOnSubmarket(stack, action)) {
            highlightColor = Misc.getNegativeHighlightColor();
            highlight = text = transferHandler.getSubmarketTradedWith().getPlugin().getIllegalTransferText(stack, action);
            highlights = transferHandler.getSubmarketTradedWith().getPlugin().getIllegalTransferTextHighlights(stack, SubmarketPlugin.TransferAction.PLAYER_BUY);
        } else if (stackSource != null && transferHandler != null && !transferHandler.isNoCost()) {
            if (stackSource == transferHandler.getManifestOne()) {
                int cost = (int)transferHandler.computeCurrentSingleItemSellCost(stack);
                text = "Sells for: " + Misc.getDGSCredits(cost) + " per unit.";
                highlight = Misc.getDGSCredits(cost);
            } else {
                int cost = (int)transferHandler.computeCurrentSingleItemBuyCost(stack);
                text = "Price: " + Misc.getDGSCredits(cost) + " per unit.";
                highlight = Misc.getDGSCredits(cost);
            }
        } else {
            int cost = stack.getBaseValuePerUnit();
            text = "Base value: " + Misc.getDGSCredits(cost) + " per unit.";
            highlight = Misc.getDGSCredits(cost);
        }
        if (highlights == null) {
            highlights = new Highlights();
            highlights.setText(highlight);
            highlights.setColors(highlightColor);
        }
        ItemCostLabelData data = new ItemCostLabelData();
        data.text = text;
        data.highlights = highlights;
        return data;
    }

    @Override
    public String resolveDropParamsToSpecificItemData(String params, Random random) throws JSONException {
        return "";
    }

    protected void addShipList(TooltipMakerAPI tooltip, String title, List<String> hulls, int max, float opad) {
        this.addBlueprintList(tooltip, title, hulls, max, opad, new BlueprintLister(){

            @Override
            public boolean isKnown(String id) {
                if (Global.CODEX_TOOLTIP_MODE) {
                    return false;
                }
                return Global.getSector().getPlayerFaction().knowsShip(id);
            }

            @Override
            public String getNoun(int num) {
                if (num == 1) {
                    return "hull";
                }
                return "hulls";
            }

            @Override
            public String getName(String id) {
                ShipHullSpecAPI spec = Global.getSettings().getHullSpec(id);
                return spec.getNameWithDesignationWithDashClass();
            }
        });
    }

    protected void addWeaponList(TooltipMakerAPI tooltip, String title, List<String> weapons, int max, float opad) {
        this.addBlueprintList(tooltip, title, weapons, max, opad, new BlueprintLister(){

            @Override
            public boolean isKnown(String id) {
                if (Global.CODEX_TOOLTIP_MODE) {
                    return false;
                }
                return Global.getSector().getPlayerFaction().knowsWeapon(id);
            }

            @Override
            public String getNoun(int num) {
                if (num == 1) {
                    return "weapon";
                }
                return "weapons";
            }

            @Override
            public String getName(String id) {
                WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(id);
                return spec.getWeaponName();
            }
        });
    }

    protected void addFighterList(TooltipMakerAPI tooltip, String title, List<String> wings, int max, float opad) {
        this.addBlueprintList(tooltip, title, wings, max, opad, new BlueprintLister(){

            @Override
            public boolean isKnown(String id) {
                if (Global.CODEX_TOOLTIP_MODE) {
                    return false;
                }
                return Global.getSector().getPlayerFaction().knowsFighter(id);
            }

            @Override
            public String getNoun(int num) {
                if (num == 1) {
                    return "fighter LPC";
                }
                return "fighter LPCs";
            }

            @Override
            public String getName(String id) {
                FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(id);
                return spec.getWingName();
            }
        });
    }

    protected void addBlueprintList(TooltipMakerAPI tooltip, String title, List<String> ids, int max, float opad, BlueprintLister lister) {
        float small;
        Color b = Misc.getButtonTextColor();
        Color g = Misc.getGrayColor();
        if (Global.CODEX_TOOLTIP_MODE) {
            tooltip.setParaSmallInsignia();
        }
        tooltip.addPara(title, opad);
        if (Global.CODEX_TOOLTIP_MODE) {
            tooltip.setParaFontDefault();
        }
        String tab = "        ";
        float pad = small = 5.0f;
        int left = ids.size();
        ArrayList<String> copy = new ArrayList<String>();
        for (String id : ids) {
            if (lister.isKnown(id)) continue;
            copy.add(id);
        }
        for (String id : ids) {
            if (!lister.isKnown(id)) continue;
            copy.add(id);
        }
        ids = copy;
        for (String id : ids) {
            boolean known = lister.isKnown(id);
            if (known) {
                tooltip.addPara(String.valueOf(tab) + lister.getName(id) + " (known)", g, pad);
            } else {
                tooltip.addPara(String.valueOf(tab) + lister.getName(id), b, pad);
            }
            pad = 3.0f;
            if (ids.size() - --left >= max - 1) break;
        }
        if (ids.isEmpty()) {
            tooltip.addPara(String.valueOf(tab) + "None", pad);
        }
        if (left > 0) {
            String noun = lister.getNoun(left);
            tooltip.addPara(String.valueOf(tab) + "... and %s other " + noun, pad, Misc.getHighlightColor(), "" + left);
        }
    }

    @Override
    public String getDesignType() {
        return this.spec.getManufacturer();
    }

    @Override
    public SpecialItemSpecAPI getSpec() {
        return this.spec;
    }

    protected static interface BlueprintLister {
        public boolean isKnown(String var1);

        public String getNoun(int var1);

        public String getName(String var1);
    }

    public static class ItemCostLabelData {
        public String text;
        public Highlights highlights;
    }
}

