/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.ShoveFleetScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ExplosionEntityPlugin
extends BaseCustomEntityPlugin {
    protected ExplosionParams params;
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected transient SpriteAPI sprite;
    protected float shockwaveRadius;
    protected float shockwaveWidth;
    protected float shockwaveSpeed;
    protected float shockwaveDuration;
    protected float shockwaveAccel;
    protected float maxParticleSize;
    protected LinkedHashSet<String> damagedAlready = new LinkedHashSet();

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
        this.params = (ExplosionParams)pluginParams;
        if (this.params.where.isCurrentLocation()) {
            Global.getSoundPlayer().playSound("gate_explosion", 1.0f, 1.0f, this.params.loc, Misc.ZERO);
        }
        float baseSize = this.params.radius * 0.08f;
        this.maxParticleSize = baseSize * 2.0f;
        float fullArea = (float)(Math.PI * (double)this.params.radius * (double)this.params.radius);
        float particleArea = (float)(Math.PI * (double)baseSize * (double)baseSize);
        int count = Math.round(fullArea / particleArea * 1.0f);
        float durMult = 2.0f;
        durMult = this.params.durationMult;
        int i = 0;
        while (i < count) {
            float size = baseSize * (1.0f + (float)Math.random());
            Color randomColor = new Color(Misc.random.nextInt(256), Misc.random.nextInt(256), Misc.random.nextInt(256), this.params.color.getAlpha());
            Color adjustedColor = Misc.interpolateColor(this.params.color, randomColor, 0.2f);
            adjustedColor = this.params.color;
            ParticleData data = new ParticleData(adjustedColor, size, (0.25f + (float)Math.random()) * 2.0f * durMult, 3.0f);
            float r = (float)Math.random();
            float dist = this.params.radius * 0.2f * (0.1f + r * 0.9f);
            float dir = (float)Math.random() * 360.0f;
            data.setOffset(dir, dist, dist);
            dir = Misc.getAngleInDegrees(data.offset);
            data.swImpact = (float)Math.random();
            if (i > count / 2) {
                data.swImpact = 1.0f;
            }
            this.particles.add(data);
            ++i;
        }
        Vector2f loc = new Vector2f((ReadableVector2f)this.params.loc);
        loc.x -= this.params.radius * 0.01f;
        loc.y += this.params.radius * 0.01f;
        float b = 1.0f;
        this.params.where.addHitParticle(loc, new Vector2f(), this.params.radius * 1.0f, b, 1.0f * durMult, this.params.color);
        loc = new Vector2f((ReadableVector2f)this.params.loc);
        this.params.where.addHitParticle(loc, new Vector2f(), this.params.radius * 0.4f, 0.5f, 1.0f * durMult, Color.white);
        this.shockwaveAccel = baseSize * 70.0f / durMult;
        this.shockwaveRadius = 0.0f;
        this.shockwaveRadius = -this.params.radius * 0.5f;
        this.shockwaveSpeed = this.params.radius * 2.0f / durMult;
        this.shockwaveDuration = this.params.radius * 2.0f / this.shockwaveSpeed;
        this.shockwaveWidth = this.params.radius * 0.5f;
    }

    Object readResolve() {
        this.sprite = Global.getSettings().getSprite("misc", "nebula_particles");
        return this;
    }

    @Override
    public void advance(float amount) {
        for (ParticleData p : new ArrayList<ParticleData>(this.particles)) {
            p.advance(amount);
            if (!(p.elapsed >= p.maxDur)) continue;
            this.particles.remove(p);
        }
        if (this.particles.isEmpty()) {
            this.entity.setExpired(true);
        }
        this.applyDamageToFleets();
        if (this.shockwaveDuration > 0.0f) {
            this.shockwaveRadius += this.shockwaveSpeed * amount;
            if (this.shockwaveSpeed < 0.0f) {
                this.shockwaveSpeed = 0.0f;
            }
            this.shockwaveDuration -= amount;
            for (ParticleData p : this.particles) {
                float dist = p.offset.length();
                float impact = 0.0f;
                if (dist < this.shockwaveRadius && dist > this.shockwaveRadius - this.shockwaveWidth) {
                    impact = 1.0f - (this.shockwaveRadius - dist) / this.shockwaveWidth;
                    impact = -impact;
                } else if (dist > this.shockwaveRadius && dist < this.shockwaveRadius + this.shockwaveWidth) {
                    impact = 1.0f - (dist - this.shockwaveRadius) / this.shockwaveWidth;
                }
                float speed = p.vel.length();
                float dot = Vector2f.dot((Vector2f)p.offset, (Vector2f)p.vel);
                float threshold = this.shockwaveSpeed * 0.5f;
                if (speed > threshold) {
                    impact *= threshold / speed;
                }
                if (dot < 0.0f) {
                    impact *= 0.2f;
                }
                Vector2f accel = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(p.offset));
                accel.scale((impact *= p.swImpact) * this.shockwaveAccel);
                p.vel.x += accel.x * amount;
                p.vel.y += accel.y * amount;
            }
        }
    }

    @Override
    public float getRenderRange() {
        float extra = 2000.0f;
        if (this.params != null) {
            extra = this.params.radius * 3.0f;
        }
        return this.entity.getRadius() + extra;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float b = alphaMult;
        this.sprite.setTexWidth(0.25f);
        this.sprite.setTexHeight(0.25f);
        this.sprite.setAdditiveBlend();
        for (ParticleData p : this.particles) {
            float size = p.size;
            size *= p.scale;
            Vector2f loc = new Vector2f(x + p.offset.x, y + p.offset.y);
            float a = 1.0f;
            a = 0.33f;
            this.sprite.setTexX((float)p.i * 0.25f);
            this.sprite.setTexY((float)p.j * 0.25f);
            this.sprite.setAngle(p.angle);
            this.sprite.setSize(size, size);
            this.sprite.setAlphaMult(b * a * p.getBrightness());
            this.sprite.setColor(p.color);
            this.sprite.renderAtCenter(loc.x, loc.y);
        }
    }

    public void applyDamageToFleets() {
        if (this.params.damage == null || this.params.damage == ExplosionFleetDamage.NONE) {
            return;
        }
        float shockwaveDist = 0.0f;
        for (ParticleData p : this.particles) {
            shockwaveDist = Math.max(shockwaveDist, p.offset.length());
        }
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            float dist;
            String id = fleet.getId();
            if (this.damagedAlready.contains(id) || !((dist = Misc.getDistance(fleet, this.entity)) < shockwaveDist)) continue;
            float damageMult = 1.0f - dist / this.params.radius;
            if (damageMult > 1.0f) {
                damageMult = 1.0f;
            }
            if (damageMult < 0.1f) {
                damageMult = 0.1f;
            }
            if (dist < this.entity.getRadius() + this.params.radius * 0.1f) {
                damageMult = 1.0f;
            }
            this.damagedAlready.add(id);
            this.applyDamageToFleet(fleet, damageMult);
        }
    }

    public void applyDamageToFleet(CampaignFleetAPI fleet, float damageMult) {
        float dist;
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.isEmpty()) {
            return;
        }
        float totalValue = 0.0f;
        for (FleetMemberAPI member : members) {
            totalValue += member.getStats().getSuppliesToRecover().getModifiedValue();
        }
        if (totalValue <= 0.0f) {
            return;
        }
        float damageFraction = 0.0f;
        switch (this.params.damage) {
            case NONE: {
                return;
            }
            case LOW: {
                damageFraction = 0.1f;
                break;
            }
            case MEDIUM: {
                damageFraction = 0.3f;
                break;
            }
            case HIGH: {
                damageFraction = 0.6f;
                break;
            }
            case EXTREME: {
                damageFraction = 0.9f;
            }
        }
        float shoveDir = Misc.getAngleInDegrees(this.entity.getLocation(), fleet.getLocation());
        fleet.addScript(new ShoveFleetScript(fleet, shoveDir, damageFraction *= damageMult));
        if (fleet.isInCurrentLocation() && (dist = Misc.getDistance(fleet, Global.getSector().getPlayerFleet())) < HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE) {
            float volumeMult = 0.5f + 0.5f * damageFraction;
            Global.getSoundPlayer().playSound("gate_explosion_fleet_impact", 1.0f, volumeMult, fleet.getLocation(), Misc.ZERO);
        }
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        for (FleetMemberAPI member : members) {
            float w = 1.0f;
            if (member.isFrigate()) {
                w *= 0.1f;
            }
            if (member.isDestroyer()) {
                w *= 0.2f;
            }
            if (member.isCruiser()) {
                w *= 0.5f;
            }
            picker.add(member, w);
        }
        int numStrikes = picker.getItems().size();
        int i = 0;
        while (i < numStrikes) {
            FleetMemberAPI member = (FleetMemberAPI)picker.pick();
            if (member == null) {
                return;
            }
            float crPerDep = member.getDeployCost();
            float suppliesPerDep = member.getStats().getSuppliesToRecover().getModifiedValue();
            if (suppliesPerDep <= 0.0f || crPerDep <= 0.0f) {
                return;
            }
            float suppliesPer100CR = suppliesPerDep * 1.0f / Math.max(0.01f, crPerDep);
            float strikeSupplies = (250.0f + suppliesPer100CR) * 0.5f * damageFraction;
            float strikeDamage = strikeSupplies / suppliesPer100CR * (0.75f + (float)Math.random() * 0.5f);
            float resistance = member.getStats().getDynamic().getValue("corona_resistance");
            if ((strikeDamage *= resistance) > HyperspaceTerrainPlugin.STORM_MAX_STRIKE_DAMAGE) {
                strikeDamage = HyperspaceTerrainPlugin.STORM_MAX_STRIKE_DAMAGE;
            }
            if (strikeDamage > 0.0f) {
                float currCR = member.getRepairTracker().getBaseCR();
                float crDamage = Math.min(currCR, strikeDamage);
                if (crDamage > 0.0f) {
                    member.getRepairTracker().applyCREvent(-crDamage, "explosion_" + this.entity.getId(), "Damaged by explosion");
                }
                float hitStrength = member.getStats().getArmorBonus().computeEffective(member.getHullSpec().getArmorRating());
                int numHits = (int)(strikeDamage / 0.1f);
                if (numHits < 1) {
                    numHits = 1;
                }
                int j = 0;
                while (j < numHits) {
                    member.getStatus().applyDamage(hitStrength);
                    ++j;
                }
                if (member.getStatus().getHullFraction() < 0.01f) {
                    member.getStatus().setHullFraction(0.01f);
                    picker.remove(member);
                } else {
                    float w = picker.getWeight(member);
                    picker.setWeight(picker.getItems().indexOf(member), w * 0.5f);
                }
            }
            ++i;
        }
        if (fleet.isPlayerFleet()) {
            Global.getSector().getCampaignUI().addMessage("Your fleet suffers damage from being caught in an explosion", Misc.getNegativeHighlightColor());
        }
    }

    public static enum ExplosionFleetDamage {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        EXTREME;

    }

    public static class ExplosionParams {
        public Color color;
        public ExplosionFleetDamage damage = ExplosionFleetDamage.NONE;
        public float radius;
        public float durationMult = 1.0f;
        public Vector2f loc;
        public LocationAPI where;

        public ExplosionParams(Color color, LocationAPI where, Vector2f loc, float radius, float durationMult) {
            this.color = color;
            this.where = where;
            this.loc = loc;
            this.radius = radius;
            this.durationMult = durationMult;
        }
    }

    public static class ParticleData {
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float scaleDelta = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float size;
        public float maxDur;
        public float elapsed;
        public float swImpact = 1.0f;
        public int i = Misc.random.nextInt(4);
        public int j = Misc.random.nextInt(4);
        public Color color;

        public ParticleData(Color color, float size, float maxDur, float endScale) {
            this.color = color;
            this.size = size;
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = maxDur;
            this.scaleDelta = (endScale - 1.0f) / maxDur;
            this.scale = 1.0f;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * 10.0f * (float)Math.random();
        }

        public void setVelocity(float direction, float minSpeed, float maxSpeed) {
            this.vel = Misc.getUnitVectorAtDegreeAngle(direction);
            this.vel.scale(minSpeed + (maxSpeed - minSpeed) * (float)Math.random());
        }

        public void setOffset(float direction, float minDist, float maxDist) {
            this.offset = Misc.getUnitVectorAtDegreeAngle(direction);
            this.offset.scale(minDist + (maxDist - minDist) * (float)Math.random());
        }

        public void advance(float amount) {
            this.scale += this.scaleDelta * amount;
            if (this.scale < 0.0f) {
                this.scale = 0.0f;
            }
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            this.angle += this.turnDir * amount;
            this.elapsed += amount;
        }

        public float getBrightness() {
            float b = 1.0f - this.elapsed / this.maxDur;
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            return b;
        }
    }
}

