/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

public abstract class BaseAbilityPlugin
implements AbilityPlugin,
EveryFrameScript {
    public static boolean PLAY_UI_SOUNDS_IN_WORLD_SOURCES = true;
    protected SectorEntityToken entity;
    protected String id;
    protected int disableFrames = 0;
    protected transient AbilitySpecAPI spec = null;
    private static Color defaultCooldownColor = new Color(0, 0, 0, 171);

    @Override
    public void init(String id, SectorEntityToken entity) {
        this.id = id;
        this.entity = entity;
        this.readResolve();
    }

    protected Object readResolve() {
        this.spec = Global.getSettings().getAbilitySpec(this.id);
        return this;
    }

    Object writeReplace() {
        return this;
    }

    public String getOnSoundUI() {
        return this.spec.getUIOn();
    }

    public String getOnSoundWorld() {
        return this.spec.getWorldOn();
    }

    public String getOffSoundUI() {
        return this.spec.getUIOff();
    }

    public String getOffSoundWorld() {
        return this.spec.getWorldOff();
    }

    public String getLoopSoundUI() {
        return this.spec.getUILoop();
    }

    public float getLoopSoundUIVolume() {
        return 1.0f;
    }

    public float getLoopSoundUIPitch() {
        return 1.0f;
    }

    public String getLoopSoundWorld() {
        return this.spec.getWorldLoop();
    }

    public float getLoopSoundWorldVolume() {
        return 1.0f;
    }

    public float getLoopSoundWorldPitch() {
        return 1.0f;
    }

    protected void interruptIncompatible() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        for (AbilityPlugin curr : fleet.getAbilities().values()) {
            if (curr == this || this.isCompatible(curr) || !curr.isActive()) continue;
            curr.deactivate();
        }
    }

    protected void disableIncompatible() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        for (AbilityPlugin curr : fleet.getAbilities().values()) {
            if (curr == this || this.isCompatible(curr)) continue;
            curr.forceDisable();
        }
    }

    public boolean isCompatible(AbilityPlugin other) {
        for (String tag : this.spec.getTags()) {
            if (!this.spec.isPositiveTag(tag) && !this.spec.isNegativeTag(tag)) continue;
            if (this.spec.isPositiveTag(tag) && other.getSpec().hasTag(tag)) {
                return false;
            }
            if (!other.getSpec().hasOppositeTag(tag)) continue;
            return false;
        }
        return true;
    }

    protected void addIncompatibleToTooltip(TooltipMakerAPI tooltip, String desc, String descShort, boolean expanded) {
        List<AbilityPlugin> list = this.getInterruptedList();
        if (list.isEmpty()) {
            return;
        }
        if (expanded) {
            String pre = desc;
            tooltip.addPara(pre, 10.0f);
            String str = "";
            for (AbilityPlugin curr : list) {
                str = String.valueOf(str) + "    " + curr.getSpec().getName() + "\n";
            }
            str = str.substring(0, str.length() - 1);
            Color c = Misc.getTooltipTitleAndLightHighlightColor();
            tooltip.addPara(str, c, 3.0f);
        } else {
            Color c = Misc.getGrayColor();
            tooltip.addPara(descShort, c, 10.0f);
        }
    }

    public List<AbilityPlugin> getInterruptedList() {
        ArrayList<AbilityPlugin> result = new ArrayList<AbilityPlugin>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        for (AbilityPlugin curr : fleet.getAbilities().values()) {
            if (curr == this || this instanceof BaseToggleAbility && curr instanceof BaseDurationAbility || this.isCompatible(curr)) continue;
            result.add(curr);
        }
        Collections.sort(result, new Comparator<AbilityPlugin>(){

            @Override
            public int compare(AbilityPlugin o1, AbilityPlugin o2) {
                return o1.getSpec().getSortOrder() - o2.getSpec().getSortOrder();
            }
        });
        return result;
    }

    public String getModId() {
        return String.valueOf(this.id) + "_ability_mod";
    }

    public CampaignFleetAPI getFleet() {
        if (this.entity instanceof CampaignFleetAPI) {
            return (CampaignFleetAPI)this.entity;
        }
        return null;
    }

    @Override
    public SectorEntityToken getEntity() {
        return this.entity;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void advance(float amount) {
        --this.disableFrames;
        if (this.disableFrames < 0) {
            this.disableFrames = 0;
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean showActiveIndicator() {
        return this.isActive();
    }

    @Override
    public boolean isUsable() {
        return !this.isOnCooldown() && this.disableFrames <= 0;
    }

    @Override
    public void forceDisable() {
        this.disableFrames = 2;
    }

    @Override
    public float getCooldownFraction() {
        return 1.0f;
    }

    @Override
    public boolean hasCustomButtonPressSounds() {
        return false;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public void pressButton() {
    }

    @Override
    public String getSpriteName() {
        return this.spec.getIconName();
    }

    @Override
    public void activate() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null || !fleet.isPlayerFleet()) {
            return;
        }
        Global.getSector().reportPlayerActivatedAbility(this, null);
    }

    @Override
    public void deactivate() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null || !fleet.isPlayerFleet()) {
            return;
        }
        Global.getSector().reportPlayerDeactivatedAbility(this, null);
    }

    @Override
    public Color getCooldownColor() {
        return defaultCooldownColor;
    }

    @Override
    public Color getProgressColor() {
        return this.entity.getFaction().getBrightUIColor();
    }

    @Override
    public Color getActiveColor() {
        return this.entity.getFaction().getBrightUIColor();
    }

    @Override
    public float getProgressFraction() {
        return 0.0f;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isActiveOrInProgress() {
        return this.isActive() || this.isInProgress();
    }

    @Override
    public boolean isInProgress() {
        return this.getProgressFraction() > 0.0f;
    }

    @Override
    public boolean showCooldownIndicator() {
        return this.getCooldownFraction() < 1.0f;
    }

    @Override
    public boolean showProgressIndicator() {
        return this.getProgressFraction() > 0.0f;
    }

    @Override
    public boolean isOnCooldown() {
        return this.getCooldownFraction() < 1.0f;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return false;
    }

    @Override
    public abstract void setCooldownLeft(float var1);

    @Override
    public abstract float getCooldownLeft();

    protected String getActivationText() {
        return Misc.ucFirst(this.spec.getName().toLowerCase());
    }

    protected String getDeactivationText() {
        return null;
    }

    @Override
    public void fleetJoinedBattle(BattleAPI battle) {
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
    }

    @Override
    public AbilitySpecAPI getSpec() {
        return this.spec;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return null;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
    }

    @Override
    public float getLevel() {
        return 0.0f;
    }
}

