/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantOfficerGeneratorPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import org.json.JSONException;
import org.json.JSONObject;

public class OrbitalStation
extends BaseIndustry
implements FleetEventListener {
    public static float DEFENSE_BONUS_BASE = 0.5f;
    public static float DEFENSE_BONUS_BATTLESTATION = 1.0f;
    public static float DEFENSE_BONUS_FORTRESS = 2.0f;
    public static float IMPROVE_STABILITY_BONUS = 1.0f;
    protected CampaignFleetAPI stationFleet = null;
    protected boolean usingExistingStation = false;
    protected SectorEntityToken stationEntity = null;

    @Override
    public void apply() {
        super.apply(false);
        int size = 3;
        boolean battlestation = this.getSpec().hasTag("battlestation");
        boolean starfortress = this.getSpec().hasTag("starfortress");
        if (battlestation) {
            size = 5;
        } else if (starfortress) {
            size = 7;
        }
        this.modifyStabilityWithBaseMod();
        this.applyIncomeAndUpkeep(size);
        this.demand("crew", size);
        this.demand("supplies", size);
        float bonus = DEFENSE_BONUS_BASE;
        if (battlestation) {
            bonus = DEFENSE_BONUS_BATTLESTATION;
        } else if (starfortress) {
            bonus = DEFENSE_BONUS_FORTRESS;
        }
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(), 1.0f + bonus, this.getNameForModifier());
        this.matchCommanderToAICore(this.aiCoreId);
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        } else {
            this.applyCRToStation();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        this.unmodifyStabilityWithBaseMod();
        this.matchCommanderToAICore(null);
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
    }

    protected void applyCRToStation() {
        if (this.stationFleet != null) {
            float cr = this.getCR();
            for (FleetMemberAPI member : this.stationFleet.getFleetData().getMembersListCopy()) {
                member.getRepairTracker().setCR(cr);
            }
            FleetInflater inflater = this.stationFleet.getInflater();
            if (inflater != null) {
                if (this.stationFleet.isInflated()) {
                    this.stationFleet.deflate();
                }
                inflater.setQuality(Misc.getShipQuality(this.market));
                if (inflater instanceof DefaultFleetInflater) {
                    DefaultFleetInflater dfi = (DefaultFleetInflater)inflater;
                    ((DefaultFleetInflaterParams)dfi.getParams()).allWeapons = true;
                }
            }
        }
    }

    protected float getCR() {
        float cr;
        float d;
        float q;
        float deficit = ((Integer)this.getMaxDeficit((String[])new String[]{"crew", "supplies"}).two).intValue();
        float demand = Math.max(this.getDemand("crew").getQuantity().getModifiedInt(), this.getDemand("supplies").getQuantity().getModifiedInt());
        if (deficit < 0.0f) {
            deficit = 0.0f;
        }
        if (demand < 1.0f) {
            demand = 1.0f;
            deficit = 0.0f;
        }
        if ((q = Misc.getShipQuality(this.market)) < 0.0f) {
            q = 0.0f;
        }
        if (q > 1.0f) {
            q = 1.0f;
        }
        if ((d = (demand - deficit) / demand) < 0.0f) {
            d = 0.0f;
        }
        if (d > 1.0f) {
            d = 1.0f;
        }
        if ((cr = 0.5f + 0.5f * Math.min(d, q)) > 1.0f) {
            cr = 1.0f;
        }
        return cr;
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            Color h = Misc.getHighlightColor();
            float opad = 10.0f;
            float cr = this.getCR();
            tooltip.addPara("Station combat readiness: %s", opad, h, Math.round(cr * 100.0f) + "%");
            this.addStabilityPostDemandSection(tooltip, hasDemand, mode);
            boolean battlestation = this.getSpec().hasTag("battlestation");
            boolean starfortress = this.getSpec().hasTag("starfortress");
            float bonus = DEFENSE_BONUS_BASE;
            if (battlestation) {
                bonus = DEFENSE_BONUS_BATTLESTATION;
            } else if (starfortress) {
                bonus = DEFENSE_BONUS_FORTRESS;
            }
            this.addGroundDefensesImpactSection(tooltip, bonus, "supplies");
        }
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    public CampaignFleetAPI getStationFleet() {
        return this.stationFleet;
    }

    public SectorEntityToken getStationEntity() {
        return this.stationEntity;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (Global.getSector().getEconomy().isSimMode()) {
            return;
        }
        if (this.stationEntity == null) {
            this.spawnStation();
        }
        if (this.stationFleet != null) {
            this.stationFleet.setAI(null);
            if (this.stationFleet.getOrbit() == null && this.stationEntity != null) {
                this.stationFleet.setCircularOrbit(this.stationEntity, 0.0f, 0.0f, 100.0f);
            }
        }
    }

    @Override
    protected void buildingFinished() {
        super.buildingFinished();
        if (this.stationEntity != null && this.stationFleet != null) {
            this.matchStationAndCommanderToCurrentIndustry();
        } else {
            this.spawnStation();
        }
    }

    @Override
    public void notifyBeingRemoved(MarketAPI.MarketInteractionMode mode, boolean forUpgrade) {
        super.notifyBeingRemoved(mode, forUpgrade);
        if (!forUpgrade) {
            this.removeStationEntityAndFleetIfNeeded();
        }
    }

    @Override
    protected void upgradeFinished(Industry previous) {
        super.upgradeFinished(previous);
        if (previous instanceof OrbitalStation) {
            OrbitalStation prev = (OrbitalStation)previous;
            this.stationEntity = prev.stationEntity;
            this.stationFleet = prev.stationFleet;
            this.usingExistingStation = prev.usingExistingStation;
            if (this.stationFleet != null) {
                this.stationFleet.removeEventListener(prev);
                this.stationFleet.addEventListener(this);
            }
            if (this.stationEntity != null && this.stationFleet != null) {
                this.matchStationAndCommanderToCurrentIndustry();
            } else {
                this.spawnStation();
            }
        }
    }

    protected void removeStationEntityAndFleetIfNeeded() {
        if (this.stationEntity != null) {
            this.stationEntity.getMemoryWithoutUpdate().unset("$stationFleet");
            this.stationEntity.getMemoryWithoutUpdate().unset("$stationBaseFleet");
            this.stationEntity.getContainingLocation().removeEntity(this.stationFleet);
            if (this.stationEntity.getContainingLocation() != null && !this.usingExistingStation) {
                this.stationEntity.getContainingLocation().removeEntity(this.stationEntity);
                this.market.getConnectedEntities().remove(this.stationEntity);
            } else if (this.stationEntity.hasTag("use_station_visual")) {
                ((CustomCampaignEntityAPI)this.stationEntity).setFleetForVisual(null);
                float origRadius = ((CustomCampaignEntityAPI)this.stationEntity).getCustomEntitySpec().getDefaultRadius();
                ((CustomCampaignEntityAPI)this.stationEntity).setRadius(origRadius);
            }
            if (this.stationFleet != null) {
                this.stationFleet.getMemoryWithoutUpdate().unset("$stationMarket");
                this.stationFleet.removeEventListener(this);
            }
            this.stationEntity = null;
            this.stationFleet = null;
        }
    }

    @Override
    public void notifyColonyRenamed() {
        super.notifyColonyRenamed();
        if (!this.usingExistingStation && this.stationFleet != null && this.stationEntity != null) {
            this.stationFleet.setName(String.valueOf(this.market.getName()) + " Station");
            this.stationEntity.setName(String.valueOf(this.market.getName()) + " Station");
        }
    }

    protected void spawnStation() {
        FleetParamsV3 fParams = new FleetParamsV3(null, null, this.market.getFactionId(), Float.valueOf(1.0f), "patrolSmall", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        fParams.allWeapons = true;
        this.removeStationEntityAndFleetIfNeeded();
        this.stationFleet = FleetFactoryV3.createFleet(fParams);
        this.stationFleet.setNoFactionInName(true);
        this.stationFleet.setStationMode(true);
        this.stationFleet.clearAbilities();
        this.stationFleet.addAbility("transponder");
        this.stationFleet.getAbility("transponder").activate();
        this.stationFleet.getDetectedRangeMod().modifyFlat("gen", 10000.0f);
        this.stationFleet.setAI(null);
        this.stationFleet.addEventListener(this);
        this.ensureStationEntityIsSetOrCreated();
        if (this.stationEntity instanceof CustomCampaignEntityAPI && (!this.usingExistingStation || this.stationEntity.hasTag("use_station_visual"))) {
            ((CustomCampaignEntityAPI)this.stationEntity).setFleetForVisual(this.stationFleet);
        }
        this.stationFleet.setCircularOrbit(this.stationEntity, 0.0f, 0.0f, 100.0f);
        this.stationFleet.getMemoryWithoutUpdate().set("$stationMarket", this.market);
        this.stationFleet.setHidden(true);
        this.matchStationAndCommanderToCurrentIndustry();
    }

    protected void ensureStationEntityIsSetOrCreated() {
        if (this.stationEntity == null) {
            for (SectorEntityToken entity : this.market.getConnectedEntities()) {
                if (!entity.hasTag("station") || entity.hasTag("NO_ORBITAL_STATION")) continue;
                this.stationEntity = entity;
                this.usingExistingStation = true;
                break;
            }
        }
        if (this.stationEntity == null) {
            this.stationEntity = this.market.getContainingLocation().addCustomEntity(null, String.valueOf(this.market.getName()) + " Station", "station_built_from_industry", this.market.getFactionId());
            SectorEntityToken primary = this.market.getPrimaryEntity();
            float orbitRadius = primary.getRadius() + 150.0f;
            this.stationEntity.setCircularOrbitWithSpin(primary, (float)Math.random() * 360.0f, orbitRadius, orbitRadius / 10.0f, 5.0f, 5.0f);
            this.market.getConnectedEntities().add(this.stationEntity);
            this.stationEntity.setMarket(this.market);
        }
    }

    protected void matchStationAndCommanderToCurrentIndustry() {
        boolean skeletonMode;
        if (this.stationFleet == null) {
            return;
        }
        this.stationFleet.getFleetData().clear();
        String fleetName = null;
        String variantId = null;
        float radius = 60.0f;
        try {
            JSONObject json = new JSONObject(this.getSpec().getData());
            variantId = json.getString("variant");
            radius = (float)json.getDouble("radius");
            fleetName = json.getString("fleetName");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (this.stationEntity != null) {
            fleetName = this.stationEntity.getName();
        }
        this.stationFleet.setName(fleetName);
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variantId);
        String name = fleetName;
        member.setShipName(name);
        this.stationFleet.getFleetData().addFleetMember(member);
        this.applyCRToStation();
        if (!this.usingExistingStation && this.stationEntity instanceof CustomCampaignEntityAPI) {
            ((CustomCampaignEntityAPI)this.stationEntity).setRadius(radius);
        } else if (this.stationEntity.hasTag("use_station_visual")) {
            ((CustomCampaignEntityAPI)this.stationEntity).setRadius(radius);
        }
        boolean bl = skeletonMode = !this.isFunctional();
        if (skeletonMode) {
            this.stationEntity.getMemoryWithoutUpdate().unset("$stationFleet");
            this.stationEntity.getMemoryWithoutUpdate().set("$stationBaseFleet", this.stationFleet);
            this.stationEntity.getContainingLocation().removeEntity(this.stationFleet);
            int i = 1;
            while (i < member.getStatus().getNumStatuses()) {
                String slotId;
                ShipVariantAPI variant = member.getVariant();
                if (i > 0 && !(variant = variant.getModuleVariant(slotId = member.getVariant().getModuleSlots().get(i - 1))).hasHullMod("vastbulk")) {
                    member.getStatus().setDetached(i, true);
                    member.getStatus().setPermaDetached(i, true);
                    member.getStatus().setHullFraction(i, 0.0f);
                }
                ++i;
            }
        } else {
            this.stationEntity.getMemoryWithoutUpdate().unset("$stationBaseFleet");
            this.stationEntity.getMemoryWithoutUpdate().set("$stationFleet", this.stationFleet);
            this.stationEntity.getContainingLocation().removeEntity(this.stationFleet);
            this.stationFleet.setExpired(false);
            this.stationEntity.getContainingLocation().addEntity(this.stationFleet);
        }
    }

    protected int getHumanCommanderLevel() {
        boolean battlestation = this.getSpec().hasTag("battlestation");
        boolean starfortress = this.getSpec().hasTag("starfortress");
        if (starfortress) {
            return Global.getSettings().getInt("tier3StationOfficerLevel");
        }
        if (battlestation) {
            return Global.getSettings().getInt("tier2StationOfficerLevel");
        }
        return Global.getSettings().getInt("tier1StationOfficerLevel");
    }

    protected void matchCommanderToAICore(String aiCore) {
        if (this.stationFleet == null) {
            return;
        }
        PersonAPI commander = null;
        if ("alpha_core".equals(aiCore)) {
            AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("alpha_core");
            commander = plugin.createPerson("alpha_core", "remnant", null);
            if (this.stationFleet.getFlagship() != null) {
                RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(this.stationFleet.getFlagship());
            }
        } else if (this.stationFleet.getFlagship() != null) {
            int level = this.getHumanCommanderLevel();
            PersonAPI current = this.stationFleet.getFlagship().getCaptain();
            if (level > 0) {
                if (current.isAICore() || current.getStats().getLevel() != level) {
                    commander = OfficerManagerEvent.createOfficer(Global.getSector().getFaction(this.market.getFactionId()), level, true);
                }
            } else if (this.stationFleet.getFlagship() == null || this.stationFleet.getFlagship().getCaptain() == null || !this.stationFleet.getFlagship().getCaptain().isDefault()) {
                commander = Global.getFactory().createPerson();
            }
        }
        if (commander != null && this.stationFleet.getFlagship() != null) {
            this.stationFleet.getFlagship().setCaptain(commander);
            this.stationFleet.getFlagship().setFlagship(false);
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    protected void disruptionFinished() {
        super.disruptionFinished();
        this.matchStationAndCommanderToCurrentIndustry();
    }

    @Override
    protected void notifyDisrupted() {
        super.notifyDisrupted();
        this.matchStationAndCommanderToCurrentIndustry();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (fleet != this.stationFleet) {
            return;
        }
        OrbitalStation.disrupt(this);
        if (this.stationFleet.getMembersWithFightersCopy().isEmpty()) {
            this.matchStationAndCommanderToCurrentIndustry();
        }
        this.stationFleet.setAbortDespawn(true);
    }

    public static void disrupt(Industry station) {
        station.setDisrupted(station.getSpec().getBuildTime() * 0.5f, true);
    }

    @Override
    public boolean isAvailableToBuild() {
        boolean canBuild = false;
        for (Industry ind : this.market.getIndustries()) {
            if (ind == this || !ind.isFunctional() || !ind.getSpec().hasTag("spaceport")) continue;
            canBuild = true;
            break;
        }
        return canBuild;
    }

    @Override
    public String getUnavailableReason() {
        return "Requires a functional spaceport";
    }

    @Override
    protected int getBaseStabilityMod() {
        boolean battlestation = this.getSpec().hasTag("battlestation");
        boolean starfortress = this.getSpec().hasTag("starfortress");
        int stabilityMod = 1;
        if (battlestation) {
            stabilityMod = 2;
        } else if (starfortress) {
            stabilityMod = 3;
        }
        return stabilityMod;
    }

    @Override
    protected Pair<String, Integer> getStabilityAffectingDeficit() {
        return this.getMaxDeficit("supplies", "crew");
    }

    @Override
    protected void applyAlphaCoreModifiers() {
    }

    @Override
    protected void applyNoAICoreModifiers() {
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases station combat effectiveness.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases station combat effectiveness.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStability().modifyFlat("orbital_station_improve", IMPROVE_STABILITY_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStability().unmodifyFlat("orbital_station_improve");
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Stability increased by %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        } else {
            info.addPara("Increases stability by %s.", 0.0f, highlight, "" + (int)IMPROVE_STABILITY_BONUS);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    protected boolean isMiltiarized() {
        boolean battlestation = this.getSpec().hasTag("battlestation");
        boolean starfortress = this.getSpec().hasTag("starfortress");
        return battlestation || starfortress;
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustCommodityDangerLevel(String commodityId, MarketCMD.RaidDangerLevel level) {
        if (!this.isMiltiarized()) {
            return level;
        }
        return level.next();
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustItemDangerLevel(String itemId, String data, MarketCMD.RaidDangerLevel level) {
        if (!this.isMiltiarized()) {
            return level;
        }
        return level.next();
    }
}

