/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class LuddicChurchStandardActivityCause
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.3f;

    public LuddicChurchStandardActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Negotiating with the Luddic Church about controlling the immigration of the faithful to your colonies is likely to get this harassment to stop. If left unchecked, this low-grade conflict will eventually come to a head and is likely to be resolved one way or another.", 0.0f, Misc.getHighlightColor(), "Negotiating");
                FactionAPI f = Global.getSector().getFaction("luddic_church");
                tooltip.addPara("Event progress value is based on the number and size of colonies with the \"Luddic Majority\" condition.", opad, f.getBaseUIColor(), "Luddic Majority");
            }
        };
    }

    @Override
    public int getProgress() {
        if (LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            return 0;
        }
        if (LuddicChurchHostileActivityFactor.isMadeDeal()) {
            return 0;
        }
        int score = 0;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            if (!market.hasCondition("luddic_majority")) continue;
            int size = market.getSize();
            score += size;
        }
        int progress = score;
        return progress;
    }

    @Override
    public String getDesc() {
        return "Colonies with a Luddic Majority";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (MarketAPI market : Misc.getMarketsInLocation(system, "player")) {
            if (!market.hasCondition("luddic_majority")) continue;
            total += (float)market.getSize();
        }
        float f = total / 6.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f * MAX_MAG;
    }
}

