/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;

public class StandardLuddicPathActivityCause2
extends BaseHostileActivityCause2 {
    public StandardLuddicPathActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Use of advanced technology and AI cores attracts the attention of Pathers.", 0.0f, Misc.getHighlightColor(), "advanced technology", "AI cores");
                LinkedHashSet<LuddicPathBaseIntel> seen = new LinkedHashSet<LuddicPathBaseIntel>();
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    LuddicPathCellsIntel cells;
                    LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(market);
                    if (base == null || seen.contains(base) || (cells = LuddicPathCellsIntel.getCellsForMarket(market)) == null || cells.isSleeper()) continue;
                    seen.add(base);
                    Color h = Misc.getHighlightColor();
                    String system = "";
                    if (base.isPlayerVisible()) {
                        system = " located in the " + base.getSystem().getNameWithLowercaseTypeShort();
                    }
                    tooltip.addPara("Active Pather cells on some of your colonies are being supported by a Pather base" + system + ". %s " + "will reduce the level of Pather fleet actvity.", opad, h, "Dealing with this base");
                    break;
                }
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    LuddicPathCellsIntel cells = LuddicPathCellsIntel.getCellsForMarket(market);
                    if (cells == null || !(cells.getSleeperTimeout() > 0.0f)) continue;
                    tooltip.addPara("Pather cells on some of your colonies have been disrupted, reducing the Pather interest contribution from these colonies to event progress.", opad, Misc.getPositiveHighlightColor(), "disrupted");
                    break;
                }
            }
        };
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0 || HA_CMD.playerHasPatherAgreement();
    }

    @Override
    public String getProgressStr() {
        if (HA_CMD.playerHasPatherAgreement()) {
            return "---";
        }
        return super.getProgressStr();
    }

    @Override
    public Color getProgressColor(BaseEventIntel intel) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return Misc.getPositiveHighlightColor();
        }
        return super.getProgressColor(intel);
    }

    @Override
    public int getProgress() {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0;
        }
        if (LuddicPathHostileActivityFactor.isPlayerDefeatedPatherExpedition()) {
            return 0;
        }
        int progress = Math.round(this.getTotalPatherInterest());
        float unit = Global.getSettings().getFloat("patherProgressUnit");
        float mult = Global.getSettings().getFloat("patherProgressMult");
        int rem = progress;
        float adjusted = 0.0f;
        while ((float)rem > unit) {
            adjusted += unit;
            rem = (int)((float)rem - unit);
            rem = (int)((float)rem * mult);
        }
        int reduced = Math.round(adjusted += (float)rem);
        if (progress > 0 && reduced < 1) {
            reduced = 1;
        }
        progress = reduced;
        return progress;
    }

    @Override
    public String getDesc() {
        return "Technology and AI core use";
    }

    public float getTotalPatherInterest() {
        float total = 0.0f;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float noCells = Global.getSettings().getFloat("patherProgressMultNoCells");
            float sleeperCells = Global.getSettings().getFloat("patherProgressMultSleeperCells");
            float activeCells = Global.getSettings().getFloat("patherProgressMultActiveCells");
            total += StandardLuddicPathActivityCause2.getPatherInterest(system, noCells, sleeperCells, activeCells);
        }
        return total;
    }

    public static float getPatherInterest(StarSystemAPI system, float multIfNoCells, float multIfSleeper, float multIfActive) {
        return StandardLuddicPathActivityCause2.getPatherInterest(system, multIfNoCells, multIfSleeper, multIfActive, false);
    }

    public static float getPatherInterest(StarSystemAPI system, float multIfNoCells, float multIfSleeper, float multIfActive, boolean countCellsOnly) {
        float total = 0.0f;
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        for (MarketAPI market : markets) {
            float mult = 1.0f;
            LuddicPathCellsIntel intel = LuddicPathCellsIntel.getCellsForMarket(market);
            mult = intel == null ? multIfNoCells : (intel.isSleeper() ? multIfSleeper : multIfActive);
            float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            if (countCellsOnly) {
                interest = 1.0f;
            }
            total += interest * mult;
        }
        return total;
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0.0f;
        }
        if (LuddicPathHostileActivityFactor.isPlayerDefeatedPatherExpedition()) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float perSleeperBase = Global.getSettings().getFloat("luddicPathSleeperCellsBase");
        float perSleeperSize = Global.getSettings().getFloat("luddicPathSleeperCellsPerSize");
        float perActiveBase = Global.getSettings().getFloat("luddicPathActiveCellsBase");
        float perActiveSize = Global.getSettings().getFloat("luddicPathActiveCellsPerSize");
        float perPointOfInterest = Global.getSettings().getFloat("luddicPathPerPointOfInterest");
        float max = 0.0f;
        for (MarketAPI market : markets) {
            LuddicPathCellsIntel intel = LuddicPathCellsIntel.getCellsForMarket(market);
            if (intel == null) continue;
            float curr = 0.0f;
            curr = intel.isSleeper() ? (curr += perSleeperBase + (float)market.getSize() * perSleeperSize) : (curr += perActiveBase + (float)market.getSize() * perActiveSize);
            float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            curr += interest * perPointOfInterest;
            if (!(curr >= max)) continue;
            max = curr;
        }
        max = (float)Math.round(max * 100.0f) / 100.0f;
        return max;
    }
}

