/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntelV2;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DistressCallIntel
extends BreadcrumbIntelV2 {
    protected StarSystemAPI system;

    public DistressCallIntel(StarSystemAPI system) {
        super(system.getCenter());
        this.system = system;
        Global.getSector().addScript(this);
        this.setIconId("distress_call");
        this.setSound("ui_intel_distress_call");
        this.setDuration(60.0f);
        this.setTitle("Distress Call");
        this.setText("You receive a distress call from the nearby " + system.getNameWithLowercaseType() + ". " + "There's no additional information, but that's not surprising - " + "a typical fleet doesn't carry the equipment to broadcast a full-fledged data " + "stream into hyperspace.");
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.system == Global.getSector().getCurrentLocation()) {
            this.endAfterDelay();
        }
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        if (this.system != null) {
            this.bullet(info);
            info.addPara("Originating in the " + this.system.getNameWithLowercaseType(), tc, initPad);
            this.unindent(info);
        }
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.text, opad);
        if (this.isEnding()) {
            info.addPara("You've investigated the system this distress call came from.", opad);
        }
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public String getSortString() {
        return super.getSortString();
    }

    @Override
    public String getName() {
        if (this.isEnding()) {
            return String.valueOf(this.title) + " - Investigated";
        }
        return this.title;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        return super.shouldRemoveIntel();
    }
}

