/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.CommodityIconCounts;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseMissionHub;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public abstract class HubMissionWithSearch
extends HubMissionWithTriggers {
    public static float DEFAULT_MISSION_ARC = 60.0f;
    public static float DEFAULT_MISSION_ARC_BONUS = 90.0f;
    public static float DEFAULT_MISSION_MARKET_ARC = 150.0f;
    public static float DEFAULT_MISSION_MARKET_ARC_BONUS = 210.0f;
    protected transient SearchData search = new SearchData();
    public static float INNER_SECTOR_PORTION_OF_HEIGHT = 0.7f;
    public static float NON_FRINGE_PORTION_OF_HEIGHT = 0.7f;
    protected transient boolean makeSystemPreferencesMoreImportant = false;

    public boolean matchesSetMissionAngle(Vector2f other, float allowedArc, float allowedArcBonusIfClose) {
        Vector2f playerLoc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        PersonAPI person = this.getPerson();
        MarketAPI market = null;
        if (person != null) {
            market = person.getMarket();
        }
        float missionAngle = BaseMissionHub.getMissionAngle(person, market);
        float angleToOther = Misc.getAngleInDegrees(playerLoc, other);
        float distToOther = Misc.getDistance(playerLoc, other);
        float angleDiff = Misc.getAngleDiff(missionAngle, angleToOther);
        float maxAllowedAngleDiff = allowedArc / 2.0f;
        float thresholdDistForBonusAngle = 5000.0f;
        if (distToOther < thresholdDistForBonusAngle) {
            float f = 1.0f - distToOther / thresholdDistForBonusAngle;
            maxAllowedAngleDiff += f * allowedArcBonusIfClose / 2.0f;
        }
        return angleDiff <= maxAllowedAngleDiff;
    }

    public static boolean matchesReq(GenericRequirement req, Object param) {
        if (req instanceof StarSystemRequirement) {
            return ((StarSystemRequirement)req).systemMatchesRequirement((StarSystemAPI)param);
        }
        if (req instanceof PlanetRequirement) {
            return ((PlanetRequirement)req).planetMatchesRequirement((PlanetAPI)param);
        }
        if (req instanceof EntityRequirement) {
            return ((EntityRequirement)req).entityMatchesRequirement((SectorEntityToken)param);
        }
        if (req instanceof MarketRequirement) {
            if (((MarketAPI)param).isInvalidMissionTarget()) {
                return false;
            }
            return ((MarketRequirement)req).marketMatchesRequirement((MarketAPI)param);
        }
        if (req instanceof CommodityRequirement) {
            return ((CommodityRequirement)req).commodityMatchesRequirement((CommodityOnMarketAPI)param);
        }
        if (req instanceof TerrainRequirement) {
            return ((TerrainRequirement)req).terrainMatchesRequirement((CampaignTerrainAPI)param);
        }
        return false;
    }

    public SearchData getSearch() {
        return this.search;
    }

    public void resetSearch() {
        this.search = new SearchData();
    }

    public void requireSystemInterestingAndNotCore() {
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_core");
        this.preferSystemTags(ReqMode.ANY, "theme_interesting", "theme_interesting_minor");
    }

    public void requireSystemInterestingAndNotUnsafeOrCore() {
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core");
        this.preferSystemTags(ReqMode.ANY, "theme_interesting", "theme_interesting_minor");
    }

    public void preferSystemInteresting() {
        this.preferSystemTags(ReqMode.ANY, "theme_interesting", "theme_interesting_minor");
    }

    public void preferSystemInDirectionOfOtherMissions() {
        this.search.systemPrefs.add(new SystemInDirectionOfOtherMissionsReq(this, 1.0f));
    }

    public void requireSystemInDirection(float dir, float arc) {
        this.search.systemReqs.add(new SystemInDirection(this, dir, arc));
    }

    public void preferSystemInDirection(float dir, float arc) {
        this.search.systemPrefs.add(new SystemInDirection(this, dir, arc));
    }

    public void requireSystemInDirectionFrom(Vector2f from, float dir, float arc) {
        this.search.systemReqs.add(new SystemInDirectionFrom(from, dir, arc));
    }

    public void preferSystemInDirectionFrom(Vector2f from, float dir, float arc) {
        this.search.systemPrefs.add(new SystemInDirectionFrom(from, dir, arc));
    }

    public void preferPlanetInDirectionOfOtherMissions() {
        this.search.planetPrefs.add(new PlanetInDirectionOfOtherMissionsReq(this, 1.0f));
    }

    public void preferEntityInDirectionOfOtherMissions() {
        this.search.entityPrefs.add(new EntityInDirectionOfOtherMissionsReq(this, 1.0f));
    }

    public void preferTerrainInDirectionOfOtherMissions() {
        this.search.terrainPrefs.add(new TerrainInDirectionOfOtherMissionsReq(this, 1.0f));
    }

    public void preferMarketInDirectionOfOtherMissions() {
        this.search.marketPrefs.add(new MarketInDirectionOfOtherMissionsReq(this, 1.0f));
    }

    public void requireSystemTags(ReqMode mode, String ... tags) {
        this.search.systemReqs.add(new RequiredSystemTags(mode, tags));
    }

    public void preferSystemTags(ReqMode mode, String ... tags) {
        this.search.systemPrefs.add(new RequiredSystemTags(mode, tags));
    }

    public void requireSystemHasBase(String factionId) {
        this.search.systemReqs.add(new SystemHasBaseReq(factionId));
    }

    public void preferSystemHasBase(String factionId) {
        this.search.systemPrefs.add(new SystemHasBaseReq(factionId));
    }

    public void requireSystemHasColony(String factionId, int minSize) {
        this.search.systemReqs.add(new SystemHasColonyReq(factionId, minSize));
    }

    public void preferSystemHasColony(String factionId, int minSize) {
        this.search.systemPrefs.add(new SystemHasColonyReq(factionId, minSize));
    }

    public void requireSystemHasAtLeastNumJumpPoints(int min) {
        this.search.systemReqs.add(new SystemHasAtLeastJumpPointsReq(min));
    }

    public void preferSystemHasAtLeastNumJumpPoints(int min) {
        this.search.systemPrefs.add(new SystemHasAtLeastJumpPointsReq(min));
    }

    public void requireSystemUnexplored() {
        this.search.systemReqs.add(new StarSystemUnexploredReq());
    }

    public void preferSystemUnexplored() {
        this.search.systemPrefs.add(new StarSystemUnexploredReq());
        this.preferSystemNotEnteredByPlayerFor(365.0f);
    }

    public void requireSystemNotEnteredByPlayerFor(float days) {
        this.search.systemReqs.add(new StarSystemDaysSincePlayerVisitReq(days));
    }

    public void preferSystemNotEnteredByPlayerFor(float days) {
        this.search.systemPrefs.add(new StarSystemDaysSincePlayerVisitReq(days));
    }

    public void requireSystemExplored() {
        this.search.systemReqs.add(new StarSystemUnexploredReq(true));
    }

    public void preferSystemExplored() {
        this.search.systemPrefs.add(new StarSystemUnexploredReq(true));
    }

    public void requireSystemHasNumPlanets(int num) {
        this.search.systemReqs.add(new StarSystemHasNumPlanetsReq(num));
    }

    public void preferSystemHasNumPlanets(int num) {
        this.search.systemPrefs.add(new StarSystemHasNumPlanetsReq(num));
    }

    public void requireSystemHasNumTerrain(int num) {
        this.search.systemReqs.add(new StarSystemHasNumTerrainReq(num));
    }

    public void preferSystemHasNumTerrain(int num) {
        this.search.systemPrefs.add(new StarSystemHasNumTerrainReq(num));
    }

    public void requireSystemHasNumPlanetsAndTerrain(int num) {
        this.search.systemReqs.add(new StarSystemHasNumPlanetsAndTerrainReq(num));
    }

    public void preferSystemHasNumPlanetsAndTerrain(int num) {
        this.search.systemPrefs.add(new StarSystemHasNumTerrainReq(num));
    }

    public void requireSystemIsDense() {
        this.requireSystemHasNumPlanets(3);
        this.requireSystemHasNumTerrain(3);
        this.requireSystemHasNumPlanetsAndTerrain(10);
    }

    public void preferSystemIsDense() {
        this.preferSystemHasNumPlanets(3);
        this.preferSystemHasNumTerrain(3);
        this.preferSystemHasNumPlanetsAndTerrain(10);
    }

    public void requireSystemBlackHole() {
        this.search.systemReqs.add(new SystemIsBlackHoleReq());
    }

    public void requireSystemNebula() {
        this.search.systemReqs.add(new SystemIsNebulaReq());
    }

    public void requireSystemHasPulsar() {
        this.search.systemReqs.add(new SystemHasPulsarReq());
    }

    public void preferSystemBlackHole() {
        this.search.systemPrefs.add(new SystemIsBlackHoleReq());
    }

    public void preferSystemNebula() {
        this.search.systemPrefs.add(new SystemIsNebulaReq());
    }

    public void preferSystemHasPulsar() {
        this.search.systemPrefs.add(new SystemHasPulsarReq());
    }

    public void requireSystemBlackHoleOrPulsarOrNebula() {
        this.search.systemReqs.add(new MultipleStarSystemRequirements(ReqMode.ANY, new SystemIsBlackHoleReq(), new SystemHasPulsarReq(), new SystemIsNebulaReq()));
    }

    public void preferSystemBlackHoleOrPulsarOrNebula() {
        this.search.systemPrefs.add(new MultipleStarSystemRequirements(ReqMode.ANY, new SystemIsBlackHoleReq(), new SystemHasPulsarReq(), new SystemIsNebulaReq()));
    }

    public void requireSystemBlackHoleOrNebula() {
        this.search.systemReqs.add(new MultipleStarSystemRequirements(ReqMode.ANY, new SystemIsBlackHoleReq(), new SystemIsNebulaReq()));
    }

    public void preferSystemBlackHoleOrNebula() {
        this.search.systemPrefs.add(new MultipleStarSystemRequirements(ReqMode.ANY, new SystemIsBlackHoleReq(), new SystemIsNebulaReq()));
    }

    public void requireSystemNotBlackHole() {
        this.search.systemReqs.add(new SystemIsBlackHoleReq(true));
    }

    public void requireSystemNotNebula() {
        this.search.systemReqs.add(new SystemIsNebulaReq(true));
    }

    public void requireSystemNotHasPulsar() {
        this.search.systemReqs.add(new SystemHasPulsarReq(true));
    }

    public void requireSystemNotAlreadyUsedForStory() {
        this.requireSystemTags(ReqMode.NOT_ANY, "system_already_used_for_story");
    }

    public void setSystemWasUsedForStory(Object stage, StarSystemAPI system) {
        this.beginStageTrigger(stage);
        this.triggerAddTagAfterDelay(0.0f, system, "system_already_used_for_story");
        this.endTrigger();
    }

    public void preferSystemNotBlackHole() {
        this.search.systemPrefs.add(new SystemIsBlackHoleReq(true));
    }

    public void preferSystemNotNebula() {
        this.search.systemPrefs.add(new SystemIsNebulaReq(true));
    }

    public void preferSystemNotPulsar() {
        this.search.systemPrefs.add(new SystemHasPulsarReq(true));
    }

    public void requireSystemHasSafeStars() {
        this.requireSystemNotBlackHole();
        this.requireSystemNotHasPulsar();
    }

    public void requireSystemInInnerSector() {
        this.search.systemReqs.add(new SystemInInnerSectorReq());
    }

    public void preferSystemInInnerSector() {
        this.search.systemPrefs.add(new SystemInInnerSectorReq());
    }

    public void requireSystemOnFringeOfSector() {
        this.search.systemReqs.add(new SystemOnFringeOfSectorReq());
    }

    public void preferSystemOnFringeOfSector() {
        this.search.systemPrefs.add(new SystemOnFringeOfSectorReq());
    }

    public void requireSystemWithinRangeOf(Vector2f location, float rangeLY) {
        this.search.systemReqs.add(new SystemWithinRangeReq(location, 0.0f, rangeLY));
    }

    public void preferSystemWithinRangeOf(Vector2f location, float rangeLY) {
        this.search.systemPrefs.add(new SystemWithinRangeReq(location, 0.0f, rangeLY));
    }

    public void requireSystemOutsideRangeOf(Vector2f location, float rangeLY) {
        this.search.systemReqs.add(new SystemWithinRangeReq(location, rangeLY, 1000000.0f));
    }

    public void preferSystemOutsideRangeOf(Vector2f location, float rangeLY) {
        this.search.systemPrefs.add(new SystemWithinRangeReq(location, rangeLY, 1000000.0f));
    }

    public void requireSystemWithinRangeOf(Vector2f location, float minRangeLY, float maxRangeLY) {
        this.search.systemReqs.add(new SystemWithinRangeReq(location, minRangeLY, maxRangeLY));
    }

    public void preferSystemWithinRangeOf(Vector2f location, float minRangeLY, float maxRangeLY) {
        this.search.systemPrefs.add(new SystemWithinRangeReq(location, minRangeLY, maxRangeLY));
    }

    public void requirePlanetNotStar() {
        this.requirePlanetTags(ReqMode.NOT_ANY, "star");
    }

    public void requirePlanetIsStar() {
        this.requirePlanetTags(ReqMode.ALL, "star");
    }

    public void requirePlanetNotGasGiant() {
        this.search.planetReqs.add(new PlanetIsGasGiantReq(true));
    }

    public void preferPlanetNonGasGiant() {
        this.search.planetPrefs.add(new PlanetIsGasGiantReq(true));
    }

    public void requirePlanetNotNearJumpPoint(float minDist) {
        this.search.planetReqs.add(new PlanetOrbitIsNotNearJumpPoint(minDist));
    }

    public void preferPlanetNotNearJumpPoint(float minDist) {
        this.search.planetPrefs.add(new PlanetOrbitIsNotNearJumpPoint(minDist));
    }

    public void requirePlanetIsGasGiant() {
        this.search.planetReqs.add(new PlanetIsGasGiantReq());
    }

    public void preferPlanetIsGasGiant() {
        this.search.planetPrefs.add(new PlanetIsGasGiantReq());
    }

    public void requirePlanetPopulated() {
        this.search.planetReqs.add(new PlanetIsPopulatedReq());
    }

    public void preferPlanetPopulated() {
        this.search.planetPrefs.add(new PlanetIsPopulatedReq());
    }

    public void requirePlanetUnpopulated() {
        this.search.planetReqs.add(new PlanetIsPopulatedReq(true));
    }

    public void preferPlanetUnpopulated() {
        this.search.planetPrefs.add(new PlanetIsPopulatedReq(true));
    }

    public void requirePlanetTags(ReqMode mode, String ... tags) {
        this.search.planetReqs.add(new RequiredPlanetTags(mode, tags));
    }

    public void preferPlanetTags(ReqMode mode, String ... tags) {
        this.search.planetPrefs.add(new RequiredPlanetTags(mode, tags));
    }

    public void requirePlanetConditions(ReqMode mode, String ... tags) {
        this.search.planetReqs.add(new RequiredPlanetConditions(mode, tags));
    }

    public void preferPlanetConditions(ReqMode mode, String ... conditions) {
        this.search.planetPrefs.add(new RequiredPlanetConditions(mode, conditions));
    }

    public void requirePlanetNotFullySurveyed() {
        this.search.planetReqs.add(new PlanetFullySurveyedReq(true));
    }

    public void preferPlanetNotFullySurveyed() {
        this.search.planetPrefs.add(new PlanetFullySurveyedReq(true));
    }

    public void requirePlanetFullySurveyed() {
        this.search.planetReqs.add(new PlanetFullySurveyedReq());
    }

    public void preferPlanetFullySurveyed() {
        this.search.planetPrefs.add(new PlanetFullySurveyedReq());
    }

    public void preferPlanetUnsurveyed() {
        this.search.planetPrefs.add(new PlanetUnsurveyedReq());
    }

    public void requirePlanetUnsurveyed() {
        this.search.planetReqs.add(new PlanetUnsurveyedReq());
    }

    public void requirePlanetWithRuins() {
        this.requirePlanetConditions(ReqMode.ANY, "ruins_scattered", "ruins_widespread", "ruins_extensive", "ruins_vast");
    }

    public void preferPlanetWithRuins() {
        this.preferPlanetConditions(ReqMode.ANY, "ruins_scattered", "ruins_widespread", "ruins_extensive", "ruins_vast");
    }

    public void requirePlanetWithoutRuins() {
        this.requirePlanetConditions(ReqMode.NOT_ANY, "ruins_scattered", "ruins_widespread", "ruins_extensive", "ruins_vast");
    }

    public void preferPlanetWithoutRuins() {
        this.preferPlanetConditions(ReqMode.NOT_ANY, "ruins_scattered", "ruins_widespread", "ruins_extensive", "ruins_vast");
    }

    public void requirePlanetUnexploredRuins() {
        this.search.planetReqs.add(new PlanetUnexploredRuinsReq());
    }

    public void preferPlanetUnexploredRuins() {
        this.search.planetPrefs.add(new PlanetUnexploredRuinsReq());
    }

    public void requireEntityTags(ReqMode mode, String ... tags) {
        this.search.entityReqs.add(new RequiredEntityTags(mode, tags));
    }

    public void preferEntityTags(ReqMode mode, String ... tags) {
        this.search.entityPrefs.add(new RequiredEntityTags(mode, tags));
    }

    public void requireEntityType(String ... types) {
        this.search.entityReqs.add(new EntityTypeReq(types));
    }

    public void preferEntityType(String ... types) {
        this.search.entityPrefs.add(new EntityTypeReq(types));
    }

    public void requireEntityMemoryFlags(String ... flags) {
        this.search.entityReqs.add(new EntityMemoryReq(flags));
    }

    public void preferEntityMemoryFlags(String ... flags) {
        this.search.entityPrefs.add(new EntityMemoryReq(flags));
    }

    public void requireEntityUndiscovered() {
        this.search.entityReqs.add(new EntityUndiscoveredReq(false));
    }

    public void preferEntityUndiscovered() {
        this.search.entityPrefs.add(new EntityUndiscoveredReq(false));
    }

    public void requireEntityNot(final SectorEntityToken entity) {
        this.search.entityReqs.add(new EntityRequirement(){

            @Override
            public boolean entityMatchesRequirement(SectorEntityToken param) {
                return entity != param;
            }
        });
    }

    public void requirePlanetNot(final PlanetAPI planet) {
        this.search.planetReqs.add(new PlanetRequirement(){

            @Override
            public boolean planetMatchesRequirement(PlanetAPI param) {
                return planet != param;
            }
        });
    }

    public void requireSystemNot(final StarSystemAPI system) {
        if (system == null) {
            return;
        }
        this.search.systemReqs.add(new StarSystemRequirement(){

            @Override
            public boolean systemMatchesRequirement(StarSystemAPI param) {
                return system != param;
            }
        });
    }

    public void requireSystemIs(final StarSystemAPI system) {
        this.search.systemReqs.add(new StarSystemRequirement(){

            @Override
            public boolean systemMatchesRequirement(StarSystemAPI param) {
                return system == param;
            }
        });
    }

    public void requireSystem(StarSystemRequirement req) {
        this.search.systemReqs.add(req);
    }

    public void preferSystem(StarSystemRequirement req) {
        this.search.systemPrefs.add(req);
    }

    protected void findMatching(List reqs, List prefs, List params, List matches, List preferred) {
        if (reqs.isEmpty() && prefs.isEmpty()) {
            matches.addAll(params);
            return;
        }
        block0: for (Object param : params) {
            for (Object req : reqs) {
                if (!HubMissionWithSearch.matchesReq((GenericRequirement)req, param)) continue block0;
            }
            matches.add(param);
        }
        ArrayList matchingPrefs = new ArrayList(matches);
        boolean foundAny = false;
        for (Object req : prefs) {
            ArrayList retain = new ArrayList();
            for (Object curr : matchingPrefs) {
                if (!HubMissionWithSearch.matchesReq((GenericRequirement)req, curr)) continue;
                retain.add(curr);
            }
            if (retain.isEmpty()) continue;
            foundAny = true;
            matchingPrefs.retainAll(retain);
        }
        if (foundAny) {
            preferred.addAll(matchingPrefs);
        }
    }

    public Object pickFromMatching(List matches, List preferred) {
        WeightedRandomPicker pref = new WeightedRandomPicker(this.genRandom);
        WeightedRandomPicker other = new WeightedRandomPicker(this.genRandom);
        pref.addAll(preferred);
        other.addAll(matches);
        if (!pref.isEmpty()) {
            return pref.pick();
        }
        return other.pick();
    }

    protected void findMatchingSystems() {
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_hidden");
        this.search.matchingSystems = new ArrayList<StarSystemAPI>();
        this.search.preferredSystems = new ArrayList<StarSystemAPI>();
        this.findMatching(this.search.systemReqs, this.search.systemPrefs, Global.getSector().getStarSystems(), this.search.matchingSystems, this.search.preferredSystems);
    }

    public StarSystemAPI pickSystem() {
        return this.pickSystem(true);
    }

    public StarSystemAPI pickSystem(boolean resetSearch) {
        this.findMatchingSystems();
        StarSystemAPI system = (StarSystemAPI)this.pickFromMatching(this.search.matchingSystems, this.search.preferredSystems);
        if (resetSearch) {
            this.resetSearch();
        }
        return system;
    }

    public void searchMakeSystemPreferencesMoreImportant(boolean value) {
        this.makeSystemPreferencesMoreImportant = value;
    }

    public PlanetAPI pickPlanet() {
        return this.pickPlanet(true);
    }

    public PlanetAPI pickPlanet(boolean resetSearch) {
        this.findMatchingSystems();
        ArrayList<PlanetAPI> inPreferredSystems = new ArrayList<PlanetAPI>();
        ArrayList<PlanetAPI> inMatchingSystems = new ArrayList<PlanetAPI>();
        for (StarSystemAPI system : this.search.matchingSystems) {
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.hasTag("not_random_mission_target")) continue;
                inMatchingSystems.add(planet);
            }
        }
        for (StarSystemAPI system : this.search.preferredSystems) {
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.hasTag("not_random_mission_target")) continue;
                inPreferredSystems.add(planet);
            }
        }
        ArrayList matchesInPref = new ArrayList();
        ArrayList preferredInPref = new ArrayList();
        this.findMatching(this.search.planetReqs, this.search.planetPrefs, inPreferredSystems, matchesInPref, preferredInPref);
        if (!preferredInPref.isEmpty()) {
            if (resetSearch) {
                this.resetSearch();
            }
            return (PlanetAPI)this.pickOneObject(preferredInPref);
        }
        ArrayList matchesInMatches = new ArrayList();
        ArrayList preferredInMatches = new ArrayList();
        this.findMatching(this.search.planetReqs, this.search.planetPrefs, inMatchingSystems, matchesInMatches, preferredInMatches);
        if (this.makeSystemPreferencesMoreImportant) {
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (PlanetAPI)this.pickOneObject(matchesInPref);
            }
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (PlanetAPI)this.pickOneObject(preferredInMatches);
            }
        } else {
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (PlanetAPI)this.pickOneObject(preferredInMatches);
            }
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (PlanetAPI)this.pickOneObject(matchesInPref);
            }
        }
        if (resetSearch) {
            this.resetSearch();
        }
        return (PlanetAPI)this.pickOneObject(matchesInMatches);
    }

    public SectorEntityToken pickEntity() {
        return this.pickEntity(true);
    }

    public SectorEntityToken pickEntity(boolean resetSearch) {
        ArrayList<SectorEntityToken> entities;
        this.findMatchingSystems();
        ArrayList<SectorEntityToken> inPreferredSystems = new ArrayList<SectorEntityToken>();
        ArrayList<SectorEntityToken> inMatchingSystems = new ArrayList<SectorEntityToken>();
        for (StarSystemAPI system : this.search.matchingSystems) {
            entities = new ArrayList<SectorEntityToken>(system.getAllEntities());
            for (SectorEntityToken entity : entities) {
                if (entity instanceof AsteroidAPI || entity.hasTag("expires") || entity.hasTag("not_random_mission_target")) continue;
                inMatchingSystems.add(entity);
            }
        }
        for (StarSystemAPI system : this.search.preferredSystems) {
            entities = new ArrayList<SectorEntityToken>(system.getAllEntities());
            for (SectorEntityToken entity : entities) {
                if (entity instanceof AsteroidAPI || entity.hasTag("expires") || entity.hasTag("not_random_mission_target")) continue;
                inPreferredSystems.add(entity);
            }
        }
        ArrayList matchesInPref = new ArrayList();
        ArrayList preferredInPref = new ArrayList();
        this.findMatching(this.search.entityReqs, this.search.entityPrefs, inPreferredSystems, matchesInPref, preferredInPref);
        if (!preferredInPref.isEmpty()) {
            if (resetSearch) {
                this.resetSearch();
            }
            return (SectorEntityToken)this.pickOneObject(preferredInPref);
        }
        ArrayList matchesInMatches = new ArrayList();
        ArrayList preferredInMatches = new ArrayList();
        this.findMatching(this.search.entityReqs, this.search.entityPrefs, inMatchingSystems, matchesInMatches, preferredInMatches);
        if (this.makeSystemPreferencesMoreImportant) {
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (SectorEntityToken)this.pickOneObject(matchesInPref);
            }
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (SectorEntityToken)this.pickOneObject(preferredInMatches);
            }
        } else {
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (SectorEntityToken)this.pickOneObject(preferredInMatches);
            }
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (SectorEntityToken)this.pickOneObject(matchesInPref);
            }
        }
        if (resetSearch) {
            this.resetSearch();
        }
        return (SectorEntityToken)this.pickOneObject(matchesInMatches);
    }

    protected void findMatchingMarkets() {
        ArrayList<MarketAPI> markets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.hasTag("not_random_mission_target") || market.getPlanetEntity() != null && market.getPlanetEntity().hasTag("not_random_mission_target")) continue;
            markets.add(market);
        }
        this.search.matchingMarkets = new ArrayList<MarketAPI>();
        this.search.preferredMarkets = new ArrayList<MarketAPI>();
        this.findMatching(this.search.marketReqs, this.search.marketPrefs, markets, this.search.matchingMarkets, this.search.preferredMarkets);
    }

    public MarketAPI pickMarket() {
        return this.pickMarket(true);
    }

    public MarketAPI pickMarket(boolean resetSearch) {
        this.findMatchingMarkets();
        MarketAPI market = (MarketAPI)this.pickFromMatching(this.search.matchingMarkets, this.search.preferredMarkets);
        if (resetSearch) {
            this.resetSearch();
        }
        return market;
    }

    public CommodityOnMarketAPI pickCommodity() {
        return this.pickCommodity(true);
    }

    public CommodityOnMarketAPI pickCommodity(boolean resetSearch) {
        CommodityOnMarketAPI result;
        this.findMatchingMarkets();
        WeightedRandomPicker pref = new WeightedRandomPicker(this.genRandom);
        WeightedRandomPicker<CommodityOnMarketAPI> other = new WeightedRandomPicker<CommodityOnMarketAPI>(this.genRandom);
        for (MarketAPI market : this.search.matchingMarkets) {
            block1: for (CommodityOnMarketAPI com : market.getAllCommodities()) {
                if (com.isMeta() || com.isNonEcon()) continue;
                for (CommodityRequirement req : this.search.commodityReqs) {
                    if (!req.commodityMatchesRequirement(com)) continue block1;
                }
                other.add(com);
            }
        }
        ArrayList matchingPrefs = new ArrayList(other.getItems());
        boolean foundAny = false;
        for (CommodityRequirement req : this.search.commodityPrefs) {
            ArrayList<CommodityOnMarketAPI> retain = new ArrayList<CommodityOnMarketAPI>();
            for (CommodityOnMarketAPI com : matchingPrefs) {
                if (!req.commodityMatchesRequirement(com)) continue;
                retain.add(com);
            }
            if (retain.isEmpty()) continue;
            foundAny = true;
            matchingPrefs.retainAll(retain);
        }
        if (foundAny) {
            pref.addAll(matchingPrefs);
        }
        if ((result = (CommodityOnMarketAPI)pref.pick()) == null) {
            result = (CommodityOnMarketAPI)other.pick();
        }
        if (resetSearch) {
            this.resetSearch();
        }
        return result;
    }

    public void requireMarketTacticallyBombardable() {
        this.search.marketReqs.add(new MarketTacticalBombardableReq(false));
    }

    public void requireMarketNotTacticallyBombardable() {
        this.search.marketReqs.add(new MarketTacticalBombardableReq(true));
    }

    public void preferMarketTacticallyBombardable() {
        this.search.marketPrefs.add(new MarketTacticalBombardableReq(false));
    }

    public void preferMarketNotTacticallyBombardable() {
        this.search.marketPrefs.add(new MarketTacticalBombardableReq(true));
    }

    public void requireMarketMilitary() {
        this.search.marketReqs.add(new MarketMilitaryReq());
    }

    public void preferMarketMilitary() {
        this.search.marketPrefs.add(new MarketMilitaryReq());
    }

    public void requireMarketNotMilitary() {
        this.search.marketReqs.add(new MarketNotMilitaryReq());
    }

    public void preferMarketNotMilitary() {
        this.search.marketPrefs.add(new MarketNotMilitaryReq());
    }

    public void requireMarketMemoryFlag(String key, Object value) {
        this.search.marketReqs.add(new MarketMemoryFlagReq(key, value));
    }

    public void preferMarketMemoryFlag(String key, Object value) {
        this.search.marketPrefs.add(new MarketMemoryFlagReq(key, value));
    }

    public void requireMarketHidden() {
        this.search.marketReqs.add(new MarketHiddenReq());
    }

    public void preferMarketHidden() {
        this.search.marketPrefs.add(new MarketHiddenReq());
    }

    public void requireMarketNotHidden() {
        this.search.marketReqs.add(new MarketNotHiddenReq());
    }

    public void preferMarketNotHidden() {
        this.search.marketPrefs.add(new MarketNotHiddenReq());
    }

    public void requireMarketNotInHyperspace() {
        this.search.marketReqs.add(new MarketNotInHyperReq());
    }

    public void preferMarketNotInHyperspace() {
        this.search.marketPrefs.add(new MarketNotInHyperReq());
    }

    public void requireMarketIs(String id) {
        this.search.marketReqs.add(new MarketIsReq(Global.getSector().getEconomy().getMarket(id), false));
    }

    public void requireMarketIs(MarketAPI param) {
        this.search.marketReqs.add(new MarketIsReq(param, false));
    }

    public void preferMarketIs(MarketAPI param) {
        this.search.marketPrefs.add(new MarketIsReq(param, false));
    }

    public void requireMarketIsNot(MarketAPI param) {
        this.search.marketReqs.add(new MarketIsReq(param, true));
    }

    public void preferMarketIsNot(MarketAPI param) {
        this.search.marketPrefs.add(new MarketIsReq(param, true));
    }

    public void requireMarketFaction(String ... factions) {
        this.search.marketReqs.add(new MarketFactionReq(false, factions));
    }

    public void preferMarketFaction(String ... factions) {
        this.search.marketPrefs.add(new MarketFactionReq(false, factions));
    }

    public void requireMarketFactionNot(String ... factions) {
        this.search.marketReqs.add(new MarketFactionReq(true, factions));
    }

    public void preferMarketFactionNot(String ... factions) {
        this.search.marketPrefs.add(new MarketFactionReq(true, factions));
    }

    public void requireMarketFactionNotPlayer() {
        this.requireMarketFactionNot("player");
    }

    public void requireMarketFactionHostileTo(String faction) {
        this.search.marketReqs.add(new MarketFactionHostileReq(false, faction));
    }

    public void preferMarketFactionHostileTo(String faction) {
        this.search.marketPrefs.add(new MarketFactionHostileReq(false, faction));
    }

    public void requireMarketFactionNotHostileTo(String faction) {
        this.search.marketReqs.add(new MarketFactionHostileReq(true, faction));
    }

    public void preferMarketFactionNotHostileTo(String faction) {
        this.search.marketPrefs.add(new MarketFactionHostileReq(true, faction));
    }

    protected LocationAPI[] convertLocations(String ... locations) {
        ArrayList<LocationAPI> result = new ArrayList<LocationAPI>();
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("hyperspace".equals(s)) {
                result.add(Global.getSector().getHyperspace());
            } else {
                StarSystemAPI system = Global.getSector().getStarSystem(s);
                if (system != null) {
                    result.add(system);
                }
            }
            ++n2;
        }
        return result.toArray(new LocationAPI[0]);
    }

    public void requireMarketLocation(String ... locations) {
        this.requireMarketLocation(this.convertLocations(locations));
    }

    public void preferMarketLocation(String ... locations) {
        this.preferMarketLocation(this.convertLocations(locations));
    }

    public void requireMarketLocationNot(String ... locations) {
        this.requireMarketLocationNot(this.convertLocations(locations));
    }

    public void preferMarketLocationNot(String ... locations) {
        this.preferMarketLocationNot(this.convertLocations(locations));
    }

    public void requireMarketLocation(LocationAPI ... locations) {
        this.search.marketReqs.add(new MarketLocationReq(false, locations));
    }

    public void preferMarketLocation(LocationAPI ... locations) {
        this.search.marketPrefs.add(new MarketLocationReq(false, locations));
    }

    public void requireMarketLocationNot(LocationAPI ... locations) {
        this.search.marketReqs.add(new MarketLocationReq(true, locations));
    }

    public void preferMarketLocationNot(LocationAPI ... locations) {
        this.search.marketPrefs.add(new MarketLocationReq(true, locations));
    }

    public void requireMarketFactionCustom(ReqMode mode, String ... custom) {
        this.search.marketReqs.add(new MarketFactionCustomReq(mode, custom));
    }

    public void preferMarketFactionCustom(ReqMode mode, String ... custom) {
        this.search.marketPrefs.add(new MarketFactionCustomReq(mode, custom));
    }

    public void requireMarketSizeAtLeast(final int size) {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getSize() >= size;
            }
        });
    }

    public void preferMarketSizeAtLeast(final int size) {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getSize() >= size;
            }
        });
    }

    public void requireMarketSizeAtMost(final int size) {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getSize() <= size;
            }
        });
    }

    public void preferMarketSizeAtMost(final int size) {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getSize() <= size;
            }
        });
    }

    public void requireMarketStabilityAtLeast(final int stability) {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getStabilityValue() >= (float)stability;
            }
        });
    }

    public void preferMarketStabilityAtLeast(final int stability) {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getStabilityValue() >= (float)stability;
            }
        });
    }

    public void requireMarketStabilityAtMost(final int stability) {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getStabilityValue() <= (float)stability;
            }
        });
    }

    public void preferMarketStabilityAtMost(final int stability) {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.getStabilityValue() <= (float)stability;
            }
        });
    }

    public void requireMarketConditions(ReqMode mode, String ... conditions) {
        this.search.marketReqs.add(new RequiredMarketConditions(mode, conditions));
    }

    public void preferMarketConditions(ReqMode mode, String ... conditions) {
        this.search.marketPrefs.add(new RequiredMarketConditions(mode, conditions));
    }

    public void requireMarketIndustries(ReqMode mode, String ... industries) {
        this.search.marketReqs.add(new RequiredMarketIndustries(mode, industries));
    }

    public void preferMarketIndustries(ReqMode mode, String ... industries) {
        this.search.marketPrefs.add(new RequiredMarketIndustries(mode, industries));
    }

    public void requireMarketIsMilitary() {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return Misc.isMilitary(market);
            }
        });
    }

    public void preferMarketIsMilitary() {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return Misc.isMilitary(market);
            }
        });
    }

    public void requireMarketHasSpaceport() {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.hasSpaceport();
            }
        });
    }

    public void preferMarketHasSpaceport() {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return market.hasSpaceport();
            }
        });
    }

    public void requireMarketNotHasSpaceport() {
        this.search.marketReqs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return !market.hasSpaceport();
            }
        });
    }

    public void preferMarketNotHasSpaceport() {
        this.search.marketPrefs.add(new MarketRequirement(){

            @Override
            public boolean marketMatchesRequirement(MarketAPI market) {
                return !market.hasSpaceport();
            }
        });
    }

    public void requireCommodityIsNotPersonnel() {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return !com.isPersonnel();
            }
        });
    }

    public void preferCommodityIsNotPersonnel() {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return !com.isPersonnel();
            }
        });
    }

    public void requireCommodityLegal() {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return !com.isIllegal();
            }
        });
    }

    public void preferCommodityLegal() {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return !com.isIllegal();
            }
        });
    }

    public void requireCommodityIllegal() {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.isIllegal();
            }
        });
    }

    public void preferCommodityIllegal() {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.isIllegal();
            }
        });
    }

    public void requireCommodityIs(final String id) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getId().equals(id);
            }
        });
    }

    public void preferCommodityIs(final String id) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getId().equals(id);
            }
        });
    }

    public void requireCommodityTags(ReqMode mode, String ... tags) {
        this.search.commodityReqs.add(new RequiredCommodityTags(mode, tags));
    }

    public void preferCommodityTags(ReqMode mode, String ... tags) {
        this.search.commodityPrefs.add(new RequiredCommodityTags(mode, tags));
    }

    public void requireCommodityAvailableAtLeast(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getAvailable() >= qty;
            }
        });
    }

    public void preferCommodityAvailableAtLeast(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getAvailable() >= qty;
            }
        });
    }

    public void requireCommodityAvailableAtMost(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getAvailable() <= qty;
            }
        });
    }

    public void preferCommodityAvailableAtMost(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getAvailable() <= qty;
            }
        });
    }

    public void requireCommodityDemandAtLeast(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxDemand() >= qty;
            }
        });
    }

    public void preferCommodityDemandAtLeast(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxDemand() >= qty;
            }
        });
    }

    public void requireCommodityDemandAtMost(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxDemand() <= qty;
            }
        });
    }

    public void preferCommodityDemandAtMost(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxDemand() <= qty;
            }
        });
    }

    public void requireCommodityProductionAtLeast(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxSupply() >= qty;
            }
        });
    }

    public void preferCommodityProductionAtLeast(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxSupply() >= qty;
            }
        });
    }

    public void requireCommodityProductionAtMost(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxSupply() <= qty;
            }
        });
    }

    public void preferCommodityProductionAtMost(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getMaxSupply() <= qty;
            }
        });
    }

    public void requireCommoditySurplusAtLeast(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.extra >= qty;
            }
        });
    }

    public void preferCommoditySurplusAtLeast(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.extra >= qty;
            }
        });
    }

    public void requireCommoditySurplusAtMost(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.extra <= qty;
            }
        });
    }

    public void preferCommoditySurplusAtMost(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.extra <= qty;
            }
        });
    }

    public void requireCommodityDeficitAtLeast(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.deficit >= qty;
            }
        });
    }

    public void preferCommodityDeficitAtLeast(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.deficit >= qty;
            }
        });
    }

    public void requireCommodityDeficitAtMost(final int qty) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.deficit <= qty;
            }
        });
    }

    public void preferCommodityDeficitAtMost(final int qty) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                CommodityIconCounts counts = new CommodityIconCounts(com);
                return counts.deficit <= qty;
            }
        });
    }

    public void requireCommodityBasePriceAtLeast(final float price) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getCommodity().getBasePrice() >= price;
            }
        });
    }

    public void preferCommodityBasePriceAtLeast(final float price) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getCommodity().getBasePrice() >= price;
            }
        });
    }

    public void requireCommodityBasePriceAtMost(final float price) {
        this.search.commodityReqs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getCommodity().getBasePrice() <= price;
            }
        });
    }

    public void preferCommodityBasePriceAtMost(final float price) {
        this.search.commodityPrefs.add(new CommodityRequirement(){

            @Override
            public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
                return com.getCommodity().getBasePrice() <= price;
            }
        });
    }

    public void requireTerrainType(ReqMode mode, String ... types) {
        this.search.terrainReqs.add(new TerrainTypeReq(mode, types));
    }

    public void preferTerrainType(ReqMode mode, String ... types) {
        this.search.terrainPrefs.add(new TerrainTypeReq(mode, types));
    }

    public void requireTerrainTags(ReqMode mode, String ... tags) {
        this.search.terrainReqs.add(new RequiredTerrainTags(mode, tags));
    }

    public void preferTerrainTags(ReqMode mode, String ... tags) {
        this.search.terrainPrefs.add(new RequiredTerrainTags(mode, tags));
    }

    public void requireTerrainHasSpecialName() {
        this.search.terrainReqs.add(new TerrainHasSpecialNameReq());
    }

    public void preferTerrainHasSpecialName() {
        this.search.terrainPrefs.add(new TerrainHasSpecialNameReq());
    }

    public CampaignTerrainAPI pickTerrain() {
        return this.pickTerrain(true);
    }

    public CampaignTerrainAPI pickTerrain(boolean resetSearch) {
        BaseRingTerrain rtp;
        BaseTiledTerrain btt;
        ArrayList<CampaignTerrainAPI> terrainList;
        this.findMatchingSystems();
        ArrayList inPreferredSystems = new ArrayList();
        ArrayList<CampaignTerrainAPI> inMatchingSystems = new ArrayList<CampaignTerrainAPI>();
        for (StarSystemAPI system : this.search.matchingSystems) {
            terrainList = new ArrayList<CampaignTerrainAPI>(system.getTerrainCopy());
            for (CampaignTerrainAPI terrain : terrainList) {
                if (terrain.hasTag("expires") || terrain.getPlugin() instanceof BaseTiledTerrain && (btt = (BaseTiledTerrain)terrain.getPlugin()).getTiles() != null && btt.getTiles().length > 50 || terrain.getPlugin() instanceof BaseRingTerrain && (rtp = (BaseRingTerrain)terrain.getPlugin()).getRingParams() != null && rtp.getRingParams().middleRadius > 5000.0f) continue;
                inMatchingSystems.add(terrain);
            }
        }
        for (StarSystemAPI system : this.search.preferredSystems) {
            terrainList = new ArrayList<CampaignTerrainAPI>(system.getTerrainCopy());
            for (CampaignTerrainAPI terrain : terrainList) {
                if (terrain.hasTag("expires") || terrain.getPlugin() instanceof BaseTiledTerrain && (btt = (BaseTiledTerrain)terrain.getPlugin()).getTiles() != null && btt.getTiles().length > 50 || terrain.getPlugin() instanceof BaseRingTerrain && (rtp = (BaseRingTerrain)terrain.getPlugin()).getRingParams() != null && rtp.getRingParams().middleRadius > 5000.0f) continue;
                inMatchingSystems.add(terrain);
            }
        }
        ArrayList matchesInPref = new ArrayList();
        ArrayList preferredInPref = new ArrayList();
        this.findMatching(this.search.terrainReqs, this.search.terrainPrefs, inPreferredSystems, matchesInPref, preferredInPref);
        if (!preferredInPref.isEmpty()) {
            if (resetSearch) {
                this.resetSearch();
            }
            return (CampaignTerrainAPI)this.pickOneObject(preferredInPref);
        }
        ArrayList matchesInMatches = new ArrayList();
        ArrayList preferredInMatches = new ArrayList();
        this.findMatching(this.search.terrainReqs, this.search.terrainPrefs, inMatchingSystems, matchesInMatches, preferredInMatches);
        if (this.makeSystemPreferencesMoreImportant) {
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (CampaignTerrainAPI)this.pickOneObject(matchesInPref);
            }
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (CampaignTerrainAPI)this.pickOneObject(preferredInMatches);
            }
        } else {
            if (!preferredInMatches.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (CampaignTerrainAPI)this.pickOneObject(preferredInMatches);
            }
            if (!matchesInPref.isEmpty()) {
                if (resetSearch) {
                    this.resetSearch();
                }
                return (CampaignTerrainAPI)this.pickOneObject(matchesInPref);
            }
        }
        if (resetSearch) {
            this.resetSearch();
        }
        return (CampaignTerrainAPI)this.pickOneObject(matchesInMatches);
    }

    public static interface CommodityRequirement
    extends GenericRequirement {
        public boolean commodityMatchesRequirement(CommodityOnMarketAPI var1);
    }

    public static class EntityInDirectionOfOtherMissionsReq
    implements EntityRequirement {
        protected HubMissionWithSearch mission;
        protected float arcMult;

        public EntityInDirectionOfOtherMissionsReq(HubMissionWithSearch mission, float arcMult) {
            this.mission = mission;
            this.arcMult = arcMult;
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            return this.mission.matchesSetMissionAngle(entity.getLocationInHyperspace(), DEFAULT_MISSION_ARC * this.arcMult, DEFAULT_MISSION_ARC_BONUS);
        }
    }

    public static class EntityMemoryReq
    implements EntityRequirement {
        private List<String> flags = new ArrayList<String>();

        public EntityMemoryReq(String ... flags) {
            String[] stringArray = flags;
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                this.flags.add(flag);
                ++n2;
            }
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            for (String flag : this.flags) {
                if (entity.getMemoryWithoutUpdate().getBoolean(flag)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface EntityRequirement
    extends GenericRequirement {
        public boolean entityMatchesRequirement(SectorEntityToken var1);
    }

    public static class EntityTypeReq
    implements EntityRequirement {
        private Set<String> set = new LinkedHashSet<String>();

        public EntityTypeReq(String[] types) {
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.set.add(type);
                ++n2;
            }
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            return this.set.contains(entity.getCustomEntityType());
        }
    }

    public static class EntityUndiscoveredReq
    implements EntityRequirement {
        boolean negate;

        public EntityUndiscoveredReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            boolean result = entity.isDiscoverable();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static interface GenericRequirement {
    }

    public static class MarketFactionCustomReq
    extends StringCollectionReqs
    implements MarketRequirement {
        public MarketFactionCustomReq(ReqMode mode, String ... custom) {
            super(mode, custom);
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            HashSet<String> set = new HashSet<String>();
            for (String custom : this.tags) {
                if (!market.getFaction().getCustomBoolean(custom)) continue;
                set.add(custom);
            }
            return this.matchesRequirements(set);
        }
    }

    public static class MarketFactionHostileReq
    implements MarketRequirement {
        boolean negate;
        String faction;

        public MarketFactionHostileReq(boolean negate, String faction) {
            this.faction = faction;
            this.negate = negate;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            boolean result = market.getFaction().isHostileTo(this.faction);
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class MarketFactionReq
    implements MarketRequirement {
        boolean negate;
        Set<String> factions = new LinkedHashSet<String>();

        public MarketFactionReq(boolean negate, String ... factions) {
            this.factions.addAll(Arrays.asList(factions));
            this.negate = negate;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            boolean result = this.factions.contains(market.getFactionId());
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class MarketHiddenReq
    implements MarketRequirement {
        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return market.isHidden();
        }
    }

    public static class MarketInDirectionOfOtherMissionsReq
    implements MarketRequirement {
        protected HubMissionWithSearch mission;
        protected float arcMult;

        public MarketInDirectionOfOtherMissionsReq(HubMissionWithSearch mission, float arcMult) {
            this.mission = mission;
            this.arcMult = arcMult;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return this.mission.matchesSetMissionAngle(market.getLocationInHyperspace(), DEFAULT_MISSION_MARKET_ARC * this.arcMult, DEFAULT_MISSION_MARKET_ARC_BONUS);
        }
    }

    public static class MarketIsReq
    implements MarketRequirement {
        boolean negate;
        MarketAPI param;

        public MarketIsReq(MarketAPI param, boolean negate) {
            this.param = param;
            this.negate = negate;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            boolean result;
            boolean bl = result = market == this.param;
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class MarketLocationReq
    implements MarketRequirement {
        boolean negate;
        Set<LocationAPI> locations = new LinkedHashSet<LocationAPI>();

        public MarketLocationReq(boolean negate, LocationAPI ... locations) {
            this.locations.addAll(Arrays.asList(locations));
            this.negate = negate;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            boolean result = this.locations.contains(market.getContainingLocation());
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class MarketMemoryFlagReq
    implements MarketRequirement {
        String key;
        Object value;

        public MarketMemoryFlagReq(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            Object val = market.getMemoryWithoutUpdate().get(this.key);
            return val != null && val.equals(this.value);
        }
    }

    public static class MarketMilitaryReq
    implements MarketRequirement {
        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return Misc.isMilitary(market);
        }
    }

    public static class MarketNotHiddenReq
    implements MarketRequirement {
        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return !market.isHidden();
        }
    }

    public static class MarketNotInHyperReq
    implements MarketRequirement {
        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return !market.isInHyperspace();
        }
    }

    public static class MarketNotMilitaryReq
    implements MarketRequirement {
        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            return !Misc.isMilitary(market);
        }
    }

    public static interface MarketRequirement
    extends GenericRequirement {
        public boolean marketMatchesRequirement(MarketAPI var1);
    }

    public static class MarketTacticalBombardableReq
    implements MarketRequirement {
        boolean negate;

        public MarketTacticalBombardableReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            boolean result;
            boolean bl = result = !MarketCMD.getTacticalBombardmentTargets(market).isEmpty();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class MultipleCommodityRequirements
    implements CommodityRequirement {
        protected CommodityRequirement[] reqs;
        protected ReqMode mode;

        public MultipleCommodityRequirements(ReqMode mode, CommodityRequirement ... reqs) {
            this.mode = mode;
            this.reqs = reqs;
        }

        @Override
        public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
            switch (this.mode) {
                case ALL: {
                    CommodityRequirement[] commodityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CommodityRequirement req = commodityRequirementArray[n2];
                        if (!req.commodityMatchesRequirement(com)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case ANY: {
                    CommodityRequirement[] commodityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        CommodityRequirement req = commodityRequirementArray[n3];
                        if (req.commodityMatchesRequirement(com)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case NOT_ALL: {
                    CommodityRequirement[] commodityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        CommodityRequirement req = commodityRequirementArray[n4];
                        if (!req.commodityMatchesRequirement(com)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                case NOT_ANY: {
                    CommodityRequirement[] commodityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        CommodityRequirement req = commodityRequirementArray[n5];
                        if (req.commodityMatchesRequirement(com)) {
                            return false;
                        }
                        ++n5;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class MultipleEntityRequirements
    implements EntityRequirement {
        protected EntityRequirement[] reqs;
        protected ReqMode mode;

        public MultipleEntityRequirements(ReqMode mode, EntityRequirement ... reqs) {
            this.mode = mode;
            this.reqs = reqs;
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            switch (this.mode) {
                case ALL: {
                    EntityRequirement[] entityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EntityRequirement req = entityRequirementArray[n2];
                        if (!req.entityMatchesRequirement(entity)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case ANY: {
                    EntityRequirement[] entityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        EntityRequirement req = entityRequirementArray[n3];
                        if (req.entityMatchesRequirement(entity)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case NOT_ALL: {
                    EntityRequirement[] entityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        EntityRequirement req = entityRequirementArray[n4];
                        if (!req.entityMatchesRequirement(entity)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                case NOT_ANY: {
                    EntityRequirement[] entityRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        EntityRequirement req = entityRequirementArray[n5];
                        if (req.entityMatchesRequirement(entity)) {
                            return false;
                        }
                        ++n5;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class MultipleMarketRequirements
    implements MarketRequirement {
        protected MarketRequirement[] reqs;
        protected ReqMode mode;

        public MultipleMarketRequirements(ReqMode mode, MarketRequirement ... reqs) {
            this.mode = mode;
            this.reqs = reqs;
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            switch (this.mode) {
                case ALL: {
                    MarketRequirement[] marketRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MarketRequirement req = marketRequirementArray[n2];
                        if (!req.marketMatchesRequirement(market)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case ANY: {
                    MarketRequirement[] marketRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MarketRequirement req = marketRequirementArray[n3];
                        if (req.marketMatchesRequirement(market)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case NOT_ALL: {
                    MarketRequirement[] marketRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        MarketRequirement req = marketRequirementArray[n4];
                        if (!req.marketMatchesRequirement(market)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                case NOT_ANY: {
                    MarketRequirement[] marketRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        MarketRequirement req = marketRequirementArray[n5];
                        if (req.marketMatchesRequirement(market)) {
                            return false;
                        }
                        ++n5;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class MultiplePlanetRequirements
    implements PlanetRequirement {
        protected PlanetRequirement[] reqs;
        protected ReqMode mode;

        public MultiplePlanetRequirements(ReqMode mode, PlanetRequirement ... reqs) {
            this.mode = mode;
            this.reqs = reqs;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            switch (this.mode) {
                case ALL: {
                    PlanetRequirement[] planetRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PlanetRequirement req = planetRequirementArray[n2];
                        if (!req.planetMatchesRequirement(planet)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case ANY: {
                    PlanetRequirement[] planetRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PlanetRequirement req = planetRequirementArray[n3];
                        if (req.planetMatchesRequirement(planet)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case NOT_ALL: {
                    PlanetRequirement[] planetRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        PlanetRequirement req = planetRequirementArray[n4];
                        if (!req.planetMatchesRequirement(planet)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                case NOT_ANY: {
                    PlanetRequirement[] planetRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        PlanetRequirement req = planetRequirementArray[n5];
                        if (req.planetMatchesRequirement(planet)) {
                            return false;
                        }
                        ++n5;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class MultipleStarSystemRequirements
    implements StarSystemRequirement {
        protected StarSystemRequirement[] reqs;
        protected ReqMode mode;

        public MultipleStarSystemRequirements(ReqMode mode, StarSystemRequirement ... reqs) {
            this.mode = mode;
            this.reqs = reqs;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            switch (this.mode) {
                case ALL: {
                    StarSystemRequirement[] starSystemRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StarSystemRequirement req = starSystemRequirementArray[n2];
                        if (!req.systemMatchesRequirement(system)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case ANY: {
                    StarSystemRequirement[] starSystemRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        StarSystemRequirement req = starSystemRequirementArray[n3];
                        if (req.systemMatchesRequirement(system)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case NOT_ALL: {
                    StarSystemRequirement[] starSystemRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        StarSystemRequirement req = starSystemRequirementArray[n4];
                        if (!req.systemMatchesRequirement(system)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                case NOT_ANY: {
                    StarSystemRequirement[] starSystemRequirementArray = this.reqs;
                    int n = this.reqs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        StarSystemRequirement req = starSystemRequirementArray[n5];
                        if (req.systemMatchesRequirement(system)) {
                            return false;
                        }
                        ++n5;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class PlanetFullySurveyedReq
    implements PlanetRequirement {
        protected boolean negate = false;

        public PlanetFullySurveyedReq() {
            this(false);
        }

        public PlanetFullySurveyedReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            boolean result;
            boolean bl = result = planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL;
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class PlanetInDirectionOfOtherMissionsReq
    implements PlanetRequirement {
        protected HubMissionWithSearch mission;
        protected float arcMult;

        public PlanetInDirectionOfOtherMissionsReq(HubMissionWithSearch mission, float arcMult) {
            this.mission = mission;
            this.arcMult = arcMult;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            return this.mission.matchesSetMissionAngle(planet.getLocationInHyperspace(), DEFAULT_MISSION_ARC * this.arcMult, DEFAULT_MISSION_ARC_BONUS);
        }
    }

    public static class PlanetIsGasGiantReq
    implements PlanetRequirement {
        protected boolean negate = false;

        public PlanetIsGasGiantReq() {
            this(false);
        }

        public PlanetIsGasGiantReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            boolean result = planet.isGasGiant();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class PlanetIsPopulatedReq
    implements PlanetRequirement {
        protected boolean negate = false;

        public PlanetIsPopulatedReq() {
            this(false);
        }

        public PlanetIsPopulatedReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            boolean result;
            boolean bl = result = planet.getMarket() != null && !planet.getMarket().isPlanetConditionMarketOnly();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class PlanetOrbitIsNotNearJumpPoint
    implements PlanetRequirement {
        protected float checkDist;

        public PlanetOrbitIsNotNearJumpPoint(float checkDist) {
            this.checkDist = checkDist;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            StarSystemAPI system = planet.getStarSystem();
            if (system == null) {
                return true;
            }
            float planetDist = planet.getCircularOrbitRadius();
            if (planet.getOrbit() == null) {
                planetDist = planet.getLocation().length();
            }
            for (SectorEntityToken jp : system.getJumpPoints()) {
                float dist = 0.0f;
                if (jp.getOrbitFocus() == planet.getOrbitFocus()) {
                    jpDist = jp.getCircularOrbitRadius();
                    if (jp.getOrbitFocus() == null) {
                        jpDist = jp.getLocation().length();
                    }
                    dist = Math.abs(planetDist - jpDist);
                    if (jp.getOrbitFocus() == null && planet.getOrbitFocus() == null) {
                        dist = Misc.getDistance(planet, jp);
                    }
                } else if (jp.getOrbitFocus() == null && planet.getOrbitFocus() != null) {
                    jpDist = Misc.getDistance(jp, planet.getOrbitFocus());
                    dist = Math.abs(planetDist - jpDist);
                    if (jp.getOrbitFocus() == null && planet.getOrbitFocus() == null) {
                        dist = Misc.getDistance(planet, jp);
                    }
                } else if (jp.getOrbitFocus() != null && planet.getOrbitFocus() == null) {
                    jpDist = jp.getCircularOrbitRadius();
                    float pDist2 = Misc.getDistance(jp.getOrbitFocus(), jp);
                    dist = Math.abs(pDist2 - jpDist);
                    if (jp.getOrbitFocus() == null && planet.getOrbitFocus() == null) {
                        dist = Misc.getDistance(planet, jp);
                    }
                } else if (jp.getOrbitFocus() != null && planet.getOrbitFocus() != null) {
                    jpDist = jp.getCircularOrbitRadius();
                    dist = Misc.getDistance(jp.getOrbitFocus(), planet.getOrbitFocus());
                    dist -= planetDist + jpDist;
                }
                if (!(dist < this.checkDist)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface PlanetRequirement
    extends GenericRequirement {
        public boolean planetMatchesRequirement(PlanetAPI var1);
    }

    public static class PlanetUnexploredRuinsReq
    implements PlanetRequirement {
        protected boolean negate = false;

        public PlanetUnexploredRuinsReq() {
            this(false);
        }

        public PlanetUnexploredRuinsReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            boolean result;
            MarketAPI market = planet.getMarket();
            boolean bl = result = market != null && market.isPlanetConditionMarketOnly() && !market.getMemoryWithoutUpdate().getBoolean("$ruinsExplored");
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class PlanetUnsurveyedReq
    implements PlanetRequirement {
        protected boolean negate = false;

        public PlanetUnsurveyedReq() {
            this(false);
        }

        public PlanetUnsurveyedReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            boolean result;
            boolean bl = result = planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.NONE;
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class RequiredCommodityTags
    extends StringCollectionReqs
    implements CommodityRequirement {
        public RequiredCommodityTags(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean commodityMatchesRequirement(CommodityOnMarketAPI com) {
            ArrayList<String> set = new ArrayList<String>();
            set.addAll(com.getCommodity().getTags());
            return this.matchesRequirements(set);
        }
    }

    public static class RequiredEntityTags
    extends StringCollectionReqs
    implements EntityRequirement {
        public RequiredEntityTags(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean entityMatchesRequirement(SectorEntityToken entity) {
            return this.matchesRequirements(entity.getTags());
        }
    }

    public static class RequiredMarketConditions
    extends StringCollectionReqs
    implements MarketRequirement {
        public RequiredMarketConditions(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            ArrayList<String> set = new ArrayList<String>();
            for (MarketConditionAPI mc : market.getConditions()) {
                set.add(mc.getId());
            }
            return this.matchesRequirements(set);
        }
    }

    public static class RequiredMarketIndustries
    extends StringCollectionReqs
    implements MarketRequirement {
        public RequiredMarketIndustries(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean marketMatchesRequirement(MarketAPI market) {
            ArrayList<String> set = new ArrayList<String>();
            for (Industry ind : market.getIndustries()) {
                set.add(ind.getId());
            }
            return this.matchesRequirements(set);
        }
    }

    public static class RequiredPlanetConditions
    extends StringCollectionReqs
    implements PlanetRequirement {
        public RequiredPlanetConditions(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            ArrayList<String> set = new ArrayList<String>();
            if (planet.getMarket() != null) {
                for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
                    set.add(mc.getId());
                }
            }
            return this.matchesRequirements(set);
        }
    }

    public static class RequiredPlanetTags
    extends StringCollectionReqs
    implements PlanetRequirement {
        public RequiredPlanetTags(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean planetMatchesRequirement(PlanetAPI planet) {
            return this.matchesRequirements(planet.getTags());
        }
    }

    public static class RequiredSystemTags
    extends StringCollectionReqs
    implements StarSystemRequirement {
        public RequiredSystemTags(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            return this.matchesRequirements(system.getTags());
        }
    }

    public static class RequiredTerrainTags
    extends StringCollectionReqs
    implements TerrainRequirement {
        public RequiredTerrainTags(ReqMode mode, String[] tags) {
            super(mode, tags);
        }

        @Override
        public boolean terrainMatchesRequirement(CampaignTerrainAPI terrain) {
            return this.matchesRequirements(terrain.getTags());
        }
    }

    public static class SearchData {
        public List<GenericRequirement> systemReqs = new ArrayList<GenericRequirement>();
        public List<GenericRequirement> systemPrefs = new ArrayList<GenericRequirement>();
        public List<PlanetRequirement> planetReqs = new ArrayList<PlanetRequirement>();
        public List<PlanetRequirement> planetPrefs = new ArrayList<PlanetRequirement>();
        public List<EntityRequirement> entityReqs = new ArrayList<EntityRequirement>();
        public List<EntityRequirement> entityPrefs = new ArrayList<EntityRequirement>();
        public List<MarketRequirement> marketReqs = new ArrayList<MarketRequirement>();
        public List<MarketRequirement> marketPrefs = new ArrayList<MarketRequirement>();
        public List<TerrainRequirement> terrainReqs = new ArrayList<TerrainRequirement>();
        public List<TerrainRequirement> terrainPrefs = new ArrayList<TerrainRequirement>();
        public List<CommodityRequirement> commodityReqs = new ArrayList<CommodityRequirement>();
        public List<CommodityRequirement> commodityPrefs = new ArrayList<CommodityRequirement>();
        List<StarSystemAPI> matchingSystems = null;
        List<StarSystemAPI> preferredSystems = null;
        List<MarketAPI> matchingMarkets = null;
        List<MarketAPI> preferredMarkets = null;
    }

    public static class StarSystemDaysSincePlayerVisitReq
    implements StarSystemRequirement {
        protected float days;

        public StarSystemDaysSincePlayerVisitReq(float days) {
            this.days = days;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result = system.getDaysSinceLastPlayerVisit() >= this.days;
            return result;
        }
    }

    public static class StarSystemHasNumPlanetsAndTerrainReq
    implements StarSystemRequirement {
        protected int num;

        public StarSystemHasNumPlanetsAndTerrainReq(int num) {
            this.num = num;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            int stars = 0;
            if (system.getStar() != null) {
                ++stars;
            }
            if (system.getSecondary() != null) {
                ++stars;
            }
            if (system.getTertiary() != null) {
                ++stars;
            }
            return system.getPlanets().size() - stars + system.getTerrainCopy().size() >= this.num;
        }
    }

    public static class StarSystemHasNumPlanetsReq
    implements StarSystemRequirement {
        protected int num;

        public StarSystemHasNumPlanetsReq(int num) {
            this.num = num;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            int stars = 0;
            if (system.getStar() != null) {
                ++stars;
            }
            if (system.getSecondary() != null) {
                ++stars;
            }
            if (system.getTertiary() != null) {
                ++stars;
            }
            return system.getPlanets().size() - stars >= this.num;
        }
    }

    public static class StarSystemHasNumTerrainReq
    implements StarSystemRequirement {
        protected int num;

        public StarSystemHasNumTerrainReq(int num) {
            this.num = num;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            return system.getTerrainCopy().size() >= this.num;
        }
    }

    public static interface StarSystemRequirement
    extends GenericRequirement {
        public boolean systemMatchesRequirement(StarSystemAPI var1);
    }

    public static class StarSystemUnexploredReq
    implements StarSystemRequirement {
        protected boolean negate = false;

        public StarSystemUnexploredReq() {
            this(false);
        }

        public StarSystemUnexploredReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result;
            boolean bl = result = !system.isEnteredByPlayer();
            if (DebugFlags.ALLOW_VIEW_UNEXPLORED_SYSTEM_MAP) {
                boolean bl2 = result = system.getDaysSinceLastPlayerVisit() >= 100000.0f;
            }
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class StringCollectionReqs {
        public ReqMode mode;
        List<String> tags = new ArrayList<String>();

        public StringCollectionReqs(ReqMode mode, String ... tags) {
            this.mode = mode;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.tags.add(tag);
                ++n2;
            }
        }

        public boolean matchesRequirements(Collection<String> set) {
            switch (this.mode) {
                case ALL: {
                    for (String tag : this.tags) {
                        if (set.contains(tag)) continue;
                        return false;
                    }
                    return true;
                }
                case ANY: {
                    for (String tag : this.tags) {
                        if (!set.contains(tag)) continue;
                        return true;
                    }
                    return false;
                }
                case NOT_ALL: {
                    for (String tag : this.tags) {
                        if (set.contains(tag)) continue;
                        return true;
                    }
                    return false;
                }
                case NOT_ANY: {
                    for (String tag : this.tags) {
                        if (!set.contains(tag)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class SystemHasAtLeastJumpPointsReq
    implements StarSystemRequirement {
        protected int min = 0;

        public SystemHasAtLeastJumpPointsReq(int min) {
            this.min = min;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            return system.getJumpPoints().size() >= this.min;
        }
    }

    public static class SystemHasBaseReq
    implements StarSystemRequirement {
        private String factionId;

        public SystemHasBaseReq(String factionId) {
            this.factionId = factionId;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                if (!this.factionId.equals(market.getFactionId()) || !market.getMemoryWithoutUpdate().getBoolean(MemFlags.HIDDEN_BASE_MEM_FLAG)) continue;
                return true;
            }
            return false;
        }
    }

    public static class SystemHasColonyReq
    implements StarSystemRequirement {
        private String factionId;
        private int minSize;

        public SystemHasColonyReq(String factionId, int minSize) {
            this.factionId = factionId;
            this.minSize = minSize;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                if (!this.factionId.equals(market.getFactionId()) || market.getSize() < this.minSize || market.getMemoryWithoutUpdate().getBoolean(MemFlags.HIDDEN_BASE_MEM_FLAG)) continue;
                return true;
            }
            return false;
        }
    }

    public static class SystemHasPulsarReq
    implements StarSystemRequirement {
        protected boolean negate = false;

        public SystemHasPulsarReq() {
            this(false);
        }

        public SystemHasPulsarReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result = Misc.hasPulsar(system);
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class SystemInDirection
    implements StarSystemRequirement {
        protected float dir;
        protected float arc;
        protected HubMissionWithSearch mission;

        public SystemInDirection(HubMissionWithSearch mission, float dir, float arc) {
            this.mission = mission;
            this.dir = dir;
            this.arc = arc;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            if (this.mission.getPerson() == null) {
                return false;
            }
            if (this.mission.getPerson().getMarket() == null) {
                return false;
            }
            Vector2f from = this.mission.getPerson().getMarket().getLocationInHyperspace();
            return Misc.isInArc(this.dir, this.arc, from, system.getLocation());
        }
    }

    public static class SystemInDirectionFrom
    implements StarSystemRequirement {
        protected Vector2f from;
        protected float dir;
        protected float arc;

        public SystemInDirectionFrom(Vector2f from, float dir, float arc) {
            this.from = from;
            this.dir = dir;
            this.arc = arc;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            return Misc.isInArc(this.dir, this.arc, this.from, system.getLocation());
        }
    }

    public static class SystemInDirectionOfOtherMissionsReq
    implements StarSystemRequirement {
        protected HubMissionWithSearch mission;
        protected float arcMult;

        public SystemInDirectionOfOtherMissionsReq(HubMissionWithSearch mission, float arcMult) {
            this.mission = mission;
            this.arcMult = arcMult;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            return this.mission.matchesSetMissionAngle(system.getLocation(), DEFAULT_MISSION_ARC * this.arcMult, 90.0f);
        }
    }

    public static class SystemInInnerSectorReq
    implements StarSystemRequirement {
        protected float rangeLY = Global.getSettings().getFloat("sectorHeight") / Misc.getUnitsPerLightYear() * INNER_SECTOR_PORTION_OF_HEIGHT * 0.5f;
        protected boolean negate = false;

        public SystemInInnerSectorReq() {
            this(false);
        }

        public SystemInInnerSectorReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result;
            boolean bl = result = Misc.getDistanceLY(new Vector2f(), system.getLocation()) < this.rangeLY;
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class SystemIsBlackHoleReq
    implements StarSystemRequirement {
        protected boolean negate = false;

        public SystemIsBlackHoleReq() {
            this(false);
        }

        public SystemIsBlackHoleReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result;
            boolean bl = result = system.getStar() != null && system.getStar().getSpec().isBlackHole();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class SystemIsNebulaReq
    implements StarSystemRequirement {
        protected boolean negate = false;

        public SystemIsNebulaReq() {
            this(false);
        }

        public SystemIsNebulaReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result = system.isNebula();
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class SystemOnFringeOfSectorReq
    implements StarSystemRequirement {
        protected float rangeLY = Global.getSettings().getFloat("sectorHeight") / Misc.getUnitsPerLightYear() * NON_FRINGE_PORTION_OF_HEIGHT * 0.5f;
        protected boolean negate = false;

        public SystemOnFringeOfSectorReq() {
            this(false);
        }

        public SystemOnFringeOfSectorReq(boolean negate) {
            this.negate = negate;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            boolean result;
            boolean bl = result = Misc.getDistanceLY(new Vector2f(), system.getLocation()) > this.rangeLY;
            if (this.negate) {
                result = !result;
            }
            return result;
        }
    }

    public static class SystemWithinRangeReq
    implements StarSystemRequirement {
        private Vector2f loc;
        private float minRangeLY;
        private float maxRangeLY;

        public SystemWithinRangeReq(Vector2f loc, float minRangeLY, float maxRangeLY) {
            this.loc = loc;
            this.minRangeLY = minRangeLY;
            this.maxRangeLY = maxRangeLY;
        }

        @Override
        public boolean systemMatchesRequirement(StarSystemAPI system) {
            float dist = Misc.getDistanceLY(this.loc, system.getLocation());
            return dist >= this.minRangeLY && dist <= this.maxRangeLY;
        }
    }

    public static class TerrainHasSpecialNameReq
    implements TerrainRequirement {
        @Override
        public boolean terrainMatchesRequirement(CampaignTerrainAPI terrain) {
            String n1 = terrain.getPlugin().getTerrainName();
            String n2 = terrain.getPlugin().getNameForTooltip();
            if (n1 == null) {
                return false;
            }
            return !n1.equals(n2);
        }
    }

    public static class TerrainInDirectionOfOtherMissionsReq
    implements TerrainRequirement {
        protected HubMissionWithSearch mission;
        protected float arcMult;

        public TerrainInDirectionOfOtherMissionsReq(HubMissionWithSearch mission, float arcMult) {
            this.mission = mission;
            this.arcMult = arcMult;
        }

        @Override
        public boolean terrainMatchesRequirement(CampaignTerrainAPI terrain) {
            return this.mission.matchesSetMissionAngle(terrain.getLocationInHyperspace(), DEFAULT_MISSION_ARC * this.arcMult, DEFAULT_MISSION_ARC_BONUS);
        }
    }

    public static interface TerrainRequirement
    extends GenericRequirement {
        public boolean terrainMatchesRequirement(CampaignTerrainAPI var1);
    }

    public static class TerrainTypeReq
    extends StringCollectionReqs
    implements TerrainRequirement {
        public TerrainTypeReq(ReqMode mode, String[] types) {
            super(mode, types);
        }

        @Override
        public boolean terrainMatchesRequirement(CampaignTerrainAPI terrain) {
            HashSet<String> set = new HashSet<String>();
            set.add(terrain.getType());
            return this.matchesRequirements(set);
        }
    }
}

