/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPointProvider;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.SourceBasedFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RemnantStationFleetManager
extends SourceBasedFleetManager {
    protected int minPts;
    protected int maxPts;
    protected int totalLost;
    protected transient RemnantSystemEPGenerator epGen;
    protected transient boolean addedListener = false;

    public RemnantStationFleetManager(SectorEntityToken source, float thresholdLY, int minFleets, int maxFleets, float respawnDelay, int minPts, int maxPts) {
        super(source, thresholdLY, minFleets, maxFleets, respawnDelay);
        this.minPts = minPts;
        this.maxPts = maxPts;
    }

    protected Object readResolve() {
        return this;
    }

    @Override
    public void advance(float amount) {
        if (!this.addedListener) {
            this.epGen = new RemnantSystemEPGenerator();
            Global.getSector().getListenerManager().addListener(this.epGen, true);
            this.addedListener = true;
        }
        super.advance(amount);
    }

    @Override
    protected CampaignFleetAPI spawnFleet() {
        if (this.source == null) {
            return null;
        }
        Random random = new Random();
        int combatPoints = this.minPts + random.nextInt(this.maxPts - this.minPts + 1);
        int bonus = this.totalLost * 4;
        if (bonus > this.maxPts) {
            bonus = this.maxPts;
        }
        String type = "patrolSmall";
        if ((combatPoints += bonus) > 8) {
            type = "patrolMedium";
        }
        if (combatPoints > 16) {
            type = "patrolLarge";
        }
        combatPoints = (int)((float)combatPoints * 8.0f);
        FleetParamsV3 params = new FleetParamsV3(this.source.getMarket(), this.source.getLocationInHyperspace(), "remnant", Float.valueOf(1.0f), type, combatPoints, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null) {
            return null;
        }
        LocationAPI location = this.source.getContainingLocation();
        location.addEntity(fleet);
        RemnantSeededFleetManager.initRemnantFleetProperties(random, fleet, false);
        fleet.setLocation(this.source.getLocation().x, this.source.getLocation().y);
        fleet.setFacing(random.nextFloat() * 360.0f);
        fleet.addScript(new RemnantAssignmentAI(fleet, (StarSystemAPI)this.source.getContainingLocation(), this.source));
        fleet.getMemoryWithoutUpdate().set("$sourceId", this.source.getId());
        return fleet;
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        String sid;
        super.reportFleetDespawnedToListener(fleet, reason, param);
        if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE && (sid = fleet.getMemoryWithoutUpdate().getString("$sourceId")) != null && this.source != null && sid.equals(this.source.getId())) {
            ++this.totalLost;
        }
    }

    public int getTotalLost() {
        return this.totalLost;
    }

    public class RemnantSystemEPGenerator
    implements EncounterPointProvider {
        @Override
        public List<EncounterPoint> generateEncounterPoints(LocationAPI where) {
            if (!where.isHyperspace()) {
                return null;
            }
            if (RemnantStationFleetManager.this.totalLost > 0 && RemnantStationFleetManager.this.source != null) {
                String id = "ep_" + RemnantStationFleetManager.this.source.getId();
                EncounterPoint ep = new EncounterPoint(id, where, RemnantStationFleetManager.this.source.getLocationInHyperspace(), EncounterManager.EP_TYPE_OUTSIDE_SYSTEM);
                ep.custom = this;
                ArrayList<EncounterPoint> result = new ArrayList<EncounterPoint>();
                result.add(ep);
                return result;
            }
            return null;
        }
    }
}

