/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.OpenMarketPlugin;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.apache.log4j.Logger;

public class MilitarySubmarketPlugin
extends BaseSubmarketPlugin {
    public static Logger log = Global.getLogger(MilitarySubmarketPlugin.class);
    private RepLevel minStanding = RepLevel.FAVORABLE;

    @Override
    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    @Override
    public void updateCargoPrePlayerInteraction() {
        float seconds = Global.getSector().getClock().convertToSeconds(this.sinceLastCargoUpdate);
        this.addAndRemoveStockpiledResources(seconds, false, true, true);
        this.sinceLastCargoUpdate = 0.0f;
        if (this.okToUpdateShipsAndWeapons()) {
            this.sinceSWUpdate = 0.0f;
            this.pruneWeapons(0.0f);
            int weapons = 7 + Math.max(0, this.market.getSize() - 1) * 2;
            int fighters = 2 + Math.max(0, this.market.getSize() - 3);
            this.addWeapons(weapons, weapons + 2, 3, this.submarket.getFaction().getId());
            this.addFighters(fighters, fighters + 2, 3, this.market.getFactionId());
            float stability = this.market.getStabilityValue();
            float sMult = Math.max(0.1f, stability / 10.0f);
            this.getCargo().getMothballedShips().clear();
            int size = this.submarket.getFaction().getDoctrine().getShipSize();
            int add = 0;
            if (stability <= 4.0f) {
                add = 2;
            } else if (stability <= 6.0f) {
                add = 1;
            }
            if ((size += add) > 5) {
                size = 5;
            }
            FactionDoctrineAPI doctrineOverride = this.submarket.getFaction().getDoctrine().clone();
            doctrineOverride.setShipSize(size);
            this.addShips(this.submarket.getFaction().getId(), 200.0f * sMult, 15.0f, 10.0f, 20.0f, 10.0f, 10.0f, null, 0.0f, null, doctrineOverride);
            this.addHullMods(4, 2 + this.itemGenRandom.nextInt(4), this.submarket.getFaction().getId());
        }
        this.getCargo().sort();
    }

    protected Object writeReplace() {
        if (this.okToUpdateShipsAndWeapons()) {
            this.pruneWeapons(0.0f);
            this.getCargo().getMothballedShips().clear();
        }
        return this;
    }

    @Override
    public String getName() {
        if (this.submarket.getFaction().getId().equals("luddic_church")) {
            return "Knights of Ludd";
        }
        return String.valueOf(Misc.ucFirst(this.submarket.getFaction().getPersonNamePrefix())) + "\n" + "Military";
    }

    protected boolean requiresCommission(RepLevel req) {
        if (!this.submarket.getFaction().getCustomBoolean("offersCommissions")) {
            return false;
        }
        return req.isAtWorst(RepLevel.WELCOMING);
    }

    protected boolean hasCommission() {
        return this.submarket.getFaction().getId().equals(Misc.getCommissionFactionId());
    }

    @Override
    public boolean shouldHaveCommodity(CommodityOnMarketAPI com) {
        if ("crew".equals(com.getId())) {
            return true;
        }
        return com.getCommodity().hasTag("military");
    }

    @Override
    public int getStockpileLimit(CommodityOnMarketAPI com) {
        float limit = OpenMarketPlugin.getBaseStockpileLimit(com);
        Random random = new Random(this.market.getId().hashCode() + this.submarket.getSpecId().hashCode() + Global.getSector().getClock().getMonth() * 170000);
        limit *= 0.9f + 0.2f * random.nextFloat();
        float sm = this.market.getStabilityValue() / 10.0f;
        if ((limit *= 0.25f + 0.75f * sm) < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    @Override
    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        boolean illegal = this.market.isIllegal(commodityId);
        RepLevel req = this.getRequiredLevelAssumingLegal(commodityId, action);
        if (req == null) {
            return illegal;
        }
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        boolean legal = level.isAtWorst(req);
        if (this.requiresCommission(req)) {
            legal &= this.hasCommission();
        }
        return !legal;
    }

    @Override
    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (stack.isCommodityStack()) {
            return this.isIllegalOnSubmarket((String)stack.getData(), action);
        }
        RepLevel req = this.getRequiredLevelAssumingLegal(stack, action);
        if (req == null) {
            return false;
        }
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        boolean legal = level.isAtWorst(req);
        if (this.requiresCommission(req)) {
            legal &= this.hasCommission();
        }
        return !legal;
    }

    @Override
    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        RepLevel req = this.getRequiredLevelAssumingLegal(stack, action);
        if (req != null) {
            if (this.requiresCommission(req)) {
                return "Req: " + this.submarket.getFaction().getDisplayName() + " - " + req.getDisplayName().toLowerCase() + ", " + " commission";
            }
            return "Req: " + this.submarket.getFaction().getDisplayName() + " - " + req.getDisplayName().toLowerCase();
        }
        return "Illegal to trade in " + stack.getDisplayName() + " here";
    }

    @Override
    public Highlights getIllegalTransferTextHighlights(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        RepLevel req = this.getRequiredLevelAssumingLegal(stack, action);
        if (req != null) {
            Color c = Misc.getNegativeHighlightColor();
            Highlights h = new Highlights();
            RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
            if (!level.isAtWorst(req)) {
                h.append(String.valueOf(this.submarket.getFaction().getDisplayName()) + " - " + req.getDisplayName().toLowerCase(), c);
            }
            if (this.requiresCommission(req) && !this.hasCommission()) {
                h.append("commission", c);
            }
            return h;
        }
        return null;
    }

    private RepLevel getRequiredLevelAssumingLegal(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        int tier = -1;
        if (stack.isWeaponStack()) {
            WeaponSpecAPI spec = stack.getWeaponSpecIfWeapon();
            tier = spec.getTier();
        } else if (stack.isModSpecStack()) {
            HullModSpecAPI spec = stack.getHullModSpecIfHullMod();
            tier = spec.getTier();
        } else if (stack.isFighterWingStack()) {
            FighterWingSpecAPI spec = stack.getFighterWingSpecIfWing();
            tier = spec.getTier();
        }
        if (tier >= 0) {
            if (action == SubmarketPlugin.TransferAction.PLAYER_BUY) {
                switch (tier) {
                    case 0: {
                        return RepLevel.FAVORABLE;
                    }
                    case 1: {
                        return RepLevel.WELCOMING;
                    }
                    case 2: {
                        return RepLevel.FRIENDLY;
                    }
                    case 3: {
                        return RepLevel.COOPERATIVE;
                    }
                }
            }
            return RepLevel.VENGEFUL;
        }
        if (!stack.isCommodityStack()) {
            return null;
        }
        return this.getRequiredLevelAssumingLegal((String)stack.getData(), action);
    }

    private RepLevel getRequiredLevelAssumingLegal(String commodityId, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL) {
            return RepLevel.VENGEFUL;
        }
        CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
        boolean isMilitary = com.getCommodity().getTags().contains("military");
        if (isMilitary) {
            if (com.isPersonnel()) {
                return RepLevel.COOPERATIVE;
            }
            return RepLevel.FAVORABLE;
        }
        return null;
    }

    @Override
    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_SELL && Misc.isAutomated(member)) {
            return true;
        }
        RepLevel req = this.getRequiredLevelAssumingLegal(member, action);
        if (req == null) {
            return false;
        }
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        boolean legal = level.isAtWorst(req);
        if (this.requiresCommission(req)) {
            legal &= this.hasCommission();
        }
        return !legal;
    }

    @Override
    public String getIllegalTransferText(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        RepLevel req = this.getRequiredLevelAssumingLegal(member, action);
        if (req != null) {
            String str = "";
            RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
            if (!level.isAtWorst(req)) {
                str = String.valueOf(str) + "Req: " + this.submarket.getFaction().getDisplayName() + " - " + req.getDisplayName().toLowerCase();
            }
            if (this.requiresCommission(req) && !this.hasCommission()) {
                if (!str.isEmpty()) {
                    str = String.valueOf(str) + "\n";
                }
                str = String.valueOf(str) + "Req: " + this.submarket.getFaction().getDisplayName() + " - " + "commission";
            }
            return str;
        }
        if (action == SubmarketPlugin.TransferAction.PLAYER_BUY) {
            return "Illegal to buy";
        }
        return "Illegal to sell";
    }

    @Override
    public Highlights getIllegalTransferTextHighlights(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (this.isIllegalOnSubmarket(member, action)) {
            return null;
        }
        RepLevel req = this.getRequiredLevelAssumingLegal(member, action);
        if (req != null) {
            Color c = Misc.getNegativeHighlightColor();
            Highlights h = new Highlights();
            RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
            if (!level.isAtWorst(req)) {
                h.append("Req: " + this.submarket.getFaction().getDisplayName() + " - " + req.getDisplayName().toLowerCase(), c);
            }
            if (this.requiresCommission(req) && !this.hasCommission()) {
                h.append("Req: " + this.submarket.getFaction().getDisplayName() + " - commission", c);
            }
            return h;
        }
        return null;
    }

    private RepLevel getRequiredLevelAssumingLegal(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_BUY) {
            int fp = member.getFleetPointCost();
            ShipAPI.HullSize size = member.getHullSpec().getHullSize();
            if (size == ShipAPI.HullSize.CAPITAL_SHIP || fp > 15) {
                return RepLevel.COOPERATIVE;
            }
            if (size == ShipAPI.HullSize.CRUISER || fp > 10) {
                return RepLevel.FRIENDLY;
            }
            if (size == ShipAPI.HullSize.DESTROYER || fp > 5) {
                return RepLevel.WELCOMING;
            }
            return RepLevel.FAVORABLE;
        }
        return null;
    }

    @Override
    public boolean isEnabled(CoreUIAPI ui) {
        if (ui.getTradeMode() == CampaignUIAPI.CoreUITradeMode.SNEAK) {
            return false;
        }
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        return level.isAtWorst(this.minStanding);
    }

    @Override
    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
    }

    @Override
    public String getTooltipAppendix(CoreUIAPI ui) {
        if (!this.isEnabled(ui)) {
            return "Requires: " + this.submarket.getFaction().getDisplayName() + " - " + this.minStanding.getDisplayName().toLowerCase();
        }
        if (ui.getTradeMode() == CampaignUIAPI.CoreUITradeMode.SNEAK) {
            return "Requires: proper docking authorization";
        }
        return null;
    }

    @Override
    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        String appendix = this.getTooltipAppendix(ui);
        if (appendix == null) {
            return null;
        }
        Highlights h = new Highlights();
        h.setText(appendix);
        h.setColors(Misc.getNegativeHighlightColor());
        return h;
    }

    @Override
    public SubmarketPlugin.PlayerEconomyImpactMode getPlayerEconomyImpactMode() {
        return SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_SELL_ONLY;
    }

    @Override
    public boolean isMilitaryMarket() {
        return true;
    }
}

