/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class StarCoronaAkaMainyuTerrainPlugin
extends StarCoronaTerrainPlugin {
    public static final float ARC = 100.0f;

    @Override
    public float getAuroraAlphaMultForAngle(float angle) {
        SectorEntityToken star = this.params.relatedEntity.getLightSource();
        if (star != null) {
            float max;
            float toStar = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), star.getLocation());
            float diff = Misc.getAngleDiff(toStar, angle);
            if (diff < (max = 50.0f)) {
                return Math.max(0.0f, 1.0f - diff / max);
            }
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public Color getAuroraColorForAngle(float angle) {
        if (this.color == null) {
            this.color = this.params.relatedEntity instanceof PlanetAPI ? ((PlanetAPI)this.params.relatedEntity).getSpec().getAtmosphereColor() : Color.white;
            this.color = Misc.setAlpha(this.color, 155);
        }
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getColorForAngle(this.color, angle);
        }
        return super.getAuroraColorForAngle(angle);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        float toStar;
        SectorEntityToken star = this.params.relatedEntity.getLightSource();
        if (star != null && !Misc.isInArc(toStar = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), star.getLocation()), 100.0f, this.params.relatedEntity.getLocation(), point)) {
            return false;
        }
        return super.containsPoint(point, radius);
    }

    @Override
    public String getTerrainName() {
        return "Ion Storm";
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        tooltip.addTitle("Ion Storm");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, small);
            nextPad = small;
        }
        tooltip.addPara("The intense heat and radiation reduce the combat readiness of all ships in the magnetotail at a steady pace.", nextPad);
        tooltip.addPara("The ionized gas being ejected from the atmosphere makes the planet difficult to approach.", pad);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Reduces the peak performance time of ships and increases the rate of combat readiness degradation in protracted engagements.", small);
        }
    }
}

