/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class ZigLeashAssignmentAI
extends BaseAssignmentAI {
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;
    protected SectorEntityToken toGuard;
    protected IntervalUtil moteSpawn = new IntervalUtil(0.01f, 0.1f);

    public ZigLeashAssignmentAI(CampaignFleetAPI fleet, SectorEntityToken toGuard) {
        this.fleet = fleet;
        this.toGuard = toGuard;
        this.giveInitialAssignments();
    }

    @Override
    protected void giveInitialAssignments() {
        this.pickNext();
    }

    @Override
    protected void pickNext() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.toGuard, 100.0f);
    }

    @Override
    public void advance(float amount) {
        float dist;
        super.advance(amount);
        if (this.toGuard != null && (dist = Misc.getDistance(this.fleet.getLocation(), this.toGuard.getLocation())) > this.toGuard.getRadius() + this.fleet.getRadius() + 1500.0f && this.fleet.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_AGGRESSIVE) {
            this.fleet.addAssignmentAtStart(FleetAssignment.ORBIT_PASSIVE, this.toGuard, 1.0f, null);
            CampaignFleetAIAPI ai = this.fleet.getAI();
            if (ai instanceof ModularFleetAIAPI) {
                ModularFleetAIAPI m = (ModularFleetAIAPI)ai;
                m.getStrategicModule().getDoNotAttack().add(m.getTacticalModule().getTarget(), 1.0f);
                m.getTacticalModule().setTarget(null);
            }
        }
        float days = Misc.getDays(amount);
        this.moteSpawn.advance(days * 1.0f);
        if (this.moteSpawn.intervalElapsed()) {
            ZigLeashAssignmentAI.spawnMote(this.fleet);
        }
    }

    public static void spawnMote(SectorEntityToken from) {
        if (!from.isInCurrentLocation()) {
            return;
        }
        float dur = 1.0f + 2.0f * (float)Math.random();
        dur *= 2.0f;
        float size = 3.0f + (float)Math.random() * 5.0f;
        size *= 3.0f;
        Color color = new Color(255, 100, 255, 175);
        Vector2f loc = Misc.getPointWithinRadius(from.getLocation(), from.getRadius());
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        vel.scale(5.0f + (float)Math.random() * 10.0f);
        Vector2f.add((Vector2f)vel, (Vector2f)from.getVelocity(), (Vector2f)vel);
        Misc.addGlowyParticle(from.getContainingLocation(), loc, vel, size, 0.5f, dur, color);
    }
}

