/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.FighterLaunchBayAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class ReserveWingStats
extends BaseShipSystemScript {
    public static String RD_NO_EXTRA_CRAFT = "rd_no_extra_craft";
    public static String RD_FORCE_EXTRA_CRAFT = "rd_force_extra_craft";
    public static float EXTRA_FIGHTER_DURATION = 30.0f;
    public static float RATE_COST = 0.0f;
    public static float RATE_COST_1_BAY = 0.0f;

    public static float getRateCost(int bays) {
        if (bays <= 1) {
            return RATE_COST_1_BAY;
        }
        return RATE_COST;
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (effectLevel == 1.0f) {
            float minRate = Global.getSettings().getFloat("minFighterReplacementRate");
            int bays = ship.getLaunchBaysCopy().size();
            float cost = ReserveWingStats.getRateCost(bays);
            for (FighterLaunchBayAPI bay : ship.getLaunchBaysCopy()) {
                if (bay.getWing() == null) continue;
                float rate = Math.max(minRate, bay.getCurrRate() - cost);
                bay.setCurrRate(rate);
                bay.makeCurrentIntervalFast();
                FighterWingSpecAPI spec = bay.getWing().getSpec();
                int addForWing = ReserveWingStats.getAdditionalFor(spec, bays);
                int maxTotal = spec.getNumFighters() + addForWing;
                int actualAdd = maxTotal - bay.getWing().getWingMembers().size();
                if (actualAdd <= 0) continue;
                bay.setFastReplacements(bay.getFastReplacements() + addForWing);
                bay.setExtraDeployments(actualAdd);
                bay.setExtraDeploymentLimit(maxTotal);
                bay.setExtraDuration(EXTRA_FIGHTER_DURATION);
            }
        }
    }

    public static int getAdditionalFor(FighterWingSpecAPI spec, int bays) {
        if (spec.hasTag(RD_NO_EXTRA_CRAFT)) {
            return 0;
        }
        int size = spec.getNumFighters();
        return size;
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    @Override
    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        return true;
    }
}

