/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.CombatTaskManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.List;

public class DwellerCombatStrategyAI {
    public static float SND_BASE = 60.0f;
    public static float SND_TIMER = 60.0f;
    public static float SND_FRACTION = 0.5f;
    protected boolean playerSide;
    protected CombatTaskManagerAPI taskManager;
    protected CombatFleetManagerAPI fleetManager;
    protected CombatFleetManagerAPI enemyFleetManager;
    protected int owner;
    protected boolean allyMode = false;
    protected IntervalUtil everySecond = new IntervalUtil(0.8f, 1.2f);
    protected CombatEngineAPI engine = Global.getCombatEngine();
    protected float mw;
    protected float mh;
    protected boolean abort = false;
    protected CombatFleetManagerAPI.AssignmentInfo mainDefend1;
    protected CombatFleetManagerAPI.AssignmentInfo mainDefend2;
    protected boolean gaveInitialOrders = false;

    public DwellerCombatStrategyAI(int owner) {
        this.owner = owner;
        this.allyMode = this.playerSide = owner == 0;
        this.fleetManager = this.engine.getFleetManager(owner);
        this.taskManager = this.fleetManager.getTaskManager(this.allyMode);
        this.taskManager.getCommandPointsStat().modifyFlat("DwellerCombatStrategyAI", 1.0E9f);
        this.enemyFleetManager = this.engine.getFleetManager(owner == 0 ? 1 : 0);
        if (this.fleetManager.getGoal() == FleetGoal.ESCAPE || this.enemyFleetManager.getGoal() == FleetGoal.ESCAPE) {
            this.abort = true;
        } else if (this.fleetManager.getAdmiralAI() != null) {
            this.taskManager.clearTasks();
            this.fleetManager.getAdmiralAI().setNoOrders(true);
        }
        this.mw = this.engine.getMapWidth();
        this.mh = this.engine.getMapHeight();
    }

    protected void giveInitialOrders() {
    }

    public void advance(float amount) {
        if (this.abort) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.everySecond.advance(amount);
        if (this.everySecond.intervalElapsed()) {
            List<DeployedFleetMemberAPI> deployed = this.fleetManager.getDeployedCopyDFM();
            if (deployed.isEmpty()) {
                return;
            }
            boolean someMatching = false;
            for (DeployedFleetMemberAPI member : deployed) {
                if (!member.isFighterWing() && member.getShip() != null && member.isAlly() == this.allyMode && !member.getShip().getVariant().hasHullMod("dweller_hullmod")) {
                    this.abort = true;
                    return;
                }
                if (member.isFighterWing() || member.getShip() == null || member.isAlly() != this.allyMode) continue;
                someMatching = true;
            }
            if (!someMatching) {
                return;
            }
            if (!this.gaveInitialOrders) {
                this.giveInitialOrders();
                this.gaveInitialOrders = true;
            }
            for (DeployedFleetMemberAPI member : this.fleetManager.getDeployedCopyDFM()) {
                CombatFleetManagerAPI.AssignmentInfo curr;
                ShipAPI ship = member.getShip();
                if (ship == null || ship.getAI() == null) continue;
                if (DwellerCombatStrategyAI.isMaw(ship)) {
                    curr = this.taskManager.getAssignmentInfoForTarget(member);
                    if (curr != null) continue;
                    this.taskManager.createAssignment(CombatAssignmentType.DEFEND, member, false);
                    this.taskManager.orderSearchAndDestroy(member, false);
                    continue;
                }
                if (DwellerCombatStrategyAI.isEye(ship)) {
                    curr = this.taskManager.getAssignmentInfoForTarget(member);
                    if (curr != null) continue;
                    this.taskManager.createAssignment(CombatAssignmentType.HEAVY_ESCORT, member, false);
                    this.taskManager.orderSearchAndDestroy(member, false);
                    continue;
                }
                DwellerCombatStrategyAI.isStinger(ship);
            }
            this.cleanUpEmptyAssignments();
        }
    }

    protected void cancelOrders(DeployedFleetMemberAPI member, boolean withSearchAndDestroy) {
        CombatFleetManagerAPI.AssignmentInfo curr = this.taskManager.getAssignmentFor(member.getShip());
        if (curr != null) {
            this.taskManager.removeAssignment(curr);
        }
        if (withSearchAndDestroy) {
            this.taskManager.orderSearchAndDestroy(member, false);
        }
    }

    public void cleanUpEmptyAssignments() {
        this.taskManager.reassign();
        ArrayList<CombatFleetManagerAPI.AssignmentInfo> remove = new ArrayList<CombatFleetManagerAPI.AssignmentInfo>();
        for (CombatFleetManagerAPI.AssignmentInfo curr : this.taskManager.getAllAssignments()) {
            if (curr.getType() == CombatAssignmentType.CONTROL || curr.getType() == CombatAssignmentType.CAPTURE || curr.getType() == CombatAssignmentType.DEFEND || !curr.getAssignedMembers().isEmpty()) continue;
            remove.add(curr);
        }
        for (CombatFleetManagerAPI.AssignmentInfo curr : remove) {
            this.taskManager.removeAssignment(curr);
        }
        this.taskManager.clearEmptyWaypoints();
    }

    public static boolean isMaw(ShipAPI ship) {
        boolean isMaw = ship != null && ship.isCapital();
        return isMaw;
    }

    public static boolean isEye(ShipAPI ship) {
        boolean isEye = ship != null && ship.isCruiser() && ship.getHullSpec().hasTag("dweller_reckless");
        return isEye;
    }

    public static boolean isStinger(ShipAPI ship) {
        boolean isEye = ship != null && ship.isCruiser() && ship.getHullSpec().hasTag("dweller_timid");
        return isEye;
    }

    public static boolean isTendril(ShipAPI ship) {
        boolean isTendril = ship != null && ship.isDestroyer();
        return isTendril;
    }
}

