/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedMawShipCreator
extends BaseDwellerShipCreator
implements DwellerCombatPlugin.DCPPlugin {
    @Override
    protected DwellerCombatPlugin createPlugin(ShipAPI ship) {
        DwellerCombatPlugin plugin = super.createPlugin(ship);
        plugin.setPlugin(this);
        List<DwellerShipPart> parts = plugin.getParts();
        parts.clear();
        float scale = 2.0f;
        float xOff = 40.0f * scale;
        xOff = 0.0f;
        DwellerCombatPlugin.WobblyPart part = new DwellerCombatPlugin.WobblyPart("shrouded_maw_base", 1.0f * scale, 0.7f, new Vector2f(xOff, 0.0f), 0.0f);
        parts.add(part);
        Color glow = DwellerCombatPlugin.STANDARD_PART_GLOW_COLOR;
        xOff = 30.0f * scale;
        part = new DwellerCombatPlugin.WobblyPart("shrouded_maw_glow", 0.5f * scale, 5, 5, 0.5f, new Vector2f(xOff, 0.0f), 0.0f);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_spot_cluster", 1.0f * scale, 5, 5, 1.0f, new Vector2f(-25.0f * scale + xOff, 0.0f), 0.0f);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        return plugin;
    }

    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.initBeforeShipCreation(hullSize, stats, id);
        stats.getEnergyWeaponRangeBonus().modifyPercent(id, 100.0f);
        stats.getMissileWeaponRangeBonus().modifyFlat(id, 400.0f);
    }

    @Override
    protected DwellerShroud createShroud(ShipAPI ship) {
        DwellerShroud shroud = super.createShroud(ship);
        shroud.getShroudParams().negativeParticleFilter = new DwellerShroud.ShroudNegativeParticleFilter(){

            @Override
            public boolean isParticleOk(DwellerShroud shroud, Vector2f loc) {
                float facing = shroud.getAttachedTo().getFacing();
                Vector2f diff = Vector2f.sub((Vector2f)loc, (Vector2f)shroud.getAttachedTo().getLocation(), (Vector2f)new Vector2f());
                diff = Misc.rotateAroundOrigin(diff, -facing);
                return Math.abs(diff.x) < shroud.getParams().maxOffset * 0.75f;
            }
        };
        return shroud;
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
        params.maxOffset = 400.0f;
        params.baseMembersToMaintain = params.initialMembers = 250;
        params.numToRespawn = 5;
        params.numToFlash *= 3;
        params.spawnOffsetMultForInitialSpawn = params.spawnOffsetMult = 0.67f;
        params.baseSpriteSize *= 2.0f;
        params.negativeParticleAreaMult = 0.9f;
        params.negativeParticleSizeMult = 0.9f;
        params.overloadGlowSizeMult *= 2.0f;
        params.overloadArcThickness *= 2.0f;
        params.overloadArcCoreThickness *= 2.0f;
        params.offsetModifier = new RoilingSwarmEffect.SwarmMemberOffsetModifier(){

            @Override
            public void modifyOffset(RoilingSwarmEffect.SwarmMember p) {
                p.offset.x *= 0.75f;
            }
        };
    }

    @Override
    public void advance(DwellerCombatPlugin plugin, float amount) {
        CombatEntityAPI attachedTo = plugin.getAttachedTo();
        if (attachedTo instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)attachedTo;
            ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF, 1.0f);
        }
    }
}

