/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.BaseEnergyLashActivatedSystem;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class ExtractionProtocolSystemScript
extends BaseEnergyLashActivatedSystem {
    public static float SPEED_BONUS = 100.0f;
    protected boolean vented = false;

    @Override
    public void applyImpl(ShipAPI ship, MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        stats.getMaxSpeed().modifyFlat(id, SPEED_BONUS * effectLevel);
        stats.getAcceleration().modifyFlat(id, 2.0f * SPEED_BONUS * effectLevel);
        stats.getDeceleration().modifyFlat(id, 2.0f * SPEED_BONUS * effectLevel);
        ship.getEngineController().extendFlame(ship.getSystem(), 0.01f * effectLevel, 0.0f * effectLevel, 1.0f * effectLevel);
        if (effectLevel <= 0.0f) {
            return;
        }
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF, 1.0f);
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT, 1.0f);
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE, 10000.0f);
        ship.getAIFlags().unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF);
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE) {
            this.vented = false;
            this.makeAllGroupsAutofireOneFrame(ship);
        }
        if (state == ShipSystemStatsScript.State.OUT && !this.vented) {
            ship.giveCommand(ShipCommand.VENT_FLUX, null, 0);
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (w.isDecorative() || w.getSlot().isSystemSlot() || !w.usesAmmo() || w.getAmmo() >= w.getMaxAmmo()) continue;
                w.setAmmo(w.getMaxAmmo());
            }
        }
        this.setStandardJitter(ship, state, effectLevel);
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (effectLevel <= 0.0f) {
            return null;
        }
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("improved maneuverability", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("+" + (int)SPEED_BONUS + " top speed", false);
        }
        return null;
    }

    @Override
    public float getCurrentUsefulnessLevel(ShipAPI overseer, ShipAPI ship) {
        ShipAPI target;
        if (ship.getSystem().isActive() || ship.getSystem().isChargedown() || ship.getSystem().isChargeup() || ship.getSystem().isCoolingDown()) {
            return 0.0f;
        }
        float level = ship.getFluxLevel();
        float needAmmo = 0.0f;
        float useAmmo = 0.0f;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.isDecorative() || w.getSlot().isSystemSlot() || !w.usesAmmo()) continue;
            float op = w.getSpec().getOrdnancePointCost(null);
            useAmmo += op;
            if (w.getAmmo() >= w.getMaxAmmo() || w.getMaxAmmo() <= 0 || !(w.getAmmoPerSecond() > 0.0f)) continue;
            needAmmo += (1.0f - (float)w.getAmmo() / (float)w.getMaxAmmo()) * op;
        }
        if (useAmmo > 0.0f && (level += 0.25f * needAmmo / useAmmo) > 1.0f) {
            level = 1.0f;
        }
        float threshold = 0.7f;
        Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        if (test instanceof ShipAPI && (target = (ShipAPI)test).getFluxLevel() > ship.getFluxLevel()) {
            threshold = 0.9f;
        }
        if (ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) && level > threshold) {
            return (level - threshold) / (1.0f - threshold);
        }
        return 0.0f;
    }
}

