/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.combat.threat.DisposableThreatFleetManager;
import com.fs.starfarer.api.util.Misc;

public class ThreatFleetBehaviorScript
implements EveryFrameScript {
    public static float MIN_SECONDS_TO_PURSUE_AFTER_SEEN_BY_PLAYER = 30.0f;
    public static float MAX_SECONDS_TO_PURSUE_AFTER_SEEN_BY_PLAYER = 120.0f;
    protected StarSystemAPI system;
    protected CampaignFleetAPI fleet;
    protected DisposableFleetManager manager;
    protected float seenByPlayerTimeout = 0.0f;

    public ThreatFleetBehaviorScript(CampaignFleetAPI fleet, StarSystemAPI system) {
        this.fleet = fleet;
        this.system = system;
        this.pickNext();
    }

    protected void pickNext() {
        float distFromPlayer;
        CampaignFleetAPI player;
        float days = 1.0f + 1.0f * (float)Math.random();
        SectorEntityToken target = this.system.createToken(0.0f, 0.0f);
        float distFromTarget = Misc.getDistance(this.fleet, target);
        if (distFromTarget < 7000.0f) {
            target = null;
        }
        if ((player = Global.getSector().getPlayerFleet()) != null && (distFromPlayer = Misc.getDistance(this.fleet, player)) < 4000.0f) {
            target = null;
        }
        this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, target, days, "cruising");
    }

    @Override
    public void advance(float amount) {
        boolean visibleToPlayer;
        if (this.fleet.getCurrentAssignment() == null) {
            this.pickNext();
        }
        this.seenByPlayerTimeout -= amount;
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        boolean playerHasSensorMods = Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DisposableThreatFleetManager.SENSOR_MODS_KEY);
        if (playerHasSensorMods) {
            this.fleet.getStats().getDynamic().getStat("detected_by_player_range_mult").modifyMult(DisposableThreatFleetManager.THREAT_DETECTED_RANGE_MULT_ID, DisposableThreatFleetManager.ONSLAUGHT_MKI_SENSOR_MODIFICATIONS_RANGE_MULT);
        } else {
            this.fleet.getStats().getDynamic().getStat("detected_by_player_range_mult").unmodifyMult(DisposableThreatFleetManager.THREAT_DETECTED_RANGE_MULT_ID);
        }
        boolean bl = visibleToPlayer = this.fleet.isVisibleToPlayerFleet() && player.isVisibleToSensorsOf(this.fleet);
        if (!Global.getSettings().isCampaignSensorsOn() && this.fleet.isInCurrentLocation()) {
            float dist = Misc.getDistance(this.fleet, player);
            dist -= this.fleet.getRadius() + player.getRadius();
            if (playerHasSensorMods) {
                dist /= DisposableThreatFleetManager.ONSLAUGHT_MKI_SENSOR_MODIFICATIONS_RANGE_MULT;
            }
            boolean asb = player.getAbility("sensor_burst") != null && player.getAbility("sensor_burst").isActive();
            boolean bl2 = visibleToPlayer = dist < 150.0f || asb && dist < 500.0f;
        }
        if (visibleToPlayer) {
            this.setSeenByPlayer();
        }
        if (this.seenByPlayerTimeout > 0.0f) {
            visibleToPlayer = true;
        }
        if (!visibleToPlayer) {
            if (this.fleet.getAI() instanceof ModularFleetAIAPI) {
                ModularFleetAIAPI ai = (ModularFleetAIAPI)this.fleet.getAI();
                int i = 0;
                while (i < 3) {
                    ai.getNavModule().avoidEntity(player, 3000.0f, 5000.0f, 0.2f);
                    ++i;
                }
                this.fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", false);
                this.fleet.getMemoryWithoutUpdate().set("$cfai_makeNonHostile", true);
            }
        } else {
            this.fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", true);
            this.fleet.getMemoryWithoutUpdate().set("$cfai_makeNonHostile", false);
        }
    }

    public void setSeenByPlayer() {
        this.seenByPlayerTimeout = MIN_SECONDS_TO_PURSUE_AFTER_SEEN_BY_PLAYER + (MAX_SECONDS_TO_PURSUE_AFTER_SEEN_BY_PLAYER - MIN_SECONDS_TO_PURSUE_AFTER_SEEN_BY_PLAYER) * (float)Math.random();
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

