/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.BaseFragmentMissileEffect;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import java.awt.Color;

public class UnstableFragmentMissileEffect
extends BaseFragmentMissileEffect {
    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        super.onFire(projectile, weapon, engine);
    }

    @Override
    protected void configureMissileSwarmParams(RoilingSwarmEffect.RoilingSwarmParams params) {
        params.flashFringeColor = new Color(255, 50, 50, 255);
        params.flashCoreColor = Color.white;
        params.flashRadius = 100.0f;
    }

    @Override
    protected int getNumOtherMembersToTransfer() {
        return 0;
    }

    @Override
    protected int getEMPResistance() {
        return 0;
    }

    @Override
    protected boolean explodeOnFizzling() {
        return false;
    }

    @Override
    protected boolean makePrimaryFragmentGlow() {
        return false;
    }

    @Override
    protected RoilingSwarmEffect.SwarmMember pickPrimaryFragment() {
        GuidedMissileAI ai;
        if (this.missile.getAI() instanceof GuidedMissileAI && (ai = (GuidedMissileAI)this.missile.getAI()).getTarget() != null) {
            return this.pickOuterFragmentWithinRangeClosestTo(150.0f, ai.getTarget().getLocation());
        }
        return super.pickPrimaryFragment();
    }

    @Override
    protected void swarmAdvance(float amount, MissileAPI missile, RoilingSwarmEffect swarm) {
        if (swarm.custom1 == null) {
            swarm.custom1 = Global.getCombatEngine().createProximityFuseAI(missile);
        }
        ((MissileAIPlugin)swarm.custom1).advance(amount);
        if (!swarm.members.isEmpty()) {
            RoilingSwarmEffect.SwarmMember primary = swarm.members.get(0);
            if (primary.flash == null) {
                primary.flash();
                primary.flash.setDuration(0.25f, 0.75f);
                primary.flash.setBounce(true, true);
            }
        }
    }
}

