/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class FlickerUtil {
    private float angle;
    private float brightness;
    private float currTime;
    private float currMaxBurstTime;
    private float currMaxBrightness;
    private float maxBurstTime = 0.5f;
    private float peakTime;
    private float peakDur;
    private boolean stop = false;

    public FlickerUtil() {
        this.newBurst();
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    private void newBurst() {
        if (this.stop) {
            this.brightness = 0.0f;
            return;
        }
        this.currMaxBurstTime = this.maxBurstTime * 0.25f + (float)Math.random() * this.maxBurstTime * 0.75f;
        this.currMaxBrightness = (float)Math.random() * 0.5f + 0.75f;
        if (this.currMaxBrightness > 1.0f) {
            this.currMaxBrightness = 1.0f;
        }
        this.peakTime = 0.0f;
        this.peakDur = this.currMaxBurstTime / 20.0f;
        this.currTime = 0.0f;
        this.angle = (float)Math.random() * 360.0f;
        this.brightness = 1.0f;
    }

    public float getBrightness() {
        return this.brightness * this.currMaxBrightness;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean advance(float amount) {
        this.currTime += amount;
        if (this.currTime > this.currMaxBurstTime) {
            this.newBurst();
            return true;
        }
        if (this.currTime > this.peakTime + this.peakDur) {
            this.brightness -= amount / Math.max(0.1f, 0.25f - this.peakTime - this.peakDur);
            if (this.brightness < 0.0f) {
                this.brightness = 0.0f;
            }
        } else {
            this.brightness = 1.0f;
        }
        return false;
    }

    public float getCurrTime() {
        return this.currTime;
    }
}

