/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ShroudedSubstratePlugin
extends BaseSpecialItemPlugin {
    public static String PLAYER_CAN_MAKE_WEAPONS = "$canMakeDwellerWeapons";
    public static String SHROUDED_SUBSTRATE_AVAILABLE = "$shroudedSubstrateAvailable";

    public static boolean isPlayerCanMakeWeapons() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PLAYER_CAN_MAKE_WEAPONS);
    }

    public static void setPlayerCanMakeWeapons() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(PLAYER_CAN_MAKE_WEAPONS, true);
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        if (!Global.CODEX_TOOLTIP_MODE) {
            tooltip.addTitle(this.getName());
        } else {
            tooltip.addSpacer(-opad);
        }
        String design = this.getDesignType();
        if (design != null) {
            Misc.addDesignTypePara(tooltip, design, 10.0f);
        }
        if (!this.spec.getDesc().isEmpty()) {
            if (Global.CODEX_TOOLTIP_MODE) {
                tooltip.setParaSmallInsignia();
            }
            tooltip.addPara(this.spec.getDesc(), Misc.getTextColor(), opad);
        }
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (!Global.CODEX_TOOLTIP_MODE) {
            if (ShroudedSubstratePlugin.isPlayerCanMakeWeapons()) {
                tooltip.addPara("Right-click to manufacture a weapon", b, opad);
            } else {
                tooltip.addPara("Right-click to analyze the " + this.getName(), b, opad);
            }
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        return false;
    }

    @Override
    public void performRightClickAction(SpecialItemPlugin.RightClickActionHelper helper) {
        Global.getSoundPlayer().playUISound(this.getSpec().getSoundId(), 1.0f, 1.0f);
        int substrate = (int)helper.getNumItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_substrate", null));
        Global.getSector().getPlayerMemoryWithoutUpdate().set(SHROUDED_SUBSTRATE_AVAILABLE, substrate, 0.0f);
        RuleBasedInteractionDialogPluginImpl plugin = new RuleBasedInteractionDialogPluginImpl("ShroudedSubstrateRightClick");
        plugin.setCustom1(helper);
        Global.getSector().getCampaignUI().showInteractionDialogFromCargo(plugin, Global.getSector().getPlayerFleet(), new CampaignUIAPI.DismissDialogDelegate(){

            @Override
            public void dialogDismissed() {
            }
        });
    }
}

