/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.impl.items.GenericSpecialItemPlugin;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.SharedUnlockData;
import com.fs.starfarer.api.impl.campaign.econ.impl.Farming;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.impl.campaign.intel.misc.HypershuntIntel;
import com.fs.starfarer.api.impl.codex.CodexDataV2;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PlanetSearchData {
    public static List<PSToggleButtonRowData> GENERAL_FILTERS = new ArrayList<PSToggleButtonRowData>();
    public static List<ResourceDepositsData> RESOURCE_DEPOSITS = new ArrayList<ResourceDepositsData>();
    public static List<PlanetFilter> COLONY_ITEMS_AND_CONDITIONS = new ArrayList<PlanetFilter>();
    public static List<PSToggleButtonRowData> OTHER_FACTORS = new ArrayList<PSToggleButtonRowData>();

    static {
        PSToggleButtonRowData type = new PSToggleButtonRowData("type", null, PSToggleButtonRowMode.ANY){

            @Override
            public boolean accept(SectorEntityToken entity, Map<String, String> params) {
                if (params.containsKey("stars") && entity.isStar()) {
                    return true;
                }
                if (params.containsKey("gas_giants") && entity instanceof PlanetAPI && ((PlanetAPI)entity).isGasGiant()) {
                    return true;
                }
                return params.containsKey("planets") && !entity.isStar() && (!(entity instanceof PlanetAPI) || !((PlanetAPI)entity).isGasGiant());
            }

            @Override
            public void createTooltip(TooltipMakerAPI info, float width, String param) {
                float opad = 10.0f;
                if (param.equals("stars")) {
                    info.addTitle("Stars");
                    info.addPara("Show stars and black holes.", opad);
                } else if (param.equals("gas_giants")) {
                    info.addTitle("Gas giants");
                    info.addPara("Show gas giants.", opad);
                } else if (param.equals("planets")) {
                    info.addTitle("Planets");
                    info.addPara("Show non-gas-giant planets and stations.", opad);
                }
            }
        };
        type.add("stars", "Stars", false);
        type.add("gas_giants", "Gas giants", true);
        type.add("planets", "Planets", true);
        PSToggleButtonRowData populated = new PSToggleButtonRowData("populated", null, PSToggleButtonRowMode.ANY){

            @Override
            public boolean accept(SectorEntityToken entity, Map<String, String> params) {
                FactionAPI claimedBy;
                boolean conditionMarketOnly = true;
                if (entity.getMarket() != null) {
                    conditionMarketOnly = entity.getMarket().isPlanetConditionMarketOnly();
                }
                if (params.containsKey("populated") && !conditionMarketOnly) {
                    return true;
                }
                if (params.containsKey("claimed") && conditionMarketOnly && (claimedBy = Misc.getClaimingFaction(entity)) != null) {
                    return true;
                }
                return params.containsKey("unclaimed") && conditionMarketOnly && (claimedBy = Misc.getClaimingFaction(entity)) == null;
            }

            @Override
            public void createTooltip(TooltipMakerAPI info, float width, String param) {
                float opad = 10.0f;
                if (param.equals("populated")) {
                    info.addTitle("Populated");
                    info.addPara("Show populated planets.", opad);
                } else if (param.equals("claimed")) {
                    info.addTitle("Claimed");
                    info.addPara("Show uninhabited planets that are in a system claimed by a faction.", opad);
                    info.addPara("Colonization is inadvisable.", opad);
                } else if (param.equals("unclaimed")) {
                    info.addTitle("Unclaimed");
                    info.addPara("Show uninhabited and unclaimed planets.", opad);
                }
            }
        };
        populated.add("populated", "Populated", false);
        populated.add("claimed", "Claimed", false);
        populated.add("unclaimed", "Unclaimed", true);
        PSToggleButtonRowData surveyed = new PSToggleButtonRowData("surveyed", null, PSToggleButtonRowMode.ANY){

            @Override
            public boolean accept(SectorEntityToken entity, Map<String, String> params) {
                if (entity.getMarket() == null) {
                    return entity.isStar();
                }
                if (params.containsKey("surveyed") && entity.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
                    return true;
                }
                return params.containsKey("unsurveyed") && entity.getMarket().getSurveyLevel() != MarketAPI.SurveyLevel.FULL;
            }

            @Override
            public void createTooltip(TooltipMakerAPI info, float width, String param) {
                float opad = 10.0f;
                if (param.equals("surveyed")) {
                    info.addTitle("Surveyed");
                    info.addPara("Show fully surveyed planets.", opad);
                } else if (param.equals("unsurveyed")) {
                    info.addTitle("Unsurveyed");
                    info.addPara("Show planets that have not been fully surveyed.", opad);
                }
            }
        };
        surveyed.add("surveyed", "Surveyed", true);
        surveyed.add("unsurveyed", "Unsurveyed", true);
        PSToggleButtonRowData hazard = new PSToggleButtonRowData("hazard", "Hazard rating", PSToggleButtonRowMode.ONE){

            @Override
            public boolean accept(SectorEntityToken entity, Map<String, String> params) {
                if (entity.getMarket() == null) {
                    return entity.isStar() && params.containsKey("haz_any");
                }
                if (entity.getMarket().getSurveyLevel() != MarketAPI.SurveyLevel.FULL && !params.containsKey("haz_any")) {
                    return false;
                }
                float hazard = entity.getMarket().getHazardValue();
                hazard = (float)Math.round(hazard * 100.0f) / 100.0f;
                float test = 1000000.0f;
                if (params.containsKey("haz_1")) {
                    test = 1.0f;
                }
                if (params.containsKey("haz_2")) {
                    test = 1.5f;
                }
                if (params.containsKey("haz_3")) {
                    test = 2.0f;
                }
                return hazard <= test;
            }

            @Override
            public void createTooltip(TooltipMakerAPI info, float width, String param) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                info.addTitle("Hazard rating");
                if (param.equals("haz_any")) {
                    info.addPara("Do not filter out any planets based on their hazard rating.", opad);
                } else {
                    String rating = "";
                    if (param.equals("haz_1")) {
                        rating = "100%";
                    } else if (param.equals("haz_2")) {
                        rating = "150%";
                    } else if (param.equals("haz_3")) {
                        rating = "200%";
                    }
                    info.addPara("Only show planets with a hazard rating of %s or lower.", opad, h, rating);
                }
            }
        };
        hazard.add("haz_any", "Any", true);
        hazard.add("haz_1", "100%-", false);
        hazard.add("haz_2", "150%-", false);
        hazard.add("haz_3", "200%-", false);
        hazard.prevPad = 7.0f;
        PSToggleButtonRowData stablePoints = new PSToggleButtonRowData("stable_locs", "Stable locations", PSToggleButtonRowMode.ONE){

            @Override
            public boolean accept(SectorEntityToken entity, Map<String, String> params) {
                StarSystemAPI system = entity.getStarSystem();
                if (system == null) {
                    return false;
                }
                String key = "$core_ps_stableLocations";
                int num = 0;
                if (system.getMemoryWithoutUpdate().contains(key)) {
                    num = system.getMemoryWithoutUpdate().getInt(key);
                } else {
                    num = Misc.getNumStableLocations(entity.getStarSystem());
                    system.getMemoryWithoutUpdate().set(key, num, 0.0f);
                }
                int test = 0;
                if (params.containsKey("stable_1")) {
                    test = 1;
                }
                if (params.containsKey("stable_2")) {
                    test = 2;
                }
                if (params.containsKey("stable_3")) {
                    test = 3;
                }
                return num >= test;
            }

            @Override
            public void createTooltip(TooltipMakerAPI info, float width, String param) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                info.addTitle("Stable locations");
                if (param.equals("stable_0")) {
                    info.addPara("Do not filter out any planets based on the number of stable locations in the star system they are in.", opad);
                } else {
                    String locs = "";
                    if (param.equals("stable_1")) {
                        locs = "1";
                    } else if (param.equals("stable_2")) {
                        locs = "2";
                    } else if (param.equals("stable_3")) {
                        locs = "3";
                    }
                    info.addPara("Only show planets with %s or more stable locations in the star system they're in, including locations already in use by objectives or similar.", opad, h, locs);
                }
            }
        };
        stablePoints.add("stable_0", "Any", true);
        stablePoints.add("stable_1", "1+", false);
        stablePoints.add("stable_2", "2+", false);
        stablePoints.add("stable_3", "3+", false);
        stablePoints.prevPad = 2.0f;
        ResourceDepositsData ore = new ResourceDepositsData("ore", "Ore");
        ore.conditions.add("ore_sparse");
        ore.conditions.add("ore_moderate");
        ore.conditions.add("ore_abundant");
        ore.conditions.add("ore_rich");
        ore.conditions.add("ore_ultrarich");
        ResourceDepositsData rareOre = new ResourceDepositsData("rare_ore", "Transplutonic ore");
        rareOre.conditions.add("rare_ore_sparse");
        rareOre.conditions.add("rare_ore_moderate");
        rareOre.conditions.add("rare_ore_abundant");
        rareOre.conditions.add("rare_ore_rich");
        rareOre.conditions.add("rare_ore_ultrarich");
        ResourceDepositsData volatiles = new ResourceDepositsData("volatiles", "Volatiles");
        volatiles.conditions.add("volatiles_trace");
        volatiles.conditions.add("volatiles_diffuse");
        volatiles.conditions.add("volatiles_abundant");
        volatiles.conditions.add("volatiles_plentiful");
        ResourceDepositsData organics = new ResourceDepositsData("organics", "Organics");
        organics.conditions.add("organics_trace");
        organics.conditions.add("organics_common");
        organics.conditions.add("organics_abundant");
        organics.conditions.add("organics_plentiful");
        ResourceDepositsData farmland = new ResourceDepositsData("farmland", "Farmland");
        farmland.conditions.add("farmland_poor");
        farmland.conditions.add("farmland_adequate");
        farmland.conditions.add("farmland_rich");
        farmland.conditions.add("farmland_bountiful");
        ResourceDepositsData ruins = new ResourceDepositsData("ruins", "Ruins");
        ruins.conditions.add("ruins_scattered");
        ruins.conditions.add("ruins_widespread");
        ruins.conditions.add("ruins_extensive");
        ruins.conditions.add("ruins_vast");
        ResourceDepositsData hab = new ResourceDepositsData("habitable", "Hab");
        hab.conditions.add("habitable");
        ResourceDepositsData cold = new ResourceDepositsData("cold", "Cold");
        cold.conditions.add("cold");
        cold.conditions.add("very_cold");
        ResourceDepositsData heat = new ResourceDepositsData("heat", "Heat");
        heat.conditions.add("hot");
        heat.conditions.add("very_hot");
        ResourceDepositsData atmo = new ResourceDepositsData("atmo", "Atmo");
        atmo.conditions.add("no_atmosphere");
        ResourceDepositsData weather = new ResourceDepositsData("weather", "Wthr");
        weather.conditions.add("extreme_weather");
        ResourceDepositsData darkness = new ResourceDepositsData("darkness", "Dark");
        darkness.conditions.add("poor_light");
        darkness.conditions.add("dark");
        ResourceDepositsData tectonics = new ResourceDepositsData("tectonics", "Tect");
        tectonics.conditions.add("tectonic_activity");
        tectonics.conditions.add("extreme_tectonic_activity");
        GENERAL_FILTERS.add(type);
        GENERAL_FILTERS.add(populated);
        GENERAL_FILTERS.add(surveyed);
        GENERAL_FILTERS.add(hazard);
        GENERAL_FILTERS.add(stablePoints);
        RESOURCE_DEPOSITS.add(ore);
        RESOURCE_DEPOSITS.add(rareOre);
        RESOURCE_DEPOSITS.add(volatiles);
        RESOURCE_DEPOSITS.add(organics);
        RESOURCE_DEPOSITS.add(farmland);
        RESOURCE_DEPOSITS.add(ruins);
        ArrayList<SpecialItemSpecAPI> items = new ArrayList<SpecialItemSpecAPI>();
        for (SpecialItemSpecAPI spec : Global.getSettings().getAllSpecialItemSpecs()) {
            if (!spec.hasTag("planet_search")) continue;
            items.add(spec);
        }
        Collections.sort(items, (s1, s2) -> s1.getName().compareTo(s2.getName()));
        items.forEach(item -> {
            boolean bl = COLONY_ITEMS_AND_CONDITIONS.add(new ColonyItemData(item.getId()));
        });
        ArrayList<MarketConditionSpecAPI> conditions = new ArrayList<MarketConditionSpecAPI>();
        for (MarketConditionSpecAPI spec : Global.getSettings().getAllMarketConditionSpecs()) {
            if (!spec.hasTag("planet_search")) continue;
            conditions.add(spec);
        }
        Collections.sort(conditions, (c1, c2) -> c1.getName().compareTo(c2.getName()));
        conditions.forEach(condition -> {
            boolean bl = COLONY_ITEMS_AND_CONDITIONS.add(new MarketConditionData(condition.getId()));
        });
    }

    public static class ColonyItemData
    implements PlanetFilter {
        public String id;
        public String itemId;
        public SpecialItemSpecAPI item;

        public ColonyItemData(String itemId) {
            this.id = "ps_item_" + itemId;
            this.itemId = itemId;
            this.item = Global.getSettings().getSpecialItemSpec(itemId);
        }

        @Override
        public boolean accept(SectorEntityToken entity, Map<String, String> params) {
            String selected = params.get(this.id);
            if (selected == null) {
                return true;
            }
            if (entity.getMarket() == null) {
                return false;
            }
            if (this.itemId.equals("coronal_portal")) {
                Pair<SectorEntityToken, Float> p = PopulationAndInfrastructure.getNearestCoronalTap(entity.getLocationInHyperspace(), false, true);
                return p != null && !(((Float)p.two).floatValue() > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS);
            }
            if (this.itemId.equals("orbital_fusion_lamp")) {
                for (String id : ItemEffectsRepo.FUSION_LAMP_CONDITIONS) {
                    if (!entity.getMarket().hasCondition(id)) continue;
                    return true;
                }
                return false;
            }
            InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.itemId);
            Farming fake = new Farming();
            fake.setMarket(entity.getMarket());
            return effect.getUnmetRequirements(fake).isEmpty();
        }

        @Override
        public boolean shouldShow() {
            if (this.itemId.equals("coronal_portal")) {
                for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(HypershuntIntel.class)) {
                    HypershuntIntel hypershunt = (HypershuntIntel)intel;
                    if (!hypershunt.defendersDefeated()) continue;
                    return true;
                }
                return false;
            }
            return SharedUnlockData.get().isPlayerAwareOfSpecialItem(this.itemId);
        }

        @Override
        public void createTooltip(TooltipMakerAPI info, float width, String param) {
            SpecialItemPlugin plugin = this.item.getNewPluginInstance(null);
            if (plugin instanceof GenericSpecialItemPlugin) {
                ((GenericSpecialItemPlugin)plugin).setTooltipIsForPlanetSearch(true);
            }
            plugin.createTooltip(info, false, null, null);
            if (plugin instanceof GenericSpecialItemPlugin) {
                ((GenericSpecialItemPlugin)plugin).setTooltipIsForPlanetSearch(false);
            }
            info.setCodexEntryId(CodexDataV2.getItemEntryId(this.item.getId()));
        }

        @Override
        public float getTooltipWidth() {
            return this.item.getNewPluginInstance(null).getTooltipWidth();
        }

        @Override
        public boolean isTooltipExpandable() {
            return this.item.getNewPluginInstance(null).isTooltipExpandable();
        }
    }

    public static class MarketConditionData
    implements PlanetFilter {
        public String id;
        public String conditionId;
        public MarketConditionSpecAPI spec;

        public MarketConditionData(String conditionId) {
            this.id = "ps_mc_" + conditionId;
            this.conditionId = conditionId;
            this.spec = Global.getSettings().getMarketConditionSpec(conditionId);
        }

        @Override
        public boolean accept(SectorEntityToken entity, Map<String, String> params) {
            String selected = params.get(this.id);
            if (selected == null) {
                return true;
            }
            if (entity.getMarket() == null) {
                return false;
            }
            return entity.getMarket().hasCondition(this.conditionId);
        }

        @Override
        public void createTooltip(TooltipMakerAPI info, float width, String param) {
            float opad = 10.0f;
            info.addTitle(this.spec.getName());
            String name = this.spec.getName().toLowerCase();
            info.addPara("Require " + Misc.getAOrAnFor(name) + " " + name + " to be present.", opad);
            info.setCodexEntryId(CodexDataV2.getConditionEntryId(this.conditionId));
        }

        @Override
        public boolean shouldShow() {
            return true;
        }
    }

    public static class PSToggleButtonData {
        public String id;
        public String text;
        public boolean defaultState = false;

        public PSToggleButtonData(String id, String text, boolean defaultState) {
            this.id = id;
            this.text = text;
            this.defaultState = defaultState;
        }
    }

    public static class PSToggleButtonRowData
    implements PlanetFilter {
        public String id;
        public String title;
        public PSToggleButtonRowMode mode;
        public List<PSToggleButtonData> buttons = new ArrayList<PSToggleButtonData>();
        public float prevPad = 0.0f;

        public PSToggleButtonRowData(String id, String title, PSToggleButtonRowMode mode) {
            this.id = id;
            this.title = title;
            this.mode = mode;
        }

        public void add(String id, String text, boolean defaultState) {
            this.buttons.add(new PSToggleButtonData(id, text, defaultState));
        }

        @Override
        public boolean accept(SectorEntityToken entity, Map<String, String> params) {
            return true;
        }

        @Override
        public boolean shouldShow() {
            return true;
        }

        @Override
        public void createTooltip(TooltipMakerAPI info, float width, String param) {
        }
    }

    public static enum PSToggleButtonRowMode {
        ANY,
        ONE;

    }

    public static interface PlanetFilter {
        public boolean accept(SectorEntityToken var1, Map<String, String> var2);

        public boolean shouldShow();

        default public String getOtherFactorId() {
            return null;
        }

        default public String getOtherFactorButtonText() {
            return null;
        }

        public void createTooltip(TooltipMakerAPI var1, float var2, String var3);

        default public float getTooltipWidth() {
            return 350.0f;
        }

        default public boolean isTooltipExpandable() {
            return false;
        }

        default public boolean hasTooltip() {
            return true;
        }
    }

    public static class ResourceDepositsData
    implements PlanetFilter {
        public String id;
        public String idAny;
        public String idNone;
        public String title;
        public String iconNone = Global.getSettings().getSpriteName("intel", "planet_search_none");
        public String iconAny = Global.getSettings().getSpriteName("intel", "planet_search_any");
        public List<String> conditions = new ArrayList<String>();

        public ResourceDepositsData(String id, String title) {
            this.id = id;
            this.idAny = String.valueOf(id) + "_any";
            this.idNone = String.valueOf(id) + "_none";
            this.title = title;
        }

        @Override
        public boolean accept(SectorEntityToken entity, Map<String, String> params) {
            String selected = params.get(this.id);
            if (selected == null) {
                return true;
            }
            if (this.idAny.equals(selected)) {
                return true;
            }
            if (entity.getMarket() == null) {
                return false;
            }
            MarketAPI market = entity.getMarket();
            if (market.getSurveyLevel() != MarketAPI.SurveyLevel.FULL) {
                return false;
            }
            if (this.idNone.equals(selected)) {
                for (String cid : this.conditions) {
                    if (!market.hasCondition(cid)) continue;
                    return false;
                }
                return true;
            }
            boolean foundAtLeastSelected = false;
            for (String cid : this.conditions) {
                if (cid.equals(selected)) {
                    foundAtLeastSelected = true;
                }
                if (!foundAtLeastSelected || !market.hasCondition(cid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldShow() {
            return true;
        }

        @Override
        public void createTooltip(TooltipMakerAPI info, float width, String param) {
            MarketConditionSpecAPI spec;
            float opad = 10.0f;
            if (param == this.idAny) {
                info.addTitle(String.valueOf(this.title) + " not required");
                info.addPara("Disregard the presence or absence of " + this.title.toLowerCase() + " on the planet, both are acceptable.", opad);
            } else if (param == this.idNone) {
                info.addTitle("No " + this.title.toLowerCase());
                info.addPara("Require that no " + this.title.toLowerCase() + " be present on the planet.", opad);
            } else if (this.conditions.contains(param) && (spec = Global.getSettings().getMarketConditionSpec(param)) != null) {
                info.addTitle(spec.getName());
                info.addPara("Require " + spec.getName().toLowerCase() + " or better.", opad);
                info.setCodexEntryId(CodexDataV2.getConditionEntryId(param));
            }
        }
    }
}

