/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.Description;
import java.awt.Color;
import java.util.Map;

public class OrbitalStationInteractionDialogPluginImpl
implements InteractionDialogPlugin,
CoreInteractionListener {
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CampaignFleetAPI playerFleet;
    private SectorEntityToken station;
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private EngagementResultAPI lastResult = null;
    private OptionId lastOptionMousedOver = null;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.station = dialog.getInteractionTarget();
        this.visual.setVisualFade(0.25f, 0.25f);
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                Description desc = Global.getSettings().getDescription(this.station.getCustomDescriptionId(), Description.Type.CUSTOM);
                if (desc != null && desc.hasText3()) {
                    this.addText(desc.getText3());
                }
                this.addText(this.getString("approach"));
            }
            case INIT_NO_TEXT: {
                this.createInitialOptions();
                if (this.station.getCustomInteractionDialogImageVisual() != null) {
                    this.visual.showImageVisual(this.station.getCustomInteractionDialogImageVisual());
                    break;
                }
                if (this.station instanceof PlanetAPI) {
                    this.visual.showPlanetInfo(this.station);
                    break;
                }
                this.visual.showImagePortion("illustrations", "hound_hangar", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
                break;
            }
            case TRADE_CARGO: {
                this.addText(this.getString("tradeCargo"));
                this.options.clearOptions();
                this.visual.showCore(CoreUITabId.CARGO, this.station, this);
                break;
            }
            case TRADE_SHIPS: {
                this.addText(this.getString("tradeShips"));
                this.options.clearOptions();
                this.visual.showCore(CoreUITabId.FLEET, this.station, this);
                break;
            }
            case REFIT: {
                this.addText(this.getString("refit"));
                this.options.clearOptions();
                this.visual.showCore(CoreUITabId.REFIT, this.station, this);
                break;
            }
            case REPAIR_ALL: {
                this.performRepairs();
                this.createInitialOptions();
                break;
            }
            case LEAVE: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    private void performRepairs() {
        this.addText(this.getString("repair"));
        float supplies = this.playerFleet.getCargo().getSupplies();
        float needed = this.playerFleet.getLogistics().getTotalRepairAndRecoverySupplyCost();
        this.textPanel.highlightLastInLastPara("" + (int)needed, HIGHLIGHT_COLOR);
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            member.getStatus().repairFully();
            float max = member.getRepairTracker().getMaxCR();
            float curr = member.getRepairTracker().getBaseCR();
            if (!(max > curr)) continue;
            member.getRepairTracker().applyCREvent(max - curr, "Repaired at station");
        }
        if (needed > 0.0f) {
            this.playerFleet.getCargo().removeSupplies(needed);
            this.playerFleet.getLogistics().updateRepairUtilizationForUI();
        }
    }

    private void createInitialOptions() {
        this.options.clearOptions();
        if (this.station.getFaction().isNeutralFaction()) {
            this.options.addOption("Transfer cargo or personnel", (Object)OptionId.TRADE_CARGO);
            this.options.setShortcut((Object)OptionId.TRADE_CARGO, 23, false, false, false, true);
            this.options.addOption("Transfer ships to or from this station", (Object)OptionId.TRADE_SHIPS);
            this.options.setShortcut((Object)OptionId.TRADE_SHIPS, 33, false, false, false, true);
            this.options.addOption("Make use of the dockyard's refitting facilities", (Object)OptionId.REFIT);
            this.options.setShortcut((Object)OptionId.REFIT, 19, false, false, false, true);
        } else {
            this.options.addOption("Trade, or hire personnel", (Object)OptionId.TRADE_CARGO);
            this.options.setShortcut((Object)OptionId.TRADE_CARGO, 23, false, false, false, true);
            this.options.addOption("Buy or sell ships", (Object)OptionId.TRADE_SHIPS, null);
            this.options.setShortcut((Object)OptionId.TRADE_SHIPS, 33, false, false, false, true);
            this.options.addOption("Make use of the dockyard's refitting facilities", (Object)OptionId.REFIT);
            this.options.setShortcut((Object)OptionId.REFIT, 19, false, false, false, true);
        }
        if (this.station.getFaction().getRelationship(this.playerFleet.getFaction().getId()) >= 0.0f) {
            float needed = this.playerFleet.getLogistics().getTotalRepairAndRecoverySupplyCost();
            float supplies = this.playerFleet.getCargo().getSupplies();
            this.options.addOption("Repair your ships at the station's dockyard", (Object)OptionId.REPAIR_ALL);
            this.options.setShortcut((Object)OptionId.REPAIR_ALL, 30, false, false, false, true);
            if (needed <= 0.0f) {
                this.options.setEnabled((Object)OptionId.REPAIR_ALL, false);
                this.options.setTooltip((Object)OptionId.REPAIR_ALL, this.getString("repairTooltipAlreadyRepaired"));
            } else if (supplies < needed) {
                this.options.setEnabled((Object)OptionId.REPAIR_ALL, false);
                this.options.setTooltip((Object)OptionId.REPAIR_ALL, this.getString("repairTooltipNotEnough"));
                this.options.setTooltipHighlightColors((Object)OptionId.REPAIR_ALL, HIGHLIGHT_COLOR, HIGHLIGHT_COLOR);
                this.options.setTooltipHighlights((Object)OptionId.REPAIR_ALL, "" + (int)Math.ceil(needed), "" + (int)supplies);
            } else {
                this.options.setTooltip((Object)OptionId.REPAIR_ALL, this.getString("repairTooltip"));
                this.options.setTooltipHighlightColors((Object)OptionId.REPAIR_ALL, HIGHLIGHT_COLOR, HIGHLIGHT_COLOR);
                this.options.setTooltipHighlights((Object)OptionId.REPAIR_ALL, "" + (int)Math.ceil(needed), "" + (int)supplies);
            }
        }
        this.options.addOption("Leave", (Object)OptionId.LEAVE);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    private String getString(String id) {
        String str = Global.getSettings().getString("stationInteractionDialog", id);
        String fleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        str = str.replaceAll("\\$stationName", this.station.getName());
        float needed = this.playerFleet.getLogistics().getTotalRepairAndRecoverySupplyCost();
        float supplies = this.playerFleet.getCargo().getSupplies();
        str = str.replaceAll("\\$supplies", "" + (int)supplies);
        str = str.replaceAll("\\$repairSupplyCost", "" + (int)Math.ceil(needed));
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public void coreUIDismissed() {
        this.optionSelected(null, (Object)OptionId.INIT_NO_TEXT);
    }

    private static enum OptionId {
        INIT,
        INIT_NO_TEXT,
        TRADE_CARGO,
        TRADE_SHIPS,
        REFIT,
        REPAIR_ALL,
        LEAVE;

    }
}

