/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TradeCenter
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float BASE_BONUS = 25.0f;
    public static float ALPHA_CORE_BONUS = 25.0f;
    public static float IMPROVE_BONUS = 25.0f;
    public static float STABILITY_PENALTY = 3.0f;
    protected transient SubmarketAPI saved = null;

    @Override
    public void apply() {
        super.apply(true);
        if (this.isFunctional() && this.market.isPlayerOwned()) {
            SubmarketAPI open = this.market.getSubmarket("open_market");
            if (open == null) {
                if (this.saved != null) {
                    this.market.addSubmarket(this.saved);
                } else {
                    this.market.addSubmarket("open_market");
                    SubmarketAPI sub = this.market.getSubmarket("open_market");
                    sub.setFaction(Global.getSector().getFaction("independent"));
                    Global.getSector().getEconomy().forceStockpileUpdate(this.market);
                }
            }
        } else if (this.market.isPlayerOwned()) {
            this.market.removeSubmarket("open_market");
        }
        this.market.getStability().modifyFlat(this.getModId(), -STABILITY_PENALTY, this.getNameForModifier());
        this.market.getIncomeMult().modifyPercent(this.getModId(0), BASE_BONUS, this.getNameForModifier());
        if (!this.isFunctional()) {
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        if (this.market.isPlayerOwned()) {
            SubmarketAPI open;
            this.saved = open = this.market.getSubmarket("open_market");
            this.market.removeSubmarket("open_market");
        }
        this.market.getStability().unmodifyFlat(this.getModId());
        this.market.getIncomeMult().unmodifyPercent(this.getModId(0));
    }

    @Override
    protected void addStabilityPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        float a = BASE_BONUS;
        String aStr = "+" + Math.round(a * 1.0f) + "%";
        tooltip.addPara("Colony income: %s", opad, h, aStr);
        h = Misc.getNegativeHighlightColor();
        tooltip.addPara("Stability penalty: %s", opad, h, "" + -((int)STABILITY_PENALTY));
    }

    @Override
    protected void addRightAfterDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
        if (this.market.isPlayerOwned() || this.currTooltipMode == Industry.IndustryTooltipMode.ADD_INDUSTRY) {
            tooltip.addPara("Adds an independent 'Open Market' that the colony's owner is able to trade with. A low-level semi-permanent bounty on all hostile fleets may be posted as well.", 10.0f);
        }
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            this.addStabilityPostDemandSection(tooltip, hasDemand, mode);
        }
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("tritachyon", 10.0f);
    }

    @Override
    public boolean isAvailableToBuild() {
        return this.market.hasSpaceport();
    }

    @Override
    public String getUnavailableReason() {
        return "Requires a functional spaceport";
    }

    @Override
    public String getCurrentImage() {
        float size = this.market.getSize();
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "commerce_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "commerce_high");
        }
        return super.getCurrentImage();
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        this.market.getIncomeMult().modifyPercent(this.getModId(1), ALPHA_CORE_BONUS, "Alpha core (" + this.getNameForModifier() + ")");
    }

    @Override
    protected void applyNoAICoreModifiers() {
        this.market.getIncomeMult().unmodifyPercent(this.getModId(1));
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_BONUS;
        String str = Math.round(a) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases colony income by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases colony income by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getIncomeMult().modifyPercent(this.getModId(2), IMPROVE_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getIncomeMult().unmodifyPercent(this.getModId(2));
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_BONUS;
        String aStr = Math.round(a * 1.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Colony income increased by %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("Increases colony income by %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

