/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.AbyssalLightEntityPlugin;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalFrequencies;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAbyssPluginImpl;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import org.lwjgl.util.vector.Vector2f;

public class AbyssalLightEPEC
extends BaseEPEncounterCreator {
    @Override
    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        return AbyssalFrequencies.getAbyssalLightFrequency(manager, point);
    }

    protected LightSpawnType pickSpawnType(EncounterManager manager, EncounterPoint point) {
        HyperspaceAbyssPluginImpl.AbyssalEPData data = (HyperspaceAbyssPluginImpl.AbyssalEPData)point.custom;
        WeightedRandomPicker<LightSpawnType> picker = new WeightedRandomPicker<LightSpawnType>(data.random);
        picker.add(LightSpawnType.NORMAL, 100.0f);
        picker.add(LightSpawnType.PAIR, 7.0f);
        picker.add(LightSpawnType.CLUSTER, 3.0f);
        picker.add(LightSpawnType.LARGE, 1.0f);
        LightSpawnType type = (LightSpawnType)((Object)picker.pick());
        return type;
    }

    protected void modifyLightParams(EncounterManager manager, EncounterPoint point, LightSpawnType type, AbyssalLightEntityPlugin.AbyssalLightParams params) {
    }

    protected void modifySpawnedLight(EncounterManager manager, EncounterPoint point, AbyssalLightEntityPlugin.AbyssalLightParams params, SectorEntityToken light) {
    }

    @Override
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        HyperspaceAbyssPluginImpl.AbyssalEPData data = (HyperspaceAbyssPluginImpl.AbyssalEPData)point.custom;
        LightSpawnType type = this.pickSpawnType(manager, point);
        float minSize = AbyssalLightEntityPlugin.MIN_SIZE;
        float maxSize = AbyssalLightEntityPlugin.MAX_SIZE;
        if (type == LightSpawnType.NORMAL) {
            AbyssalLightEntityPlugin.AbyssalLightParams params = new AbyssalLightEntityPlugin.AbyssalLightParams();
            this.modifyLightParams(manager, point, type, params);
            CustomCampaignEntityAPI e = Global.getSector().getHyperspace().addCustomEntity(null, null, "abyssal_light", "neutral", params);
            e.setLocation(point.loc.x, point.loc.y);
            this.modifySpawnedLight(manager, point, params, e);
        } else if (type == LightSpawnType.LARGE) {
            AbyssalLightEntityPlugin.AbyssalLightParams params = new AbyssalLightEntityPlugin.AbyssalLightParams(maxSize + 800.0f, maxSize + 1200.0f);
            params.durationDays = 1000.0f + data.random.nextFloat() * 500.0f;
            params.frequencyChangeMult = 0.25f;
            this.modifyLightParams(manager, point, type, params);
            CustomCampaignEntityAPI e = Global.getSector().getHyperspace().addCustomEntity(null, null, "abyssal_light", "neutral", params);
            e.setLocation(point.loc.x, point.loc.y);
            this.modifySpawnedLight(manager, point, params, e);
        } else if (type == LightSpawnType.PAIR) {
            AbyssalLightEntityPlugin.AbyssalLightParams larger = new AbyssalLightEntityPlugin.AbyssalLightParams(maxSize - 300.0f, maxSize + 300.0f);
            larger.durationDays = 90.0f + data.random.nextFloat() * 30.0f;
            larger.frequencyChangeMult = 0.75f;
            this.modifyLightParams(manager, point, type, larger);
            CustomCampaignEntityAPI e = Global.getSector().getHyperspace().addCustomEntity(null, null, "abyssal_light", "neutral", larger);
            e.setLocation(point.loc.x, point.loc.y);
            this.modifySpawnedLight(manager, point, larger, e);
            AbyssalLightEntityPlugin.AbyssalLightParams smaller = new AbyssalLightEntityPlugin.AbyssalLightParams(minSize * 0.2f, minSize * 0.5f);
            smaller.durationDays = larger.durationDays;
            smaller.frequencyChangeMult = larger.frequencyChangeMult;
            this.modifyLightParams(manager, point, type, smaller);
            Vector2f loc = Misc.getPointAtRadius(point.loc, 100.0f + data.random.nextFloat() * 300.0f);
            e = Global.getSector().getHyperspace().addCustomEntity(null, null, "abyssal_light", "neutral", smaller);
            e.setLocation(loc.x, loc.y);
            this.modifySpawnedLight(manager, point, smaller, e);
        } else if (type == LightSpawnType.CLUSTER) {
            int num = 3 + data.random.nextInt(7);
            float spread = 50.0f + (float)num * 10.0f;
            spread *= 0.5f;
            int i = 0;
            while (i < num) {
                AbyssalLightEntityPlugin.AbyssalLightParams params = new AbyssalLightEntityPlugin.AbyssalLightParams(minSize * 0.1f, minSize * 0.2f);
                params.durationDays += data.random.nextFloat() * 50.0f;
                params.frequencyChangeMult = 2.0f + data.random.nextFloat() * 2.0f;
                params.frequencyMultMin *= params.frequencyChangeMult;
                params.frequencyMultMax *= params.frequencyChangeMult;
                this.modifyLightParams(manager, point, type, params);
                Vector2f loc = Misc.getPointWithinRadius(point.loc, spread);
                CustomCampaignEntityAPI e = Global.getSector().getHyperspace().addCustomEntity(null, null, "abyssal_light", "neutral", params);
                e.setLocation(loc.x, loc.y);
                this.modifySpawnedLight(manager, point, params, e);
                ++i;
            }
        }
    }

    public static enum LightSpawnType {
        NORMAL,
        PAIR,
        CLUSTER,
        LARGE;

    }
}

