/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBLeadPlayerTo
extends BaseGhostBehavior {
    protected SectorEntityToken to;
    protected int maxBurn;
    protected float maxDistAhead;
    protected boolean returningToPlayer = false;

    public GBLeadPlayerTo(float duration, SectorEntityToken to, float maxDistAhead, int maxBurn) {
        super(duration);
        this.to = to;
        this.maxDistAhead = maxDistAhead;
        this.maxBurn = maxBurn;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf.getContainingLocation() != ghost.getEntity().getContainingLocation() || !pf.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        float goBackThreshold = this.maxDistAhead * 2.0f;
        if (this.returningToPlayer) {
            goBackThreshold = this.maxDistAhead * 1.5f;
        }
        Vector2f dir = Misc.getUnitVector(pf.getLocation(), this.to.getLocation());
        Vector2f diff = Vector2f.sub((Vector2f)ghost.getEntity().getLocation(), (Vector2f)pf.getLocation(), (Vector2f)new Vector2f());
        float distAheadOfPlayer = Vector2f.dot((Vector2f)dir, (Vector2f)diff);
        float distFromPlayer = Misc.getDistance(pf, ghost.getEntity());
        if (distFromPlayer >= goBackThreshold) {
            ghost.moveTo(pf.getLocation(), pf.getVelocity(), this.maxBurn);
            this.returningToPlayer = true;
        } else if (distAheadOfPlayer > this.maxDistAhead) {
            int burn = (int)((float)this.maxBurn * this.maxDistAhead / distAheadOfPlayer * 0.5f);
            ghost.moveTo(this.to.getLocation(), new Vector2f(), burn);
            this.returningToPlayer = false;
        } else {
            ghost.moveTo(this.to.getLocation(), new Vector2f(), this.maxBurn);
            this.returningToPlayer = false;
        }
        float dist = Misc.getDistance(ghost.getEntity(), this.to);
        if (dist < ghost.getEntity().getRadius() + this.to.getRadius()) {
            this.end();
            return;
        }
    }
}

