/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ht;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.CharacterStatsRefreshListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddAbility;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class HyperspaceTopographyEventIntel
extends BaseEventIntel
implements FleetEventListener,
CharacterStatsRefreshListener,
CurrentLocationChangedListener {
    public static Color BAR_COLOR = Global.getSettings().getColor("progressBarFleetPointsColor");
    public static int PROGRESS_MAX = 1000;
    public static int PROGRESS_1 = 100;
    public static int PROGRESS_2 = 250;
    public static int PROGRESS_3 = 400;
    public static int PROGRESS_4 = 550;
    public static int PROGRESS_5 = 700;
    public static float BASE_DETECTION_RANGE_LY = 3.0f;
    public static float RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY = 5.0f;
    public static float RANGE_PER_DOMAIN_SENSOR_ARRAY = 2.0f;
    public static float RANGE_PER_MAKESHIFT_SENSOR_ARRAY = 1.0f;
    public static int MAX_SENSOR_ARRAYS = 3;
    public static float WAYSTATION_BONUS = 2.0f;
    public static float SLIPSTREAM_FUEL_MULT = 0.25f;
    public static float HYPER_BURN_BONUS = 3.0f;
    public static String KEY = "$hte_ref";
    public static float RECENT_READINGS_TIMEOUT = 30.0f;
    public static float RECENT_READINGS_RANGE_LY = 10.0f;
    protected TimeoutTracker<RecentTopographyReadings> recent = new TimeoutTracker();

    public static void addFactorCreateIfNecessary(EventFactor factor, InteractionDialogAPI dialog) {
        if (HyperspaceTopographyEventIntel.get() == null) {
            new HyperspaceTopographyEventIntel(null, false);
        }
        if (HyperspaceTopographyEventIntel.get() != null) {
            HyperspaceTopographyEventIntel.get().addFactor(factor, dialog);
        }
    }

    public static HyperspaceTopographyEventIntel get() {
        return (HyperspaceTopographyEventIntel)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public HyperspaceTopographyEventIntel(TextPanelAPI text, boolean withIntelNotification) {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setup();
        Global.getSector().getIntelManager().addIntel(this, !withIntelNotification, text);
    }

    protected void setup() {
        this.factors.clear();
        this.stages.clear();
        this.setMaxProgress(PROGRESS_MAX);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.SLIPSTREAM_NAVIGATION, PROGRESS_1, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.REVERSE_POLARITY, PROGRESS_2, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.SLIPSTREAM_DETECTION, PROGRESS_3, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.HYPERFIELD_OPTIMIZATION, PROGRESS_4, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.GENERATE_SLIPSURGE, PROGRESS_5, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.TOPOGRAPHIC_DATA, PROGRESS_MAX, true, BaseEventIntel.StageIconSize.SMALL);
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_NAVIGATION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_DETECTION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.REVERSE_POLARITY)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.HYPERFIELD_OPTIMIZATION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.GENERATE_SLIPSURGE)).keepIconBrightWhenLaterStageReached = true;
    }

    protected Object readResolve() {
        if (this.getDataFor((Object)Stage.GENERATE_SLIPSURGE) == null) {
            this.setup();
        }
        return this;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        Color h = Misc.getHighlightColor();
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            BaseEventIntel.EventStageData esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                info.addPara("Able to detect slipstreams near your spaceports", tc, initPad);
            }
            if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                info.addPara("Fuel use while traversing slipstreams reduced by %s", initPad, tc, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
            }
            if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                info.addPara("Maximum burn increased by %s while in hyperspace", initPad, tc, h, "" + (int)HYPER_BURN_BONUS);
            }
            if (esd.id == Stage.REVERSE_POLARITY) {
                info.addPara("%s ability unlocked", initPad, tc, h, "Reverse Polarity");
            }
            if (esd.id == Stage.GENERATE_SLIPSURGE) {
                info.addPara("%s ability unlocked", initPad, tc, h, "Generate Slipsurge");
            }
            if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                info.addPara("Topographic data gained", tc, initPad);
            }
            return;
        }
    }

    @Override
    public float getImageSizeForStageDesc(Object stageId) {
        if (stageId == Stage.START) {
            return 64.0f;
        }
        return 48.0f;
    }

    @Override
    public float getImageIndentForStageDesc(Object stageId) {
        if (stageId == Stage.START) {
            return 0.0f;
        }
        return 16.0f;
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (this.isStageActive(stageId)) {
            this.addStageDesc(info, stageId, small, false);
        }
    }

    public void addStageDesc(TooltipMakerAPI info, Object stageId, float initPad, boolean forTooltip) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (stageId == Stage.START) {
            info.addPara("Detailed sensor readings greatly aid hyperspace navigation. There are many ways of acquiring this data, including using in-system sensor arrays, using an Active Sensor Burst near interesting phenomena, traveling through hyperspace at a very high burn level, or simply buying the data from scavengers.", initPad);
        } else if (stageId == Stage.SLIPSTREAM_DETECTION) {
            info.addPara("Allows a Spaceport to detect nearby slipstreams. Detection range increased for %s. Claimed sensor arrays within %s light-years provide extra detection range: %s ly for Domain-era arrays, and %s ly for makeshift ones. Up to %s sensor arrays can be used.", initPad, Misc.getHighlightColor(), "larger colonies", "" + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY, "+" + (int)RANGE_PER_DOMAIN_SENSOR_ARRAY, "+" + (int)RANGE_PER_MAKESHIFT_SENSOR_ARRAY, "" + MAX_SENSOR_ARRAYS);
        } else if (stageId == Stage.SLIPSTREAM_NAVIGATION) {
            info.addPara("Fuel use while traveling inside slipstreams reduced by %s. This reduction is multiplicative with the baseline fuel use reduction for traveling inside a slipstream.", initPad, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
        } else if (stageId == Stage.REVERSE_POLARITY) {
            info.addPara("Unlocks the %s ability, which allows your fleet to travel against the current of slipstreams.", initPad, h, "Reverse Polarity");
        } else if (stageId == Stage.GENERATE_SLIPSURGE) {
            info.addPara("Unlocks the %s ability, which allows your fleet to create powerful, short-lived slipstreams useful for rapid travel.", initPad, h, "Generate Slipsurge");
        } else if (stageId == Stage.HYPERFIELD_OPTIMIZATION) {
            info.addPara("Maximum burn increased by %s while in hyperspace.", initPad, h, "" + (int)HYPER_BURN_BONUS);
        } else if (stageId == Stage.TOPOGRAPHIC_DATA) {
            int min = this.getTopoResetMin();
            int max = this.getTopoResetMax();
            info.addPara("A batch of topographic data that can be sold for a considerable number of credits.", initPad);
            info.addPara("Event progress will be reset to between %s and %s points when this outcome is reached.", opad, h, "" + min, "" + max);
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && EnumSet.of(Stage.SLIPSTREAM_DETECTION, new Stage[]{Stage.SLIPSTREAM_NAVIGATION, Stage.GENERATE_SLIPSURGE, Stage.REVERSE_POLARITY, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA}).contains(esd.id)) {
            return new BaseFactorTooltip(){

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                        tooltip.addTitle("Slipstream detection");
                    } else if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                        tooltip.addTitle("Slipstream navigation");
                    } else if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                        tooltip.addTitle("Hyperfield optimization");
                    } else if (esd.id == Stage.REVERSE_POLARITY) {
                        tooltip.addTitle("Reverse Polarity");
                    } else if (esd.id == Stage.GENERATE_SLIPSURGE) {
                        tooltip.addTitle("Generate Slipsurge");
                    } else if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                        tooltip.addTitle("Topographic data");
                    }
                    HyperspaceTopographyEventIntel.this.addStageDesc(tooltip, esd.id, opad, true);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        if (EnumSet.of(Stage.SLIPSTREAM_DETECTION, Stage.SLIPSTREAM_NAVIGATION, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA, Stage.START).contains(esd.id)) {
            return Global.getSettings().getSpriteName("events", "hyperspace_topography_" + ((Stage)((Object)esd.id)).name());
        }
        if (stageId == Stage.REVERSE_POLARITY) {
            return Global.getSettings().getAbilitySpec("reverse_polarity").getIconName();
        }
        if (stageId == Stage.GENERATE_SLIPSURGE) {
            return Global.getSettings().getAbilitySpec("generate_slipsurge").getIconName();
        }
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    public Color getBarColor() {
        Color color = BAR_COLOR;
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "Hyperspace Topography";
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public int getTopoResetMin() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.GENERATE_SLIPSURGE);
        return stage.progress;
    }

    public int getTopoResetMax() {
        return this.getTopoResetMin() + 50;
    }

    public void resetTopographicData() {
        int resetProgress = this.getTopoResetMin() + this.getRandom().nextInt(this.getTopoResetMax() - this.getTopoResetMin() + 1);
        this.setProgress(resetProgress);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        return tags;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        this.applyFleetEffects();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recent.advance(days);
    }

    public void addAbility(String id) {
        if (Global.getSector().getPlayerFleet().hasAbility(id)) {
            return;
        }
        ArrayList<Misc.Token> params = new ArrayList<Misc.Token>();
        Misc.Token t = new Misc.Token(id, Misc.TokenType.LITERAL);
        params.add(t);
        t = new Misc.Token("-1", Misc.TokenType.LITERAL);
        params.add(t);
        new AddAbility().execute(null, null, params, null);
        PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
        int curr = slots.getCurrBarIndex();
        int i = 0;
        block0: while (i < 5) {
            slots.setCurrBarIndex(i);
            for (PersistentUIDataAPI.AbilitySlotAPI slot : slots.getCurrSlotsCopy()) {
                if ("reverse_polarity".equals(id) && "scavenge".equals(slot.getAbilityId())) {
                    slot.setInHyperAbilityId("reverse_polarity");
                    break block0;
                }
                if (!"generate_slipsurge".equals(id) || !"distress_call".equals(slot.getAbilityId())) continue;
                slot.setInHyperAbilityId("generate_slipsurge");
                break block0;
            }
            ++i;
        }
        slots.setCurrBarIndex(curr);
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.REVERSE_POLARITY) {
            this.addAbility("reverse_polarity");
        }
        if (stage.id == Stage.GENERATE_SLIPSURGE) {
            this.addAbility("generate_slipsurge");
        }
        if (stage.id == Stage.TOPOGRAPHIC_DATA) {
            this.resetTopographicData();
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addSpecial(new SpecialItemData("topographic_data", null), 1.0f);
        }
    }

    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
    }

    @Override
    public void reportAboutToRefreshCharacterStatEffects() {
    }

    @Override
    public void reportRefreshedCharacterStatEffects() {
        this.updateMarketDetectionRanges();
        this.applyFleetEffects();
    }

    public void applyFleetEffects() {
        String id1 = "hypertopology1";
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        pf.getStats().getFleetwideMaxBurnMod().unmodifyFlat(id1);
        MutableStat stat = pf.getStats().getDynamic().getStat("fuel_use_not_shown_on_map_mult");
        stat.unmodifyMult(id1);
        if (Global.getSector().getCurrentLocation().isHyperspace()) {
            if (this.isStageActive((Object)Stage.SLIPSTREAM_NAVIGATION)) {
                for (MutableStat.StatMod mod : stat.getMultMods().values()) {
                    if (!SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC.equals(mod.desc)) continue;
                    stat.modifyMult(id1, SLIPSTREAM_FUEL_MULT, String.valueOf(SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC) + " (hyperspace topography)");
                    break;
                }
            }
            if (this.isStageActive((Object)Stage.HYPERFIELD_OPTIMIZATION)) {
                pf.getStats().getFleetwideMaxBurnMod().modifyFlat(id1, HYPER_BURN_BONUS, "Hyperspace topography");
            }
        }
    }

    public void updateMarketDetectionRanges() {
        if (this.isStageActive((Object)Stage.SLIPSTREAM_DETECTION)) {
            String id1 = "hypertopology1";
            String id2 = "hypertopology2";
            String id3 = "hypertopology3";
            String id4 = "hypertopology4";
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (market.isHidden()) continue;
                boolean unapplicable = false;
                Industry spaceport = market.getIndustry("spaceport");
                if (spaceport == null) {
                    spaceport = market.getIndustry("megaport");
                }
                if (spaceport == null || !spaceport.isFunctional()) {
                    unapplicable = true;
                }
                StatBonus mod = market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod");
                if (!market.isPlayerOwned() || unapplicable) {
                    mod.unmodify(id1);
                    mod.unmodify(id2);
                    mod.unmodify(id3);
                    mod.unmodify(id4);
                    continue;
                }
                mod.modifyFlat(id1, BASE_DETECTION_RANGE_LY, "Base detection range");
                mod.modifyFlat(id2, market.getSize(), "Colony size");
                float arraysBonus = this.gerSensorArrayBonusFor(market, RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY);
                mod.modifyFlatAlways(id3, arraysBonus, "Claimed sensor arrays within " + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY + " ly (max: " + MAX_SENSOR_ARRAYS + " arrays)");
            }
        }
    }

    public float gerSensorArrayBonusFor(MarketAPI market, float range) {
        int countDomain = 0;
        int countMakeshift = 0;
        Vector2f locInHyper = market.getLocationInHyperspace();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(locInHyper, system.getLocation());
            if (dist > range && (float)Math.round(dist * 10.0f) <= range * 10.0f) {
                dist = range;
            }
            if (!(dist <= range)) continue;
            for (SectorEntityToken entity : system.getEntitiesWithTag("sensor_array")) {
                if (entity.getFaction() == null || !entity.getFaction().isPlayerFaction()) continue;
                if (entity.hasTag("makeshift")) {
                    ++countMakeshift;
                    continue;
                }
                ++countDomain;
            }
        }
        float bonus = (float)Math.min(countDomain, MAX_SENSOR_ARRAYS) * RANGE_PER_DOMAIN_SENSOR_ARRAY;
        float useMakeshift = Math.min(MAX_SENSOR_ARRAYS - countDomain, countMakeshift);
        if (useMakeshift < 0.0f) {
            useMakeshift = 0.0f;
        }
        return bonus += useMakeshift * RANGE_PER_MAKESHIFT_SENSOR_ARRAY;
    }

    @Override
    public boolean withMonthlyFactors() {
        return false;
    }

    public void addRecentReadings(Vector2f loc) {
        this.recent.add(new RecentTopographyReadings(loc), RECENT_READINGS_TIMEOUT);
    }

    public static boolean hasRecentReadingsNearPlayer() {
        return HyperspaceTopographyEventIntel.get() != null && HyperspaceTopographyEventIntel.get().hasRecentReadingsNear(Global.getSector().getPlayerFleet().getLocationInHyperspace());
    }

    public boolean hasRecentReadingsNear(Vector2f loc) {
        for (RecentTopographyReadings curr : this.recent.getItems()) {
            float distLY = Misc.getDistanceLY(loc, curr.loc);
            if (!(distLY <= RECENT_READINGS_RANGE_LY)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getSoundForStageReachedUpdate(Object stageId) {
        if (stageId == Stage.REVERSE_POLARITY || stageId == Stage.GENERATE_SLIPSURGE) {
            return "ui_learned_ability";
        }
        return super.getSoundForStageReachedUpdate(stageId);
    }

    @Override
    protected String getSoundForOneTimeFactorUpdate(EventFactor factor) {
        return null;
    }

    public static class RecentTopographyReadings {
        public Vector2f loc;

        public RecentTopographyReadings(Vector2f loc) {
            this.loc = loc;
        }
    }

    public static enum Stage {
        START,
        SLIPSTREAM_DETECTION,
        SLIPSTREAM_NAVIGATION,
        REVERSE_POLARITY,
        HYPERFIELD_OPTIMIZATION,
        GENERATE_SLIPSURGE,
        TOPOGRAPHIC_DATA;

    }
}

