/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEActionStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEAvertInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEOrganizeStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PETravelStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidAssignmentAI;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class PunitiveExpeditionIntel
extends RaidIntel
implements RaidIntel.RaidDelegate {
    public static final String BUTTON_AVERT = "BUTTON_CHANGE_ORDERS";
    public static float REP_PENALTY = 0.05f;
    public static final Object ENTERED_SYSTEM_UPDATE = new Object();
    public static final Object OUTCOME_UPDATE = new Object();
    protected PEActionStage action;
    protected PunitiveExpeditionManager.PunExGoal goal;
    protected MarketAPI target;
    protected MarketAPI from;
    protected PunExOutcome outcome;
    protected Random random = new Random();
    protected PunitiveExpeditionManager.PunExReason bestReason;
    protected Industry targetIndustry;
    protected FactionAPI targetFaction;
    protected transient ReputationActionResponsePlugin.ReputationAdjustmentResult repResult = null;
    protected transient String targetOwner = null;

    public PunitiveExpeditionIntel(FactionAPI faction, MarketAPI from, MarketAPI target, float expeditionFP, float organizeDuration, PunitiveExpeditionManager.PunExGoal goal, Industry targetIndustry, PunitiveExpeditionManager.PunExReason bestReason) {
        super(target.getStarSystem(), faction, null);
        this.goal = goal;
        this.targetIndustry = targetIndustry;
        this.bestReason = bestReason;
        this.delegate = this;
        this.from = from;
        this.target = target;
        this.targetFaction = target.getFaction();
        SectorEntityToken gather = from.getPrimaryEntity();
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(this.getFactionForUIColors(), target.getPrimaryEntity());
        if (gather == null || raidJump == null) {
            this.endImmediately();
            return;
        }
        float orgDur = organizeDuration;
        if (DebugFlags.PUNITIVE_EXPEDITION_DEBUG || DebugFlags.FAST_RAIDS) {
            orgDur = 0.5f;
        }
        this.addStage(new PEOrganizeStage(this, from, orgDur));
        float successMult = 0.5f;
        PEAssembleStage assemble = new PEAssembleStage(this, gather);
        assemble.addSource(from);
        assemble.setSpawnFP(expeditionFP);
        assemble.setAbortFP(expeditionFP * successMult);
        this.addStage(assemble);
        PETravelStage travel = new PETravelStage(this, gather, raidJump, false);
        travel.setAbortFP(expeditionFP * successMult);
        this.addStage(travel);
        this.action = new PEActionStage(this, target);
        this.action.setAbortFP(expeditionFP * successMult);
        this.addStage(this.action);
        this.addStage(new PEReturnStage(this));
        this.setImportant(true);
        Global.getSector().getIntelManager().addIntel(this);
    }

    public void applyRepPenalty() {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -REP_PENALTY;
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, false), this.getFaction().getId());
    }

    public Random getRandom() {
        return this.random;
    }

    public MarketAPI getTarget() {
        return this.target;
    }

    public FactionAPI getTargetFaction() {
        return this.targetFaction;
    }

    public MarketAPI getFrom() {
        return this.from;
    }

    @Override
    public RouteFleetAssignmentAI createAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        RaidAssignmentAI raidAI = new RaidAssignmentAI(fleet, route, this.action);
        return raidAI;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.target != null && this.targetOwner == null) {
            this.targetOwner = this.target.getFactionId();
        }
        if (this.failStage < 0 && this.targetOwner != null && this.target != null && !this.targetOwner.equals(this.target.getFactionId())) {
            this.forceFail(false);
        }
    }

    public void sendOutcomeUpdate() {
        this.sendUpdateIfPlayerHasIntel(OUTCOME_UPDATE, false);
    }

    @Override
    public void sendEnteredSystemUpdate() {
        this.sendUpdateIfPlayerHasIntel(ENTERED_SYSTEM_UPDATE, false);
    }

    @Override
    public String getName() {
        String base = String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefix())) + " Expedition";
        if (this.isEnding()) {
            if (this.outcome == PunExOutcome.AVERTED) {
                return String.valueOf(base) + " - Averted";
            }
            if (this.isSendingUpdate() && this.isFailed()) {
                return String.valueOf(base) + " - Failed";
            }
            if (this.isSucceeded() || this.outcome == PunExOutcome.SUCCESS) {
                return String.valueOf(base) + " - Successful";
            }
            if (this.outcome == PunExOutcome.RAID_FAIL || this.outcome == PunExOutcome.BOMBARD_FAIL || this.outcome == PunExOutcome.COLONY_NO_LONGER_EXISTS || this.outcome == PunExOutcome.TASK_FORCE_DEFEATED) {
                return String.valueOf(base) + " - Failed";
            }
        }
        return base;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        float eta;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.getListInfoParam();
        if (this.getListInfoParam() == ENTERED_SYSTEM_UPDATE) {
            FactionAPI other = this.target.getFaction();
            info.addPara("Target: %s", initPad, tc, other.getBaseUIColor(), this.target.getName());
            initPad = 0.0f;
            info.addPara("Arrived in-system", tc, initPad);
            if (this.repResult != null) {
                initPad = 0.0f;
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            }
            return;
        }
        FactionAPI other = this.targetFaction;
        if (this.outcome != null) {
            if (this.outcome == PunExOutcome.TASK_FORCE_DEFEATED) {
                info.addPara("Expeditionary force defeated", tc, initPad);
            } else if (this.outcome == PunExOutcome.COLONY_NO_LONGER_EXISTS) {
                info.addPara("Expedition aborted", tc, initPad);
            } else if (this.outcome == PunExOutcome.AVERTED) {
                info.addPara("Expedition planning disrupted", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.BOMBARD_FAIL) {
                info.addPara("Bombardment of %s failed", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.RAID_FAIL) {
                info.addPara("Raid of %s failed", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.SUCCESS) {
                if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
                    if (!this.target.isInEconomy()) {
                        info.addPara("%s destroyed by bombardment", initPad, tc, other.getBaseUIColor(), this.target.getName());
                    } else {
                        info.addPara("Bombardment of %s successful", initPad, tc, other.getBaseUIColor(), this.target.getName());
                    }
                } else if (this.targetIndustry != null && this.targetIndustry.getDisruptedDays() >= 2.0f) {
                    info.addPara(String.valueOf(this.targetIndustry.getCurrentName()) + " disrupted for %s days", initPad, tc, h, "" + Math.round(this.targetIndustry.getDisruptedDays()));
                }
            }
            if (this.repResult != null) {
                initPad = 0.0f;
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            }
            return;
        }
        info.addPara("Target: %s", initPad, tc, other.getBaseUIColor(), this.target.getName());
        initPad = 0.0f;
        if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            String goalStr = "saturation bombardment";
            info.addPara("Goal: %s", initPad, tc, Misc.getNegativeHighlightColor(), goalStr);
        }
        if ((eta = this.getETA()) > 1.0f && !this.isEnding()) {
            String days = PunitiveExpeditionIntel.getDaysString(eta);
            info.addPara("Estimated %s " + days + " until arrival", initPad, tc, h, "" + Math.round(eta));
            initPad = 0.0f;
        } else if (!this.isEnding() && this.action.getElapsed() > 0.0f) {
            info.addPara("Currently in-system", tc, initPad);
            initPad = 0.0f;
        }
        if (this.repResult != null) {
            initPad = 0.0f;
            CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
        }
        this.unindent(info);
    }

    @Override
    public PEActionStage getActionStage() {
        for (RaidIntel.RaidStage stage : this.stages) {
            if (!(stage instanceof PEActionStage)) continue;
            return (PEActionStage)stage;
        }
        return null;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        super.createIntelInfo(info, mode);
    }

    public void addInitialDescSection(TooltipMakerAPI info, float initPad) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        FactionAPI faction = this.getFaction();
        String is = faction.getDisplayNameIsOrAre();
        String goalDesc = "";
        String goalHL = "";
        Color goalColor = Misc.getTextColor();
        switch (this.goal) {
            case RAID_PRODUCTION: {
                goalDesc = "disrupting the colony's " + this.targetIndustry.getCurrentName();
                break;
            }
            case RAID_SPACEPORT: {
                goalDesc = "raiding the colony's " + this.targetIndustry.getCurrentName() + " to disrupt its operations";
                break;
            }
            case BOMBARD: {
                goalDesc = "a saturation bombardment of the colony";
                goalHL = "saturation bombardment of the colony";
                goalColor = Misc.getNegativeHighlightColor();
            }
        }
        String strDesc = this.getRaidStrDesc();
        int numFleets = (int)this.getOrigNumFleets();
        String fleets = "fleets";
        if (numFleets == 1) {
            fleets = "fleet";
        }
        if (this.outcome == null) {
            LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + " targeting %s with a " + strDesc + " expeditionary force, projected to be comprised of " + numFleets + " " + fleets + ". " + "Its likely goal is " + goalDesc + ".", initPad, faction.getBaseUIColor(), this.target.getName());
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), this.target.getName(), strDesc, "" + numFleets, goalHL);
            label.setHighlightColors(faction.getBaseUIColor(), this.targetFaction.getBaseUIColor(), h, h, goalColor);
        } else {
            LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + " targeting %s with an expeditionary force. " + "Its likely goal is " + goalDesc + ".", initPad, faction.getBaseUIColor(), this.target.getName());
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), this.target.getName(), goalHL);
            label.setHighlightColors(faction.getBaseUIColor(), this.targetFaction.getBaseUIColor(), goalColor);
        }
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        FactionAPI faction = this.getFaction();
        String has = faction.getDisplayNameHasOrHave();
        String is = faction.getDisplayNameIsOrAre();
        this.addInitialDescSection(info, opad);
        if (this.bestReason.type == PunitiveExpeditionManager.PunExType.ANTI_COMPETITION && this.bestReason.commodityId != null) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.bestReason.commodityId);
            info.addPara("The primary reason for the expedition is the colony's market share in the exports of " + spec.getName() + ".", opad);
        } else if (this.bestReason.type == PunitiveExpeditionManager.PunExType.ANTI_FREE_PORT) {
            info.addPara("The primary reason for the expedition is the colony's \"free port\" status, and the concomitant export of illegal goods alongside it being a haven for various undesirables.", opad);
        } else if (this.bestReason.type == PunitiveExpeditionManager.PunExType.TERRITORIAL) {
            info.addPara("The primary reason for the expedition is the colony being established in space claimed by " + faction.getDisplayNameWithArticle() + ".", opad);
        }
        if (this.outcome == null) {
            this.addStandardStrengthComparisons(info, this.target, this.targetFaction, this.goal != PunitiveExpeditionManager.PunExGoal.BOMBARD, this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD, "expedition", "expedition's");
        }
        info.addSectionHeading("Status", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        for (RaidIntel.RaidStage stage : this.stages) {
            stage.showStageInfo(info);
            if (this.getStageIndex(stage) == this.failStage) break;
        }
        if (this.getCurrentStage() == 0 && !this.isFailed()) {
            FactionAPI pf = Global.getSector().getPlayerFaction();
            ButtonAPI button = info.addButton("Avert", BUTTON_AVERT, pf.getBaseUIColor(), pf.getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
            button.setShortcut(20, true);
        }
        if (!this.from.getFaction().isHostileTo(this.targetFaction) && !this.isFailed()) {
            LabelAPI label = info.addPara("This operation is being carried without an open declaration of war. Defeating the expeditionary force will only result in a small reputation reduction with " + faction.getDisplayNameWithArticle() + ".", Misc.getGrayColor(), opad);
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(faction.getBaseUIColor());
        }
    }

    @Override
    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, boolean onlyIfImportant, boolean sendIfHidden) {
        if (listInfoParam == UPDATE_RETURNING) {
            return;
        }
        if (listInfoParam == UPDATE_FAILED) {
            this.applyRepPenalty();
        }
        super.sendUpdateIfPlayerHasIntel(listInfoParam, onlyIfImportant, sendIfHidden);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        tags.add("Colony threats");
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
        PunitiveExpeditionManager.PunExData data;
        if (this.outcome == null && this.failStage >= 0) {
            this.outcome = !this.target.isInEconomy() || !this.target.isPlayerOwned() ? PunExOutcome.COLONY_NO_LONGER_EXISTS : PunExOutcome.TASK_FORCE_DEFEATED;
        }
        if ((data = PunitiveExpeditionManager.getInstance().getDataFor(this.faction)) != null && this.outcome == PunExOutcome.SUCCESS) {
            ++data.numSuccesses;
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    public PunitiveExpeditionManager.PunExGoal getGoal() {
        return this.goal;
    }

    public Industry getTargetIndustry() {
        return this.targetIndustry;
    }

    public PunExOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(PunExOutcome outcome) {
        this.outcome = outcome;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = route.getRandom();
        MarketAPI market = route.getMarket();
        CampaignFleetAPI fleet = this.createFleet(market.getFactionId(), route, market, null, random);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        market.getContainingLocation().addEntity(fleet);
        fleet.setFacing((float)Math.random() * 360.0f);
        fleet.setLocation(market.getPrimaryEntity().getLocation().x, market.getPrimaryEntity().getLocation().x);
        fleet.addScript(this.createAssignmentAI(fleet, route));
        return fleet;
    }

    @Override
    public CampaignFleetAPI createFleet(String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        if (random == null) {
            random = new Random();
        }
        RouteManager.OptionalFleetData extra = route.getExtra();
        float combat = extra.fp.floatValue();
        float tanker = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float transport = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float freighter = 0.0f;
        if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            tanker += transport;
        } else {
            transport += tanker / 2.0f;
            tanker *= 0.5f;
        }
        combat -= tanker;
        FleetParamsV3 params = new FleetParamsV3(market, locInHyper, factionId, route == null ? null : route.getQualityOverride(), extra.fleetType, combat -= transport, freighter, tanker, transport, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isWarFleet", true);
        fleet.getMemoryWithoutUpdate().set("$isRaider", true);
        if (fleet.getFaction().getCustomBoolean("pirateBehavior")) {
            fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        }
        String postId = Ranks.POST_PATROL_COMMANDER;
        String rankId = Ranks.SPACE_COMMANDER;
        fleet.getCommander().setPostId(postId);
        fleet.getCommander().setRankId(rankId);
        Misc.makeNoRepImpact(fleet, "punex");
        Misc.makeHostile(fleet);
        return fleet;
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_AVERT) {
            ui.showDialog(null, new PEAvertInteractionDialogPluginImpl(this, ui));
        }
    }

    public PunitiveExpeditionManager.PunExReason getBestReason() {
        return this.bestReason;
    }

    public boolean isTerritorial() {
        return this.bestReason != null && this.bestReason.type == PunitiveExpeditionManager.PunExType.TERRITORIAL;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.target != null && this.target.isInEconomy() && this.target.getPrimaryEntity() != null) {
            return this.target.getPrimaryEntity();
        }
        return super.getMapLocation(map);
    }

    public static enum PunExOutcome {
        TASK_FORCE_DEFEATED,
        COLONY_NO_LONGER_EXISTS,
        SUCCESS,
        BOMBARD_FAIL,
        RAID_FAIL,
        AVERTED;

    }
}

