/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetActionTextProvider;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.Misc;

public class RaidAssignmentAI
extends RouteFleetAssignmentAI
implements FleetActionTextProvider {
    public RaidAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route, BaseAssignmentAI.FleetActionDelegate delegate) {
        super(fleet, route, delegate);
        fleet.getAI().setActionTextProvider(this);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount, false);
        RouteManager.RouteSegment curr = this.route.getCurrent();
        if (curr != null && ("raid_straggler".equals(this.route.getCustom()) || "wait_stage".equals(curr.custom) || curr.isTravel())) {
            Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", "raid_wait", true, 1.0f);
        }
        this.checkCapture(amount);
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$isRaider")) {
            this.checkRaid(amount);
        }
    }

    @Override
    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        if ("wait_stage".equals(segment.custom)) {
            return "waiting at rendezvous point";
        }
        String s = null;
        if (this.delegate != null) {
            s = this.delegate.getRaidInSystemText(this.fleet);
        }
        if (s == null) {
            s = "raiding";
        }
        return s;
    }

    @Override
    protected String getEndingActionText(RouteManager.RouteSegment segment) {
        return super.getEndingActionText(segment);
    }

    @Override
    protected String getStartingActionText(RouteManager.RouteSegment segment) {
        if ("prep_stage".equals(segment.custom)) {
            String s = null;
            if (this.delegate != null) {
                s = this.delegate.getRaidPrepText(this.fleet, segment.from);
            }
            if (s == null) {
                s = "preparing for raid";
            }
            return s;
        }
        if (segment.from == this.route.getMarket().getPrimaryEntity()) {
            return "orbiting " + this.route.getMarket().getName();
        }
        String s = null;
        if (this.delegate != null) {
            s = this.delegate.getRaidDefaultText(this.fleet);
        }
        if (s == null) {
            s = "raiding";
        }
        return s;
    }

    @Override
    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        return super.getTravelActionText(segment);
    }

    @Override
    public String getActionText(CampaignFleetAPI fleet) {
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null && curr.getAssignment() == FleetAssignment.PATROL_SYSTEM && curr.getActionText() == null) {
            String s = null;
            if (this.delegate != null) {
                s = this.delegate.getRaidDefaultText(fleet);
            }
            if (s == null) {
                s = "raiding";
            }
            return s;
        }
        return null;
    }
}

