/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionHub;
import com.fs.starfarer.api.loading.PersonMissionSpec;
import java.util.Random;

public class BaseHubMissionCreator
implements HubMissionCreator {
    protected int numCompleted = 0;
    protected int numFailed = 0;
    protected long seed;
    protected transient Random genRandom = null;
    protected transient PersonMissionSpec spec = null;
    protected String specId = null;
    protected boolean wasAutoAdded = false;
    protected boolean isActive = true;

    public BaseHubMissionCreator(PersonMissionSpec spec) {
        this.spec = spec;
        if (spec != null) {
            this.specId = spec.getMissionId();
        }
    }

    protected Object readResolve() {
        this.spec = Global.getSettings().getMissionSpec(this.specId);
        return this;
    }

    @Override
    public PersonMissionSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getSpecId() {
        return this.specId;
    }

    @Override
    public HubMission createHubMission(MissionHub hub) {
        return this.spec.createMission();
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public void updateRandom() {
        this.genRandom = new Random(this.seed);
    }

    @Override
    public void incrCompleted() {
        ++this.numCompleted;
    }

    @Override
    public int getNumCompleted() {
        return this.numCompleted;
    }

    @Override
    public void setNumCompleted(int numCompleted) {
        this.numCompleted = numCompleted;
    }

    @Override
    public void incrFailed() {
        ++this.numFailed;
    }

    @Override
    public int getNumFailed() {
        return this.numFailed;
    }

    @Override
    public void setNumFailed(int numFailed) {
        this.numFailed = numFailed;
    }

    @Override
    public float getFrequencyWeight() {
        return this.spec.getFreq();
    }

    @Override
    public float getWasShownTimeoutDuration() {
        return 0.0f;
    }

    @Override
    public float getAcceptedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    @Override
    public float getCompletedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    @Override
    public float getFailedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    @Override
    public boolean isPriority() {
        return this.spec.hasTag("priority");
    }

    @Override
    public boolean matchesRep(float rep) {
        RepLevel level = RepLevel.getLevelFor(rep);
        if (this.spec.getMinRep() != null && !level.isAtWorst(this.spec.getMinRep())) {
            return false;
        }
        return this.spec.getMaxRep() == null || level.isAtBest(this.spec.getMaxRep());
    }

    @Override
    public Random getGenRandom() {
        return this.genRandom;
    }

    @Override
    public boolean wasAutoAdded() {
        return this.wasAutoAdded;
    }

    @Override
    public void setWasAutoAdded(boolean wasAutoAdded) {
        this.wasAutoAdded = wasAutoAdded;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

