/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class MagFieldGenPlugin
implements TerrainGenPlugin {
    public static Color[] baseColors = new Color[]{new Color(50, 25, 100, 70)};
    public static Color[][] auroraColors = new Color[][]{{new Color(140, 100, 235), new Color(180, 110, 210), new Color(150, 140, 190), new Color(140, 190, 210), new Color(90, 200, 170), new Color(65, 230, 160), new Color(20, 220, 70)}, {new Color(50, 20, 110, 130), new Color(150, 30, 120, 150), new Color(200, 50, 130, 190), new Color(250, 70, 150, 240), new Color(200, 80, 130, 255), new Color(75, 0, 160), new Color(127, 0, 255)}, {new Color(90, 180, 140), new Color(130, 145, 190), new Color(165, 110, 225), new Color(95, 55, 240), new Color(45, 0, 250), new Color(20, 0, 240), new Color(10, 0, 150)}, {new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}, {new Color(50, 20, 110, 130), new Color(150, 30, 120, 150), new Color(200, 50, 130, 190), new Color(250, 70, 150, 240), new Color(200, 80, 130, 255), new Color(75, 0, 160), new Color(127, 0, 255)}, {new Color(55, 60, 140), new Color(65, 85, 155), new Color(175, 105, 165), new Color(90, 130, 180), new Color(105, 150, 190), new Color(120, 175, 205), new Color(135, 200, 220)}};
    public static final float WIDTH_PLANET = 200.0f;
    public static final float WIDTH_STAR = 400.0f;

    @Override
    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        StarSystemAPI system = context.system;
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        boolean isStar = false;
        boolean hasAtmosphere = false;
        if (parent instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)parent;
            isStar = planet.isStar();
            hasAtmosphere = planet.getSpec().getAtmosphereThickness() > 0.0f;
        } else if (parent == context.system.getCenter()) {
            isStar = true;
        }
        if (context.parent != null) {
            parent = context.parent;
        }
        int baseIndex = (int)((double)baseColors.length * StarSystemGenerator.random.nextDouble());
        int auroraIndex = (int)((double)auroraColors.length * StarSystemGenerator.random.nextDouble());
        float bandWidth = parent.getRadius() + 200.0f;
        float midRadius = (parent.getRadius() + 200.0f) / 2.0f;
        float visStartRadius = parent.getRadius();
        float visEndRadius = parent.getRadius() + 200.0f + 50.0f;
        float auroraProbability = 0.0f;
        float orbitalWidth = 200.0f;
        if (isStar || context.orbitIndex > 0) {
            bandWidth = 400.0f;
            midRadius = context.currentRadius + bandWidth / 2.0f;
            visStartRadius = context.currentRadius;
            visEndRadius = context.currentRadius + bandWidth;
            orbitalWidth = 400.0f;
            auroraProbability = isStar ? 1.0f : 0.25f + 0.75f * StarSystemGenerator.random.nextFloat();
        } else if (hasAtmosphere) {
            auroraProbability = 0.25f + 0.75f * StarSystemGenerator.random.nextFloat();
        }
        SectorEntityToken magField = system.addTerrain("magnetic_field", new MagneticFieldTerrainPlugin.MagneticFieldParams(bandWidth, midRadius, parent, visStartRadius, visEndRadius, baseColors[baseIndex], auroraProbability, auroraColors[auroraIndex]));
        magField.setCircularOrbit(parent, 0.0f, 0.0f, 100.0f);
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = !isStar;
        result.orbitalWidth = orbitalWidth;
        result.entities.add(magField);
        return result;
    }

    @Override
    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && terrainData.getId().equals("magnetic_field");
    }
}

