/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoPickerListener;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class ZGRTurnIn
extends BaseCommandPlugin {
    public static float VALUE_MULT = 3.0f;
    public static float REP_MULT = 0.2f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected PersonAPI person;
    protected FactionAPI faction;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = ZGRTurnIn.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.person = dialog.getInteractionTarget().getActivePerson();
        this.faction = this.person.getFaction();
        if (command.equals("selectSellableItems")) {
            this.selectSellableItems();
        } else if (command.equals("playerHasSellableItems")) {
            return this.playerHasSellableItems();
        }
        return true;
    }

    protected void selectSellableItems() {
        CargoAPI copy = this.getSellableItems();
        float width = 310.0f;
        this.dialog.showCargoPickerDialog("Select items to turn in", "Confirm", "Cancel", true, 310.0f, copy, new CargoPickerListener(){

            @Override
            public void pickedCargo(CargoAPI cargo) {
                if (cargo.isEmpty()) {
                    this.cancelledCargoSelection();
                    return;
                }
                cargo.sort();
                float bountyThreat = 0.0f;
                float bountyMonster = 0.0f;
                MemoryAPI mem = Global.getSector().getPlayerMemoryWithoutUpdate();
                for (CargoStackAPI stack : cargo.getStacksCopy()) {
                    ZGRTurnIn.this.playerCargo.removeItems(stack.getType(), stack.getData(), stack.getSize());
                    int num = (int)stack.getSize();
                    AddRemoveCommodity.addStackLossText(stack, ZGRTurnIn.this.text);
                    if (ZGRTurnIn.isThreatStack(stack)) {
                        bountyThreat += (float)(num * stack.getBaseValuePerUnit()) * VALUE_MULT;
                        continue;
                    }
                    if (!ZGRTurnIn.isMonsterStack(stack)) continue;
                    bountyMonster += (float)(num * stack.getBaseValuePerUnit()) * VALUE_MULT;
                }
                float repChange = ZGRTurnIn.this.computeReputationValue(cargo);
                int bounty = (int)(bountyThreat + bountyMonster);
                if (bounty > 0) {
                    ZGRTurnIn.this.playerCargo.getCredits().add(bounty);
                    AddRemoveCommodity.addCreditsGainText(bounty, ZGRTurnIn.this.text);
                    String soldTotalKey = "$itemValueSoldToZGRThreat";
                    int curr = mem.getInt(soldTotalKey);
                    curr = (int)((float)curr + bountyThreat);
                    mem.set(soldTotalKey, curr);
                    soldTotalKey = "$itemValueSoldToZGRMonster";
                    curr = mem.getInt(soldTotalKey);
                    curr = (int)((float)curr + bountyMonster);
                    mem.set(soldTotalKey, curr);
                    soldTotalKey = "$itemValueSoldToZGRTotal";
                    curr = mem.getInt(soldTotalKey);
                    mem.set(soldTotalKey, curr += bounty);
                }
                if (repChange >= 1.0f) {
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = repChange * 0.01f;
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, ZGRTurnIn.this.text, true), ZGRTurnIn.this.faction.getId());
                    impact.delta *= 0.25f;
                    if (impact.delta >= 0.01f) {
                        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, ZGRTurnIn.this.text, true), ZGRTurnIn.this.person);
                    }
                }
                mem.set("$itemValueSoldToZGRJustNowThreat", (int)bountyThreat, 0.0f);
                mem.set("$itemValueSoldToZGRJustNowMonster", (int)bountyMonster, 0.0f);
                mem.set("$itemValueSoldToZGRJustNowTotal", bounty, 0.0f);
                FireBest.fire(null, ZGRTurnIn.this.dialog, ZGRTurnIn.this.memoryMap, "ZGRItemsTurnedIn");
            }

            @Override
            public void cancelledCargoSelection() {
            }

            @Override
            public void recreateTextPanel(TooltipMakerAPI panel, CargoAPI cargo, CargoStackAPI pickedUp, boolean pickedUpFromSource, CargoAPI combined) {
                float bounty = 0.0f;
                for (CargoStackAPI stack : combined.getStacksCopy()) {
                    int num = (int)stack.getSize();
                    bounty += (float)(num * stack.getBaseValuePerUnit()) * VALUE_MULT;
                }
                float repChange = ZGRTurnIn.this.computeReputationValue(combined);
                float pad = 3.0f;
                float small = 5.0f;
                float opad = 10.0f;
                panel.setParaFontOrbitron();
                panel.addPara(Misc.ucFirst(ZGRTurnIn.this.faction.getDisplayName()), ZGRTurnIn.this.faction.getBaseUIColor(), 1.0f);
                panel.setParaFontDefault();
                panel.addImage(ZGRTurnIn.this.faction.getLogo(), 310.0f, 3.0f);
                panel.addPara("If you turn in the selected items, you will receive a %s bounty and your standing with " + ZGRTurnIn.this.faction.getDisplayNameWithArticle() + " will improve by %s points.", opad * 1.0f, Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(bounty)) + "\u00a2", "" + (int)repChange);
            }
        });
    }

    protected float computeReputationValue(CargoAPI cargo) {
        float rep = 0.0f;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            rep += ZGRTurnIn.getBaseRepValue(stack) * stack.getSize();
        }
        return rep *= REP_MULT;
    }

    public static float getBaseRepValue(CargoStackAPI stack) {
        if (stack.isWeaponStack()) {
            switch (stack.getWeaponSpecIfWeapon().getSize()) {
                case LARGE: {
                    return 3.0f;
                }
                case MEDIUM: {
                    return 2.0f;
                }
                case SMALL: {
                    return 1.0f;
                }
            }
        }
        if (stack.isSpecialStack()) {
            return 5.0f;
        }
        return 1.0f;
    }

    protected boolean playerHasSellableItems() {
        return !this.getSellableItems().isEmpty();
    }

    public static boolean isThreatStack(CargoStackAPI stack) {
        boolean match = false;
        match |= stack.isWeaponStack() && stack.getWeaponSpecIfWeapon().hasTag("threat");
        return match |= stack.isSpecialStack() && stack.getSpecialItemSpecIfSpecial().hasTag("threat");
    }

    public static boolean isMonsterStack(CargoStackAPI stack) {
        boolean match = false;
        match |= stack.isWeaponStack() && stack.getWeaponSpecIfWeapon().hasTag("monster");
        return match |= stack.isSpecialStack() && stack.getSpecialItemSpecIfSpecial().hasTag("monster");
    }

    protected CargoAPI getSellableItems() {
        CargoAPI copy = Global.getFactory().createCargo(false);
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            boolean match;
            boolean bl = match = ZGRTurnIn.isThreatStack(stack) || ZGRTurnIn.isMonsterStack(stack);
            if (!match) continue;
            copy.addFromStack(stack);
        }
        copy.sort();
        return copy;
    }
}

