/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeProfitabilityData;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PlayerTradeDataForSubmarket {
    private Map<String, MutableStatWithTempMods> tx = new HashMap<String, MutableStatWithTempMods>();
    private CargoAPI playerBought;
    private CargoAPI playerSold;
    private float accumulatedPlayerTradeValueForPositive = 0.0f;
    private float accumulatedPlayerTradeValueForNegative = 0.0f;
    private float totalPlayerTradeValue = 0.0f;
    private IntervalUtil tracker;
    private Map<String, BaseSubmarketPlugin.ShipSalesData> playerBoughtShips = new LinkedHashMap<String, BaseSubmarketPlugin.ShipSalesData>();
    private Map<String, BaseSubmarketPlugin.ShipSalesData> playerSoldShips = new LinkedHashMap<String, BaseSubmarketPlugin.ShipSalesData>();
    private MarketAPI market;
    private SubmarketAPI submarket;

    public PlayerTradeDataForSubmarket(SubmarketAPI submarket) {
        this.market = submarket.getMarket();
        this.submarket = submarket;
        this.playerBought = Global.getFactory().createCargo(true);
        this.playerSold = Global.getFactory().createCargo(true);
        this.tracker = Misc.createEconIntervalTracker();
    }

    protected Object readResolve() {
        if (this.tx == null) {
            this.tx = new HashMap<String, MutableStatWithTempMods>();
        }
        return this;
    }

    public static String getTXId(CargoStackAPI stack) {
        return String.valueOf(stack.getType().name()) + "_" + stack.getData().toString();
    }

    public static String getTXId(BaseSubmarketPlugin.ShipSalesData data) {
        return data.getVariantId();
    }

    public MutableStatWithTempMods getStat(String id) {
        MutableStatWithTempMods stat = this.tx.get(id);
        if (stat == null) {
            stat = new MutableStatWithTempMods(0.0f);
            this.tx.put(id, stat);
        }
        return stat;
    }

    public void advance(float days) {
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            float factor = 0.5f;
            for (CargoStackAPI stack : this.playerBought.getStacksCopy()) {
                stack.setSize(stack.getSize() * factor);
                if (!(stack.getSize() < 10.0f)) continue;
                stack.setSize(0.0f);
            }
            this.playerBought.removeEmptyStacks();
            for (CargoStackAPI stack : this.playerSold.getStacksCopy()) {
                stack.setSize(stack.getSize() * factor);
                if (!(stack.getSize() < 10.0f)) continue;
                stack.setSize(0.0f);
            }
            this.playerSold.removeEmptyStacks();
            ArrayList<String> remove = new ArrayList<String>();
            for (BaseSubmarketPlugin.ShipSalesData data : this.playerBoughtShips.values()) {
                data.setNumShips(data.getNumShips() * factor);
                data.setTotalValue(data.getTotalValue() * factor);
                if (!(data.getNumShips() < 0.2f)) continue;
                remove.add(data.getVariantId());
            }
            for (String vid : remove) {
                this.playerBoughtShips.remove(vid);
            }
            remove.clear();
            for (BaseSubmarketPlugin.ShipSalesData data : this.playerSoldShips.values()) {
                data.setNumShips(data.getNumShips() * factor);
                data.setTotalValue(data.getTotalValue() * factor);
                if (!(data.getNumShips() < 0.2f)) continue;
                remove.add(data.getVariantId());
            }
            for (String vid : remove) {
                this.playerSoldShips.remove(vid);
            }
            remove.clear();
            this.accumulatedPlayerTradeValueForPositive *= factor;
            this.accumulatedPlayerTradeValueForNegative *= factor;
            this.totalPlayerTradeValue *= factor;
        }
    }

    public void addTransaction(PlayerMarketTransaction transaction) {
        for (CargoStackAPI stack : transaction.getSold().getStacksCopy()) {
            this.addToTrackedPlayerSold(stack);
        }
        for (CargoStackAPI stack : transaction.getBought().getStacksCopy()) {
            this.addToTrackedPlayerBought(stack);
        }
        for (PlayerMarketTransaction.ShipSaleInfo info : transaction.getShipsBought()) {
            this.addToTrackedPlayerBought(info);
        }
        for (PlayerMarketTransaction.ShipSaleInfo info : transaction.getShipsSold()) {
            this.addToTrackedPlayerSold(info);
        }
    }

    private float getTransponderMult() {
        boolean tOn = Global.getSector().getPlayerFleet().isTransponderOn();
        float mult = 1.0f;
        if (!tOn) {
            mult = Global.getSettings().getFloat("transponderOffMarketAwarenessMult");
        }
        return mult;
    }

    public void addToTrackedPlayerBought(PlayerMarketTransaction.ShipSaleInfo info) {
        String vid = info.getMember().getVariant().getHullSpec().getHullId();
        BaseSubmarketPlugin.ShipSalesData bought = this.getBoughtShipData(vid);
        BaseSubmarketPlugin.ShipSalesData sold = this.getSoldShipData(vid);
        float playerImpactMult = Global.getSettings().getFloat("economyPlayerTradeImpactMult");
        float fractionBought = 1.0f;
        if (sold.getNumShips() > 0.0f) {
            fractionBought = Math.max(0.0f, fractionBought - sold.getNumShips());
            sold.setNumShips(sold.getNumShips() - 1.0f);
            sold.setTotalValue(sold.getTotalValue() - (1.0f - fractionBought) * info.getPrice() * playerImpactMult);
            if (sold.getNumShips() < 0.0f) {
                sold.setNumShips(0.0f);
            }
            if (sold.getTotalValue() < 0.0f) {
                sold.setTotalValue(0.0f);
            }
        }
        if (fractionBought > 0.0f) {
            this.accumulatedPlayerTradeValueForPositive += info.getPrice() * playerImpactMult * fractionBought * this.getTransponderMult();
            this.accumulatedPlayerTradeValueForNegative += info.getPrice() * playerImpactMult * fractionBought * this.getTransponderMult();
            this.totalPlayerTradeValue += info.getPrice() * playerImpactMult * fractionBought * this.getTransponderMult();
            bought.setNumShips(bought.getNumShips() + 1.0f * fractionBought);
            bought.setTotalValue(bought.getTotalValue() + info.getPrice() * playerImpactMult * fractionBought);
        }
    }

    public void addToTrackedPlayerSold(PlayerMarketTransaction.ShipSaleInfo info) {
        String vid = info.getMember().getVariant().getHullSpec().getHullId();
        BaseSubmarketPlugin.ShipSalesData bought = this.getBoughtShipData(vid);
        BaseSubmarketPlugin.ShipSalesData sold = this.getSoldShipData(vid);
        float playerImpactMult = Global.getSettings().getFloat("economyPlayerTradeImpactMult");
        float fractionSold = 1.0f;
        if (bought.getNumShips() > 0.0f) {
            fractionSold = Math.max(0.0f, fractionSold - bought.getNumShips());
            bought.setNumShips(bought.getNumShips() - 1.0f);
            bought.setTotalValue(bought.getTotalValue() - (1.0f - fractionSold) * info.getPrice() * playerImpactMult);
            if (bought.getNumShips() < 0.0f) {
                bought.setNumShips(0.0f);
            }
            if (bought.getTotalValue() < 0.0f) {
                bought.setTotalValue(0.0f);
            }
        }
        if (fractionSold > 0.0f) {
            this.accumulatedPlayerTradeValueForPositive += info.getPrice() * playerImpactMult * fractionSold * this.getTransponderMult();
            this.accumulatedPlayerTradeValueForNegative += info.getPrice() * playerImpactMult * fractionSold * this.getTransponderMult();
            this.totalPlayerTradeValue += info.getPrice() * playerImpactMult * fractionSold * this.getTransponderMult();
            sold.setNumShips(sold.getNumShips() + 1.0f * fractionSold);
            sold.setTotalValue(sold.getTotalValue() + info.getPrice() * playerImpactMult * fractionSold);
        }
    }

    public void addToTrackedPlayerBought(CargoStackAPI stack) {
        float qty = stack.getSize() - this.playerSold.getQuantity(stack.getType(), stack.getData());
        float impact = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadyBought(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
        this.accumulatedPlayerTradeValueForPositive += impact * this.getTransponderMult();
        this.accumulatedPlayerTradeValueForNegative += impact * this.getTransponderMult();
        this.totalPlayerTradeValue += impact * this.getTransponderMult();
        this.playerBought.addItems(stack.getType(), stack.getData(), stack.getSize());
        this.playerSold.removeItems(stack.getType(), stack.getData(), stack.getSize());
        if (qty >= 1.0f && stack.getType() == CargoAPI.CargoItemType.RESOURCES) {
            PlayerTradeProfitabilityData data = SharedData.getData().getPlayerActivityTracker().getProfitabilityData();
            float price = PlayerTradeDataForSubmarket.computePriceOfHavingAlreadyBought(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            data.reportNetBought((String)stack.getData(), qty, price);
        }
    }

    public void addToTrackedPlayerSold(CargoStackAPI stack) {
        this.addToTrackedPlayerSold(stack, -1.0f);
    }

    public void addToTrackedPlayerSold(CargoStackAPI stack, float totalPriceOverride) {
        float qty = stack.getSize() - this.playerBought.getQuantity(stack.getType(), stack.getData());
        float impact = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadySold(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
        this.playerSold.addItems(stack.getType(), stack.getData(), stack.getSize());
        this.playerBought.removeItems(stack.getType(), stack.getData(), stack.getSize());
        float overrideImpactMult = 1.0f;
        if (qty >= 1.0f && stack.getType() == CargoAPI.CargoItemType.RESOURCES) {
            PlayerTradeProfitabilityData data = SharedData.getData().getPlayerActivityTracker().getProfitabilityData();
            float price = PlayerTradeDataForSubmarket.computePriceOfHavingAlreadySold(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            if (totalPriceOverride > 0.0f) {
                if (price > 0.0f) {
                    overrideImpactMult = totalPriceOverride / price;
                }
                price = totalPriceOverride;
            }
            data.reportNetSold((String)stack.getData(), qty, price);
        }
        this.accumulatedPlayerTradeValueForPositive += impact * this.getTransponderMult() * overrideImpactMult;
        this.accumulatedPlayerTradeValueForNegative += impact * this.getTransponderMult() * overrideImpactMult;
        this.totalPlayerTradeValue += impact * this.getTransponderMult() * overrideImpactMult;
    }

    public static float computeImpactOfHavingAlreadySold(MarketAPI market, CargoAPI.CargoItemType type, Object data, float baseValue, float qty) {
        if (qty < 1.0f) {
            return 0.0f;
        }
        float playerImpactMult = Global.getSettings().getFloat("economyPlayerTradeImpactMult");
        float illegalImpactMult = Global.getSettings().getFloat("economyPlayerSellIllegalImpactMult");
        float militaryImpactMult = Global.getSettings().getFloat("economyPlayerSellMilitaryImpactMult");
        if (type == CargoAPI.CargoItemType.RESOURCES) {
            String commodityId = (String)data;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            float val = market.getDemandPriceAssumingExistingTransaction(commodityId, qty, -qty * com.getUtilityOnMarket(), true);
            if (!market.hasCondition("free_market") && market.isIllegal(commodityId)) {
                val *= illegalImpactMult;
            }
            val *= playerImpactMult;
            String multId = Stats.getPlayerTradeRepImpactMultId(commodityId);
            val *= market.getStats().getDynamic().getValue(multId);
            multId = Stats.getPlayerSellRepImpactMultId(commodityId);
            val *= market.getStats().getDynamic().getValue(multId);
            if (com.getCommodity().hasTag("military")) {
                val *= militaryImpactMult;
            }
            return val;
        }
        float val = baseValue * qty * playerImpactMult;
        return val;
    }

    public static float computePriceOfHavingAlreadySold(MarketAPI market, CargoAPI.CargoItemType type, Object data, float baseValue, float qty) {
        if (qty < 1.0f) {
            return 0.0f;
        }
        if (type == CargoAPI.CargoItemType.RESOURCES) {
            String commodityId = (String)data;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            float val = market.getDemandPriceAssumingExistingTransaction(commodityId, qty, -qty * com.getUtilityOnMarket(), true);
            return val;
        }
        float val = baseValue * qty;
        return val;
    }

    public static float computeImpactOfHavingAlreadyBought(MarketAPI market, CargoAPI.CargoItemType type, Object data, float baseValue, float qty) {
        if (qty < 1.0f) {
            return 0.0f;
        }
        float playerImpactMult = Global.getSettings().getFloat("economyPlayerTradeImpactMult");
        if (type == CargoAPI.CargoItemType.RESOURCES) {
            String commodityId = (String)data;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            float val = market.getSupplyPriceAssumingExistingTransaction(commodityId, qty, qty * com.getUtilityOnMarket(), true);
            val *= playerImpactMult;
            String multId = Stats.getPlayerTradeRepImpactMultId(commodityId);
            val *= market.getStats().getDynamic().getValue(multId);
            multId = Stats.getPlayerBuyRepImpactMultId(commodityId);
            return val *= market.getStats().getDynamic().getValue(multId);
        }
        float val = baseValue * qty * playerImpactMult;
        return val;
    }

    public static float computePriceOfHavingAlreadyBought(MarketAPI market, CargoAPI.CargoItemType type, Object data, float baseValue, float qty) {
        if (qty < 1.0f) {
            return 0.0f;
        }
        if (type == CargoAPI.CargoItemType.RESOURCES) {
            String commodityId = (String)data;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            float val = market.getSupplyPriceAssumingExistingTransaction(commodityId, qty, qty * com.getUtilityOnMarket(), true);
            return val;
        }
        float val = baseValue * qty;
        return val;
    }

    public float getTotalPlayerTradeValue() {
        return this.totalPlayerTradeValue;
    }

    public void setTotalPlayerTradeValue(float totalPlayerTradeValue) {
        this.totalPlayerTradeValue = totalPlayerTradeValue;
    }

    public CargoAPI getRecentPlayerBought() {
        return this.playerBought;
    }

    public CargoAPI getRecentPlayerSold() {
        return this.playerSold;
    }

    public float getAccumulatedPlayerTradeValueForPositive() {
        return this.accumulatedPlayerTradeValueForPositive;
    }

    public void setAccumulatedPlayerTradeValueForPositive(float accumulatedPlayerTradeValue) {
        this.accumulatedPlayerTradeValueForPositive = accumulatedPlayerTradeValue;
    }

    public float getAccumulatedPlayerTradeValueForNegative() {
        return this.accumulatedPlayerTradeValueForNegative;
    }

    public void setAccumulatedPlayerTradeValueForNegative(float accumulatedPlayerTradeValueForNegative) {
        this.accumulatedPlayerTradeValueForNegative = accumulatedPlayerTradeValueForNegative;
    }

    public IntervalUtil getTracker() {
        return this.tracker;
    }

    public Collection<BaseSubmarketPlugin.ShipSalesData> getRecentlyPlayerBoughtShips() {
        return this.playerBoughtShips.values();
    }

    public Collection<BaseSubmarketPlugin.ShipSalesData> getRecentlyPlayerSoldShips() {
        return this.playerSoldShips.values();
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public SubmarketAPI getSubmarket() {
        return this.submarket;
    }

    protected BaseSubmarketPlugin.ShipSalesData getSoldShipData(String vid) {
        BaseSubmarketPlugin.ShipSalesData sold = this.playerSoldShips.get(vid);
        if (sold == null) {
            sold = new BaseSubmarketPlugin.ShipSalesData();
            sold.setVariantId(vid);
            this.playerSoldShips.put(vid, sold);
        }
        return sold;
    }

    protected BaseSubmarketPlugin.ShipSalesData getBoughtShipData(String vid) {
        BaseSubmarketPlugin.ShipSalesData bought = this.playerBoughtShips.get(vid);
        if (bought == null) {
            bought = new BaseSubmarketPlugin.ShipSalesData();
            bought.setVariantId(vid);
            this.playerBoughtShips.put(vid, bought);
        }
        return bought;
    }

    public float getRecentBaseTradeValueImpact() {
        float val;
        float qty;
        float total = 0.0f;
        for (CargoStackAPI stack : this.playerBought.getStacksCopy()) {
            qty = stack.getSize();
            val = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadyBought(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            total += val;
        }
        for (CargoStackAPI stack : this.playerSold.getStacksCopy()) {
            qty = stack.getSize();
            if (qty < 1.0f) continue;
            val = PlayerTradeDataForSubmarket.computeImpactOfHavingAlreadySold(this.market, stack.getType(), stack.getData(), stack.getBaseValuePerUnit(), qty);
            total += val;
        }
        return total;
    }

    public void setSubmarket(SubmarketAPI submarket) {
        this.submarket = submarket;
    }
}

